/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.conversions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.nj2k.ExpressionsKt;
import org.jetbrains.kotlin.nj2k.NewJ2kConverterContext;
import org.jetbrains.kotlin.nj2k.RecursiveApplicableConversionBase;
import org.jetbrains.kotlin.nj2k.symbols.JKSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKUniverseClassSymbol;
import org.jetbrains.kotlin.nj2k.symbols.UtilsKt;
import org.jetbrains.kotlin.nj2k.tree.FormattingKt;
import org.jetbrains.kotlin.nj2k.tree.JKCallExpression;
import org.jetbrains.kotlin.nj2k.tree.JKClassAccessExpression;
import org.jetbrains.kotlin.nj2k.tree.JKExpression;
import org.jetbrains.kotlin.nj2k.tree.JKFieldAccessExpression;
import org.jetbrains.kotlin.nj2k.tree.JKFormattingOwner;
import org.jetbrains.kotlin.nj2k.tree.JKQualifiedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\f\u0010\b\u001a\u00020\t*\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/nj2k/conversions/RemoveRedundantQualifiersForCallsConversion;", "Lorg/jetbrains/kotlin/nj2k/RecursiveApplicableConversionBase;", "context", "Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;", "(Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;)V", "applyToElement", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "element", "receiverExpression", "Lorg/jetbrains/kotlin/nj2k/tree/JKExpression;", "kotlin.j2k.new"})
public final class RemoveRedundantQualifiersForCallsConversion
extends RecursiveApplicableConversionBase {
    public RemoveRedundantQualifiersForCallsConversion(@NotNull NewJ2kConverterContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
    }

    @Override
    @NotNull
    public JKTreeElement applyToElement(@NotNull JKTreeElement element3) {
        boolean needRemoveQualifier;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!(element3 instanceof JKQualifiedExpression)) {
            return this.recurse(element3);
        }
        JKExpression receiver2 = this.receiverExpression(((JKQualifiedExpression)element3).getReceiver());
        if (receiver2 instanceof JKClassAccessExpression) {
            v0 = ((JKClassAccessExpression)receiver2).getIdentifier() instanceof JKUniverseClassSymbol;
        } else if (receiver2 instanceof JKFieldAccessExpression ? true : receiver2 instanceof JKCallExpression) {
            JKSymbol jKSymbol = ExpressionsKt.getIdentifier(((JKQualifiedExpression)element3).getSelector());
            v0 = jKSymbol != null ? UtilsKt.isStaticMember(jKSymbol) : false;
        } else {
            v0 = needRemoveQualifier = false;
        }
        if (needRemoveQualifier) {
            element3.invalidate();
            return this.recurse((JKTreeElement)FormattingKt.withFormattingFrom(FormattingKt.withFormattingFrom((JKFormattingOwner)((JKQualifiedExpression)element3).getSelector(), (JKFormattingOwner)((JKQualifiedExpression)element3).getReceiver()), (JKFormattingOwner)element3));
        }
        return this.recurse(element3);
    }

    private final JKExpression receiverExpression(JKExpression $this$receiverExpression) {
        return $this$receiverExpression instanceof JKQualifiedExpression ? ((JKQualifiedExpression)$this$receiverExpression).getSelector() : $this$receiverExpression;
    }
}

