/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.wizard.service;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.externalSystem.KotlinGradleFacade;
import org.jetbrains.kotlin.tools.projectWizard.WizardGradleRunConfiguration;
import org.jetbrains.kotlin.tools.projectWizard.WizardRunConfiguration;
import org.jetbrains.kotlin.tools.projectWizard.core.Context;
import org.jetbrains.kotlin.tools.projectWizard.core.service.BuildSystemAvailabilityWizardServiceKt;
import org.jetbrains.kotlin.tools.projectWizard.core.service.RunConfigurationsService;
import org.jetbrains.kotlin.tools.projectWizard.plugins.buildSystem.BuildSystemType;
import org.jetbrains.kotlin.tools.projectWizard.wizard.service.IdeaWizardService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010\n\u001a\u00020\u0007*\n0\u000bR\u00020\fj\u0002`\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/wizard/service/IdeaRunConfigurationsService;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/RunConfigurationsService;", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/service/IdeaWizardService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "addGradleRunConfiguration", "", "wizardConfiguration", "Lorg/jetbrains/kotlin/tools/projectWizard/WizardGradleRunConfiguration;", "addRunConfigurations", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context$Reader;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Reader;", "configurations", "", "Lorg/jetbrains/kotlin/tools/projectWizard/WizardRunConfiguration;", "kotlin.project-wizard.idea"})
@SourceDebugExtension(value={"SMAP\nIdeaRunConfigurationsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaRunConfigurationsService.kt\norg/jetbrains/kotlin/tools/projectWizard/wizard/service/IdeaRunConfigurationsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1855#2,2:44\n*S KotlinDebug\n*F\n+ 1 IdeaRunConfigurationsService.kt\norg/jetbrains/kotlin/tools/projectWizard/wizard/service/IdeaRunConfigurationsService\n*L\n19#1:44,2\n*E\n"})
public final class IdeaRunConfigurationsService
implements RunConfigurationsService,
IdeaWizardService {
    @NotNull
    private final Project project;

    public IdeaRunConfigurationsService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @Override
    public void addRunConfigurations(@NotNull Context.Reader $this$addRunConfigurations, @NotNull List<? extends WizardRunConfiguration> configurations) {
        Intrinsics.checkNotNullParameter((Object)$this$addRunConfigurations, (String)"<this>");
        Intrinsics.checkNotNullParameter(configurations, (String)"configurations");
        Iterable $this$forEach$iv = configurations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WizardRunConfiguration wizardConfiguration = (WizardRunConfiguration)element$iv;
            boolean bl = false;
            if (!(wizardConfiguration instanceof WizardGradleRunConfiguration) || !BuildSystemAvailabilityWizardServiceKt.isBuildSystemAvailable($this$addRunConfigurations, BuildSystemType.GradleKotlinDsl)) continue;
            this.addGradleRunConfiguration((WizardGradleRunConfiguration)wizardConfiguration);
        }
    }

    private final void addGradleRunConfiguration(WizardGradleRunConfiguration wizardConfiguration) {
        RunManager runManager = RunManager.Companion.getInstance(this.project);
        KotlinGradleFacade kotlinGradleFacade = KotlinGradleFacade.Companion.getInstance();
        if (kotlinGradleFacade == null || (kotlinGradleFacade = kotlinGradleFacade.getRunConfigurationFactory()) == null) {
            return;
        }
        KotlinGradleFacade configurationFactory = kotlinGradleFacade;
        RunnerAndConfigurationSettings ideaConfiguration = runManager.createConfiguration(wizardConfiguration.getConfigurationName(), (ConfigurationFactory)configurationFactory);
        RunConfiguration runConfiguration = ideaConfiguration.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"ideaConfiguration.configuration");
        RunConfiguration runConfiguration2 = runConfiguration;
        if (runConfiguration2 instanceof ExternalSystemRunConfiguration) {
            ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings;
            ExternalSystemTaskExecutionSettings $this$addGradleRunConfiguration_u24lambda_u241 = externalSystemTaskExecutionSettings = ((ExternalSystemRunConfiguration)runConfiguration2).getSettings();
            boolean bl = false;
            $this$addGradleRunConfiguration_u24lambda_u241.setTaskNames(CollectionsKt.listOf((Object)wizardConfiguration.getTaskName()));
            $this$addGradleRunConfiguration_u24lambda_u241.setScriptParameters(CollectionsKt.joinToString$default((Iterable)wizardConfiguration.getParameters(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            $this$addGradleRunConfiguration_u24lambda_u241.setExternalProjectPath(this.project.getBasePath());
            ExternalSystemTaskExecutionSettings $this$addGradleRunConfiguration_u24lambda_u242 = externalSystemTaskExecutionSettings = runManager;
            boolean bl2 = false;
            $this$addGradleRunConfiguration_u24lambda_u242.addConfiguration(ideaConfiguration);
            $this$addGradleRunConfiguration_u24lambda_u242.setSelectedConfiguration(ideaConfiguration);
        }
    }
}

