/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.configurations.ConflictResolution;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.IncompatibleDependencyAttributesMessageBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformDependencyMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformGraphResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleSelectors;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependencies;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolutionConflictTracker;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveOptimizations;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.VirtualPlatformState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CandidateModule;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.SelectorStateResolver;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.AttributeMergingException;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ForcingDependencyMetadata;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModuleResolveState
implements CandidateModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleResolveState.class);
    private static final int MAX_SELECTION_CHANGE = 1000;
    private final ComponentMetaDataResolver metaDataResolver;
    private final IdGenerator<Long> idGenerator;
    private final ModuleIdentifier id;
    private final List<EdgeState> unattachedDependencies = new LinkedList<EdgeState>();
    private final Map<ModuleVersionIdentifier, ComponentState> versions = new LinkedHashMap<ModuleVersionIdentifier, ComponentState>();
    private final ModuleSelectors<SelectorState> selectors;
    private final ConflictResolution conflictResolution;
    private final AttributeDesugaring attributeDesugaring;
    private final ImmutableAttributesFactory attributesFactory;
    private final Comparator<Version> versionComparator;
    private final VersionParser versionParser;
    final ResolveOptimizations resolveOptimizations;
    private final boolean rootModule;
    private SelectorStateResolver<ComponentState> selectorStateResolver;
    private final PendingDependencies pendingDependencies;
    private ComponentState selected;
    private ImmutableAttributes mergedConstraintAttributes = ImmutableAttributes.EMPTY;
    private AttributeMergingException attributeMergingError;
    private VirtualPlatformState platformState;
    private boolean overriddenSelection;
    private Set<VirtualPlatformState> platformOwners;
    private boolean replaced = false;
    private boolean changingSelection;
    private int selectionChangedCounter;

    ModuleResolveState(IdGenerator<Long> idGenerator, ModuleIdentifier id, ComponentMetaDataResolver metaDataResolver, ImmutableAttributesFactory attributesFactory, Comparator<Version> versionComparator, VersionParser versionParser, SelectorStateResolver<ComponentState> selectorStateResolver, ResolveOptimizations resolveOptimizations, boolean rootModule, ConflictResolution conflictResolution, AttributeDesugaring attributeDesugaring) {
        this.idGenerator = idGenerator;
        this.id = id;
        this.metaDataResolver = metaDataResolver;
        this.attributesFactory = attributesFactory;
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
        this.resolveOptimizations = resolveOptimizations;
        this.rootModule = rootModule;
        this.pendingDependencies = new PendingDependencies(id);
        this.selectorStateResolver = selectorStateResolver;
        this.selectors = new ModuleSelectors(versionComparator, versionParser);
        this.conflictResolution = conflictResolution;
        this.attributeDesugaring = attributeDesugaring;
    }

    void setSelectorStateResolver(SelectorStateResolver<ComponentState> selectorStateResolver) {
        this.selectorStateResolver = selectorStateResolver;
    }

    void registerPlatformOwner(VirtualPlatformState owner) {
        if (this.platformOwners == null) {
            this.platformOwners = Sets.newHashSetWithExpectedSize((int)1);
        }
        this.platformOwners.add(owner);
    }

    public Set<VirtualPlatformState> getPlatformOwners() {
        return this.platformOwners == null ? Collections.emptySet() : this.platformOwners;
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public ModuleIdentifier getId() {
        return this.id;
    }

    @Override
    public Collection<ComponentState> getVersions() {
        if (this.versions.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<ComponentState> values = this.versions.values();
        if (ModuleResolveState.areAllCandidatesForSelection(values)) {
            return values;
        }
        ArrayList versions = Lists.newArrayListWithCapacity((int)values.size());
        for (ComponentState componentState : values) {
            if (!componentState.isCandidateForConflictResolution()) continue;
            versions.add(componentState);
        }
        return versions;
    }

    public Collection<ComponentState> getAllVersions() {
        return this.versions.values();
    }

    private static boolean areAllCandidatesForSelection(Collection<ComponentState> values) {
        boolean allCandidates = true;
        for (ComponentState value : values) {
            if (value.isCandidateForConflictResolution()) continue;
            allCandidates = false;
            break;
        }
        return allCandidates;
    }

    @Nullable
    public ComponentState getSelected() {
        return this.selected;
    }

    public void select(ComponentState selected) {
        assert (this.selected == null);
        this.selected = selected;
        this.replaced = false;
        this.selectComponentAndEvictOthers(selected);
    }

    private void selectComponentAndEvictOthers(ComponentState selected) {
        for (ComponentState version : this.versions.values()) {
            version.evict();
        }
        selected.select();
    }

    public boolean isChangingSelection() {
        return this.changingSelection;
    }

    private void changeSelection(ComponentState newSelection) {
        assert (this.selected != null);
        assert (newSelection != null);
        assert (this.selected != newSelection);
        assert (newSelection.getModule() == this);
        this.changingSelection = true;
        this.selected.removeOutgoingEdges();
        this.selected = newSelection;
        this.replaced = false;
        this.doRestart(newSelection);
        this.changingSelection = false;
    }

    public void clearSelection() {
        if (this.selected != null) {
            this.selected.removeOutgoingEdges();
        }
        for (ComponentState version : this.versions.values()) {
            if (!version.isSelected()) continue;
            version.makeSelectable();
        }
        this.selected = null;
        this.replaced = false;
    }

    @Override
    public void replaceWith(ComponentState selected) {
        if (this.selected != null) {
            this.clearSelection();
        }
        assert (this.selected == null);
        assert (selected != null);
        if (!selected.getId().getModule().equals(this.getId())) {
            this.overriddenSelection = true;
        }
        this.selected = selected;
        this.replaced = this.computeReplaced(selected);
        this.doRestart(selected);
    }

    private boolean computeReplaced(ComponentState selected) {
        return !selected.getId().getModule().equals(this.getId());
    }

    private void doRestart(ComponentState selected) {
        this.selectComponentAndEvictOthers(selected);
        for (ComponentState version : this.versions.values()) {
            version.restartIncomingEdges(selected);
        }
        for (SelectorState selector : this.selectors) {
            selector.overrideSelection(selected);
        }
        if (!this.unattachedDependencies.isEmpty()) {
            this.restartUnattachedDependencies();
        }
    }

    private void restartUnattachedDependencies() {
        if (this.unattachedDependencies.size() == 1) {
            EdgeState singleDependency = this.unattachedDependencies.get(0);
            singleDependency.restart();
        } else {
            for (EdgeState dependency : new ArrayList<EdgeState>(this.unattachedDependencies)) {
                dependency.restart();
            }
        }
    }

    public void addUnattachedDependency(EdgeState edge) {
        this.unattachedDependencies.add(edge);
        edge.markUnattached();
    }

    public void removeUnattachedDependency(EdgeState edge) {
        if (this.unattachedDependencies.remove(edge)) {
            edge.markAttached();
        }
    }

    public ComponentState getVersion(ModuleVersionIdentifier id, ComponentIdentifier componentIdentifier) {
        assert (id.getModule().equals(this.id));
        ComponentState moduleRevision = this.versions.get(id);
        if (moduleRevision == null) {
            moduleRevision = new ComponentState(this.idGenerator.generateId(), this, id, componentIdentifier, this.metaDataResolver, this.attributeDesugaring);
            this.versions.put(id, moduleRevision);
        }
        return moduleRevision;
    }

    void addSelector(SelectorState selector, boolean deferSelection) {
        this.selectors.add(selector, deferSelection);
        this.mergedConstraintAttributes = this.appendAttributes(this.mergedConstraintAttributes, selector);
        if (this.overriddenSelection) {
            assert (this.selected != null) : "An overridden module cannot have selected == null";
            selector.overrideSelection(this.selected);
        }
    }

    void removeSelector(SelectorState selector, ResolutionConflictTracker conflictTracker) {
        this.selectors.remove(selector);
        boolean alreadyReused = selector.markForReuse();
        this.mergedConstraintAttributes = ImmutableAttributes.EMPTY;
        for (SelectorState selectorState : this.selectors) {
            this.mergedConstraintAttributes = this.appendAttributes(this.mergedConstraintAttributes, selectorState);
        }
        if (!alreadyReused && this.selectors.size() != 0 && this.selected != null) {
            this.maybeUpdateSelection(conflictTracker);
        }
    }

    public ModuleSelectors<SelectorState> getSelectors() {
        return this.selectors;
    }

    List<EdgeState> getUnattachedDependencies() {
        return this.unattachedDependencies;
    }

    ImmutableAttributes mergedConstraintsAttributes(AttributeContainer append) throws AttributeMergingException {
        if (this.attributeMergingError != null) {
            throw new IllegalStateException(IncompatibleDependencyAttributesMessageBuilder.buildMergeErrorMessage(this, this.attributeMergingError));
        }
        ImmutableAttributes attributes = ((AttributeContainerInternal)append).asImmutable();
        if (this.mergedConstraintAttributes.isEmpty()) {
            return attributes;
        }
        return this.attributesFactory.safeConcat(this.mergedConstraintAttributes.asImmutable(), attributes);
    }

    private ImmutableAttributes appendAttributes(ImmutableAttributes dependencyAttributes, SelectorState selectorState) {
        try {
            DependencyMetadata dependencyMetadata = selectorState.getDependencyMetadata();
            boolean constraint = dependencyMetadata.isConstraint();
            if (constraint) {
                ComponentSelector selector = dependencyMetadata.getSelector();
                ImmutableAttributes attributes = ((AttributeContainerInternal)selector.getAttributes()).asImmutable();
                dependencyAttributes = this.attributesFactory.safeConcat(attributes, dependencyAttributes);
            }
        }
        catch (AttributeMergingException e) {
            this.attributeMergingError = e;
        }
        return dependencyAttributes;
    }

    Set<EdgeState> getIncomingEdges() {
        LinkedHashSet incoming = Sets.newLinkedHashSet();
        if (this.selected != null) {
            for (NodeState nodeState : this.selected.getNodes()) {
                incoming.addAll(nodeState.getIncomingEdges());
            }
        }
        return incoming;
    }

    VirtualPlatformState getPlatformState() {
        if (this.platformState == null) {
            this.platformState = new VirtualPlatformState(this.versionComparator, this.versionParser, this, this.resolveOptimizations);
        }
        return this.platformState;
    }

    boolean isVirtualPlatform() {
        return this.platformState != null && !this.platformState.getParticipatingModules().isEmpty();
    }

    void decreaseHardEdgeCount(NodeState removalSource) {
        this.pendingDependencies.decreaseHardEdgeCount();
        if (this.pendingDependencies.isPending() && this.selected != null) {
            for (NodeState node : this.selected.getNodes()) {
                node.clearConstraintEdges(this.pendingDependencies, removalSource);
            }
        }
    }

    boolean isPending() {
        return this.pendingDependencies.isPending();
    }

    PendingDependencies getPendingDependencies() {
        return this.pendingDependencies;
    }

    void registerConstraintProvider(NodeState node) {
        this.pendingDependencies.registerConstraintProvider(node);
    }

    void unregisterConstraintProvider(NodeState nodeState) {
        this.pendingDependencies.unregisterConstraintProvider(nodeState);
    }

    public void maybeUpdateSelection(ResolutionConflictTracker conflictTracker) {
        if (this.replaced) {
            return;
        }
        if (!this.rootModule && this.selectors.checkDeferSelection()) {
            return;
        }
        ComponentState newSelected = this.selectorStateResolver.selectBest(this.getId(), this.selectors);
        newSelected.setSelectors(this.selectors);
        if (this.selected == null) {
            if (!conflictTracker.hasKnownConflict(newSelected.getId())) {
                this.select(newSelected);
            }
        } else if (newSelected != this.selected) {
            if (++this.selectionChangedCounter > 1000 && this.maybeSkipSelectionChange(newSelected)) {
                return;
            }
            this.changeSelection(newSelected);
        }
    }

    private boolean maybeSkipSelectionChange(ComponentState newSelected) {
        if (this.selectionChangedCounter == 1001) {
            LOGGER.warn("The dependency resolution engine wasn't able to find a version of module {} which satisfied all requirements because the graph wasn't stable enough. The highest version was selected in order to stabilize selection.\nFeatures available in a stable graph like version alignment are not guaranteed in this case.", (Object)this.id);
        }
        boolean newSelectedIsProject = false;
        if (this.conflictResolution == ConflictResolution.preferProjectModules && newSelected.getComponentId() instanceof ProjectComponentIdentifier) {
            newSelectedIsProject = true;
        }
        Version newVersion = this.versionParser.transform(newSelected.getVersion());
        Version currentVersion = this.versionParser.transform(this.selected.getVersion());
        return !newSelectedIsProject && this.versionComparator.compare(newVersion, currentVersion) <= 0;
    }

    void maybeCreateVirtualMetadata(ResolveState resolveState) {
        for (ComponentState componentState : this.versions.values()) {
            if (componentState.getMetadataOrNull() != null) continue;
            componentState.setState(LenientPlatformGraphResolveState.of((ModuleComponentIdentifier)componentState.getComponentId(), componentState.getId(), this.platformState, resolveState.getRoot(), resolveState));
        }
    }

    @Nullable
    String maybeFindForcedPlatformVersion() {
        ComponentState selected = this.getSelected();
        for (NodeState node : selected.getNodes()) {
            if (!node.isSelected()) continue;
            for (EdgeState incomingEdge : node.getIncomingEdges()) {
                DependencyMetadata dependencyMetadata = incomingEdge.getDependencyMetadata();
                if (dependencyMetadata instanceof LenientPlatformDependencyMetadata || !(dependencyMetadata instanceof ForcingDependencyMetadata) || !((ForcingDependencyMetadata)dependencyMetadata).isForce()) continue;
                return selected.getVersion();
            }
        }
        return null;
    }
}

