/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog.problems;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.catalog.problems.VersionCatalogProblem;
import org.gradle.api.internal.catalog.problems.VersionCatalogProblemBuilder;
import org.gradle.api.internal.catalog.problems.VersionCatalogProblemId;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.problems.Solution;
import org.gradle.problems.StandardSeverity;

public class DefaultCatalogProblemBuilder
implements VersionCatalogProblemBuilder,
VersionCatalogProblemBuilder.ProblemWithId,
VersionCatalogProblemBuilder.DescribedProblem,
VersionCatalogProblemBuilder.DescribedProblemWithCause {
    private static final DocumentationRegistry DOCUMENTATION_REGISTRY = new DocumentationRegistry();
    private final VersionCatalogProblemId id;
    private Supplier<String> context;
    private Supplier<String> shortDescription;
    private Supplier<String> longDescription = () -> "";
    private Supplier<String> reason;
    private StandardSeverity severity = StandardSeverity.ERROR;
    private final List<Supplier<String>> solutions = Lists.newArrayListWithExpectedSize((int)1);
    private DocLink docLink;

    private DefaultCatalogProblemBuilder(VersionCatalogProblemId id) {
        this.id = id;
    }

    public static VersionCatalogProblem buildProblem(VersionCatalogProblemId id, Consumer<? super VersionCatalogProblemBuilder> spec) {
        DefaultCatalogProblemBuilder builder = new DefaultCatalogProblemBuilder(id);
        spec.accept(builder);
        return builder.build();
    }

    public static void maybeThrowError(String error, List<VersionCatalogProblem> problems) {
        if (!problems.isEmpty()) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node(error);
            formatter.startChildren();
            for (VersionCatalogProblem problem2 : problems) {
                problem2.reportInto(formatter);
            }
            formatter.endChildren();
            throw new InvalidUserDataException(formatter.toString());
        }
    }

    @Override
    public VersionCatalogProblemBuilder.ProblemWithId inContext(Supplier<String> context) {
        this.context = context;
        return this;
    }

    @Override
    public VersionCatalogProblemBuilder.ProblemWithId withSeverity(StandardSeverity severity) {
        this.severity = severity;
        return this;
    }

    @Override
    public VersionCatalogProblemBuilder.DescribedProblem withShortDescription(Supplier<String> description) {
        this.shortDescription = description;
        return this;
    }

    @Override
    public VersionCatalogProblemBuilder.DescribedProblem withLongDescription(Supplier<String> description) {
        this.longDescription = description;
        return this;
    }

    @Override
    public VersionCatalogProblemBuilder.DescribedProblemWithCause happensBecause(Supplier<String> reason) {
        this.reason = reason;
        return this;
    }

    @Override
    public VersionCatalogProblemBuilder.DescribedProblemWithCause documentedAt(String page, String section) {
        this.docLink = new DocLink(page, section);
        return this;
    }

    @Override
    public VersionCatalogProblemBuilder.DescribedProblemWithCause documented() {
        return this.documentedAt("version_catalog_problems", this.id.name().toLowerCase());
    }

    @Override
    public VersionCatalogProblemBuilder.DescribedProblemWithCause addSolution(Supplier<String> solution) {
        this.solutions.add(solution);
        return this;
    }

    public VersionCatalogProblem build() {
        if (this.context == null) {
            throw new IllegalStateException("You must provide the context of this problem");
        }
        if (this.shortDescription == null) {
            throw new IllegalStateException("You must provide a short description of the problem");
        }
        if (this.reason == null) {
            throw new IllegalStateException("You must provide the reason why this problem happened");
        }
        if (this.solutions.isEmpty()) {
            throw new IllegalStateException("You must provide at least one solution to the problem");
        }
        return new VersionCatalogProblem(this.id, this.severity, this.context.get(), this.shortDescription, this.longDescription, this.reason, () -> this.docLink == null ? null : DOCUMENTATION_REGISTRY.getDocumentationRecommendationFor("information", this.docLink.page, this.docLink.section), this.solutions.stream().map(this::toSolution).collect(Collectors.toList()));
    }

    private Supplier<Solution> toSolution(Supplier<String> solutionText) {
        return () -> new SimpleSolution(solutionText);
    }

    private static class SimpleSolution
    implements Solution {
        private final Supplier<String> descriptor;

        private SimpleSolution(Supplier<String> descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public String getShortDescription() {
            return this.descriptor.get();
        }
    }

    private static class DocLink {
        private final String page;
        private final String section;

        private DocLink(String page, String section) {
            this.page = page;
            this.section = section;
        }
    }
}

