/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.PathValidation;
import org.gradle.api.Project;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.Task;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.DependencyLockingHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.SyncSpec;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.MutationGuards;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.api.internal.artifacts.DependencyManagementServices;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.UnknownProjectFinder;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.DefaultProjectLayout;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.internal.plugins.DefaultObjectConfigurationAction;
import org.gradle.api.internal.plugins.ExtensionContainerInternal;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.project.AbstractPluginAware;
import org.gradle.api.internal.project.CrossProjectConfigurator;
import org.gradle.api.internal.project.CrossProjectModelAccess;
import org.gradle.api.internal.project.DeferredProjectConfiguration;
import org.gradle.api.internal.project.DynamicLookupRoutine;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectOrderingUtil;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateInternal;
import org.gradle.api.internal.project.taskfactory.TaskInstantiator;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.tasks.WorkResult;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.configuration.internal.ListenerBuildOperationDecorator;
import org.gradle.configuration.project.ProjectConfigurationActionContainer;
import org.gradle.configuration.project.ProjectEvaluator;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.extensibility.ExtensibleDynamicObject;
import org.gradle.internal.extensibility.NoConventionMapping;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.StandardOutputCapture;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.model.ModelContainer;
import org.gradle.internal.model.RuleBasedPluginListener;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.TextUriResourceLoader;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.internal.typeconversion.TypeConverter;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.gradle.model.Model;
import org.gradle.model.RuleSource;
import org.gradle.model.dsl.internal.NonTransformedModelDslBacking;
import org.gradle.model.dsl.internal.TransformedModelDslBacking;
import org.gradle.model.internal.core.DefaultNodeInitializerRegistry;
import org.gradle.model.internal.core.Hidden;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.manage.binding.StructBindingsStore;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.normalization.InputNormalizationHandler;
import org.gradle.normalization.internal.InputNormalizationHandlerInternal;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;
import org.gradle.util.Path;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.util.internal.GUtil;

@NoConventionMapping
public abstract class DefaultProject
extends AbstractPluginAware
implements ProjectInternal,
DynamicObjectAware {
    private static final ModelType<ServiceRegistry> SERVICE_REGISTRY_MODEL_TYPE = ModelType.of(ServiceRegistry.class);
    private static final ModelType<File> FILE_MODEL_TYPE = ModelType.of(File.class);
    private static final ModelType<ProjectIdentifier> PROJECT_IDENTIFIER_MODEL_TYPE = ModelType.of(ProjectIdentifier.class);
    private static final ModelType<ExtensionContainer> EXTENSION_CONTAINER_MODEL_TYPE = ModelType.of(ExtensionContainer.class);
    private static final Logger BUILD_LOGGER = Logging.getLogger(Project.class);
    private final ProjectState owner;
    private final ClassLoaderScope classLoaderScope;
    private final ClassLoaderScope baseClassLoaderScope;
    private final ServiceRegistry services;
    private final ProjectInternal rootProject;
    private final GradleInternal gradle;
    private final ScriptSource buildScriptSource;
    private final File projectDir;
    private final File buildFile;
    @Nullable
    private final ProjectInternal parent;
    private final String name;
    private Object group;
    private Object version;
    private Property<Object> status;
    private List<String> defaultTasks = new ArrayList<String>();
    private final ProjectStateInternal state;
    private FileResolver fileResolver;
    private TaskDependencyFactory taskDependencyFactory;
    private Factory<AntBuilder> antBuilderFactory;
    private AntBuilder ant;
    private final int depth;
    private final TaskContainerInternal taskContainer;
    private DependencyHandler dependencyHandler;
    private RoleBasedConfigurationContainerInternal configurationContainer;
    private ArtifactHandler artifactHandler;
    private ListenerBroadcast<ProjectEvaluationListener> evaluationListener = this.newProjectEvaluationListenerBroadcast();
    private final ListenerBroadcast<RuleBasedPluginListener> ruleBasedPluginListenerBroadcast = new ListenerBroadcast<RuleBasedPluginListener>(RuleBasedPluginListener.class);
    private final ExtensibleDynamicObject extensibleDynamicObject;
    private final DynamicLookupRoutine dynamicLookupRoutine;
    private String description;
    private boolean preparedForRuleBasedPlugins;

    public DefaultProject(String name, @Nullable ProjectInternal parent, File projectDir, File buildFile, ScriptSource buildScriptSource, GradleInternal gradle, ProjectState owner, ServiceRegistryFactory serviceRegistryFactory2, ClassLoaderScope selfClassLoaderScope, ClassLoaderScope baseClassLoaderScope) {
        this.owner = owner;
        this.classLoaderScope = selfClassLoaderScope;
        this.baseClassLoaderScope = baseClassLoaderScope;
        this.rootProject = parent != null ? parent.getRootProject() : this;
        this.projectDir = projectDir;
        this.buildFile = buildFile;
        this.parent = parent;
        this.name = name;
        this.state = new ProjectStateInternal();
        this.buildScriptSource = buildScriptSource;
        this.gradle = gradle;
        this.depth = parent == null ? 0 : parent.getDepth() + 1;
        this.services = serviceRegistryFactory2.createFor(this);
        this.taskContainer = this.services.get(TaskContainerInternal.class);
        this.extensibleDynamicObject = new ExtensibleDynamicObject((Object)this, Project.class, this.services.get(InstantiatorFactory.class).decorateLenient(this.services));
        DynamicObject parentInherited = this.services.get(CrossProjectModelAccess.class).parentProjectDynamicInheritedScope(this);
        if (parentInherited != null) {
            this.extensibleDynamicObject.setParent(parentInherited);
        }
        this.extensibleDynamicObject.addObject(this.taskContainer.getTasksAsDynamicObject(), ExtensibleDynamicObject.Location.AfterConvention);
        this.evaluationListener.add(gradle.getProjectEvaluationBroadcaster());
        this.ruleBasedPluginListenerBroadcast.add(project -> this.populateModelRegistry(this.services.get(ModelRegistry.class)));
        this.dynamicLookupRoutine = this.services.get(DynamicLookupRoutine.class);
    }

    private ListenerBroadcast<ProjectEvaluationListener> newProjectEvaluationListenerBroadcast() {
        return new ListenerBroadcast<ProjectEvaluationListener>(ProjectEvaluationListener.class);
    }

    private void populateModelRegistry(ModelRegistry modelRegistry) {
        this.registerServiceOn(modelRegistry, "serviceRegistry", SERVICE_REGISTRY_MODEL_TYPE, this.services, this.instanceDescriptorFor("serviceRegistry"));
        this.registerFactoryOn(modelRegistry, "buildDir", FILE_MODEL_TYPE, this::getBuildDir);
        this.registerInstanceOn(modelRegistry, "projectIdentifier", PROJECT_IDENTIFIER_MODEL_TYPE, this);
        this.registerInstanceOn(modelRegistry, "extensionContainer", EXTENSION_CONTAINER_MODEL_TYPE, this.getExtensions());
        modelRegistry.getRoot().applyToSelf(BasicServicesRules.class);
    }

    private <T> void registerInstanceOn(ModelRegistry modelRegistry, String path, ModelType<T> type, T instance) {
        this.registerFactoryOn(modelRegistry, path, type, Factories.constant(instance));
    }

    private <T> void registerFactoryOn(ModelRegistry modelRegistry, String path, ModelType<T> type, Factory<T> factory) {
        modelRegistry.register(ModelRegistrations.unmanagedInstance(ModelReference.of(path, type), factory).descriptor(this.instanceDescriptorFor(path)).hidden(true).build());
    }

    private <T> void registerServiceOn(ModelRegistry modelRegistry, String path, ModelType<T> type, T instance, String descriptor) {
        modelRegistry.register(ModelRegistrations.serviceInstance(ModelReference.of(path, type), instance).descriptor(descriptor).build());
    }

    private String instanceDescriptorFor(String path) {
        return "Project.<init>." + path + "()";
    }

    @Override
    public ProjectInternal getRootProject() {
        return this.getRootProject(this);
    }

    @Override
    public ProjectInternal getRootProject(ProjectInternal referrer) {
        return this.getCrossProjectModelAccess().access(referrer, this.rootProject);
    }

    @Override
    public GradleInternal getGradle() {
        return this.getCrossProjectModelAccess().gradleInstanceForProject(this, this.gradle);
    }

    @Inject
    protected abstract ProjectEvaluator getProjectEvaluator();

    @Override
    @Inject
    public abstract ScriptHandlerInternal getBuildscript();

    @Override
    public File getBuildFile() {
        return this.buildFile;
    }

    @Override
    public void setScript(Script buildScript) {
        this.extensibleDynamicObject.addObject(new BeanDynamicObject(buildScript).withNoProperties().withNotImplementsMissing(), ExtensibleDynamicObject.Location.BeforeConvention);
    }

    @Override
    public ScriptSource getBuildScriptSource() {
        return this.buildScriptSource;
    }

    @Override
    public File getRootDir() {
        return this.rootProject.getProjectDir();
    }

    @Override
    public ProjectInternal getParent() {
        return this.getParent(this);
    }

    @Override
    @Nullable
    public ProjectInternal getParent(ProjectInternal referrer) {
        if (this.parent == null) {
            return null;
        }
        return this.getCrossProjectModelAccess().access(referrer, this.parent);
    }

    @Override
    @Nullable
    public ProjectIdentifier getParentIdentifier() {
        return this.parent;
    }

    @Override
    public DynamicObject getAsDynamicObject() {
        return this.extensibleDynamicObject;
    }

    @Override
    public DynamicObject getInheritedScope() {
        return this.extensibleDynamicObject.getInheritable();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Object getGroup() {
        if (this.group != null) {
            return this.group;
        }
        if (this == this.rootProject) {
            return "";
        }
        this.group = this.rootProject.getName() + (this.getParent() == this.rootProject ? "" : "." + this.getParent().getPath().substring(1).replace(':', '.'));
        return this.group;
    }

    @Override
    public void setGroup(Object group) {
        this.group = group;
    }

    @Override
    public Object getVersion() {
        return this.version == null ? "unspecified" : this.version;
    }

    @Override
    public void setVersion(Object version) {
        this.version = version;
    }

    @Override
    public Object getStatus() {
        return this.getInternalStatus().get();
    }

    @Override
    public void setStatus(Object s) {
        this.getInternalStatus().set(s);
    }

    @Override
    public Property<Object> getInternalStatus() {
        if (this.status == null) {
            this.status = this.getObjects().property(Object.class).convention("release");
        }
        return this.status;
    }

    @Override
    public Map<String, Project> getChildProjectsUnchecked() {
        TreeMap childProjects = Maps.newTreeMap();
        for (ProjectState project : this.owner.getChildProjects()) {
            childProjects.put(project.getName(), project.getMutableModel());
        }
        return childProjects;
    }

    @Override
    public Map<String, Project> getChildProjects() {
        return this.getChildProjectsUnchecked().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getCrossProjectModelAccess().access(this, (ProjectInternal)entry.getValue())));
    }

    @Override
    public List<String> getDefaultTasks() {
        return this.defaultTasks;
    }

    @Override
    public void setDefaultTasks(List<String> defaultTasks) {
        this.defaultTasks = defaultTasks;
    }

    @Override
    public ProjectStateInternal getState() {
        return this.state;
    }

    @Override
    public FileResolver getFileResolver() {
        if (this.fileResolver == null) {
            this.fileResolver = this.services.get(FileResolver.class);
        }
        return this.fileResolver;
    }

    @Override
    public TaskDependencyFactory getTaskDependencyFactory() {
        if (this.taskDependencyFactory == null) {
            this.taskDependencyFactory = this.services.get(TaskDependencyFactory.class);
        }
        return this.taskDependencyFactory;
    }

    public void setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public void setAnt(AntBuilder ant) {
        this.ant = ant;
    }

    @Override
    public ArtifactHandler getArtifacts() {
        if (this.artifactHandler == null) {
            this.artifactHandler = this.services.get(ArtifactHandler.class);
        }
        return this.artifactHandler;
    }

    @Override
    @Inject
    public abstract RepositoryHandler getRepositories();

    @Override
    public RoleBasedConfigurationContainerInternal getConfigurations() {
        if (this.configurationContainer == null) {
            this.configurationContainer = this.services.get(RoleBasedConfigurationContainerInternal.class);
        }
        return this.configurationContainer;
    }

    @Override
    @Deprecated
    public Convention getConvention() {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateMethod(Project.class, "getConvention()").willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_access_to_conventions")).nagUser();
        return this.extensibleDynamicObject.getConvention();
    }

    @Override
    public String getPath() {
        return this.owner.getProjectPath().toString();
    }

    @Override
    public Path getIdentityPath() {
        return this.owner.getIdentityPath();
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Inject
    protected abstract CrossProjectModelAccess getCrossProjectModelAccess();

    @Override
    public int depthCompare(Project otherProject) {
        return ProjectOrderingUtil.depthCompare(this, otherProject);
    }

    @Override
    public int compareTo(Project otherProject) {
        return ProjectOrderingUtil.compare(this, otherProject);
    }

    @Override
    public String absoluteProjectPath(String path) {
        return this.getProjectPath().absolutePath(path);
    }

    @Override
    public Path identityPath(String name) {
        return this.getIdentityPath().child(name);
    }

    @Override
    @Nonnull
    public Path getProjectPath() {
        return this.owner.getProjectPath();
    }

    public ModelContainer<ProjectInternal> getModel() {
        return this.getOwner();
    }

    @Override
    public Path getBuildPath() {
        return this.gradle.getIdentityPath();
    }

    @Override
    public Path projectPath(String name) {
        return this.getProjectPath().child(name);
    }

    @Override
    public boolean isScript() {
        return false;
    }

    @Override
    public boolean isRootScript() {
        return false;
    }

    @Override
    public boolean isPluginContext() {
        return false;
    }

    @Override
    public String relativeProjectPath(String path) {
        return this.getProjectPath().relativePath(path);
    }

    @Override
    public ProjectInternal project(String path) {
        return this.project(this, path);
    }

    @Override
    public ProjectInternal project(ProjectInternal referrer, String path) throws UnknownProjectException {
        ProjectInternal project = this.getCrossProjectModelAccess().findProject(referrer, this, path);
        if (project == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found in %s.", path, this));
        }
        return project;
    }

    @Override
    public ProjectInternal findProject(String path) {
        return this.findProject(this, path);
    }

    @Override
    @Nullable
    public ProjectInternal findProject(ProjectInternal referrer, String path) {
        return this.getCrossProjectModelAccess().findProject(referrer, this, path);
    }

    @Override
    public Set<Project> getAllprojects() {
        return (Set)Cast.uncheckedCast(this.getAllprojects(this));
    }

    @Override
    public Set<? extends ProjectInternal> getAllprojects(ProjectInternal referrer) {
        return this.getCrossProjectModelAccess().getAllprojects(referrer, this);
    }

    @Override
    public void allprojects(Closure configureClosure) {
        this.allprojects(this, ConfigureUtil.configureUsing(configureClosure));
    }

    @Override
    public void allprojects(Action<? super Project> action) {
        this.allprojects(this, action);
    }

    @Override
    public void allprojects(ProjectInternal referrer, Action<? super Project> action) {
        this.getProjectConfigurator().allprojects(this.getCrossProjectModelAccess().getAllprojects(referrer, this), action);
    }

    @Override
    public Set<Project> getSubprojects() {
        return (Set)Cast.uncheckedCast(this.getSubprojects(this));
    }

    @Override
    public Set<? extends ProjectInternal> getSubprojects(ProjectInternal referrer) {
        return this.getCrossProjectModelAccess().getSubprojects(referrer, this);
    }

    @Override
    public void subprojects(Closure configureClosure) {
        this.subprojects(this, ConfigureUtil.configureUsing(configureClosure));
    }

    @Override
    public void subprojects(Action<? super Project> action) {
        this.subprojects(this, action);
    }

    @Override
    public void subprojects(ProjectInternal referrer, Action<? super Project> configureAction) {
        this.getProjectConfigurator().subprojects(this.getCrossProjectModelAccess().getSubprojects(referrer, this), configureAction);
    }

    @Override
    public <T> Iterable<T> configure(Iterable<T> objects, Action<? super T> configureAction) {
        for (T object : objects) {
            configureAction.execute(object);
        }
        return objects;
    }

    @Override
    public AntBuilder getAnt() {
        if (this.ant == null) {
            this.ant = this.createAntBuilder();
        }
        return this.ant;
    }

    @Override
    public AntBuilder createAntBuilder() {
        return this.getAntBuilderFactory().create();
    }

    @Override
    public ProjectInternal getProject() {
        return this;
    }

    @Override
    public DefaultProject evaluate() {
        this.getProjectEvaluator().evaluate(this, this.state);
        return this;
    }

    @Override
    public ProjectInternal bindAllModelRules() {
        try {
            this.getModelRegistry().bindAllReferences();
        }
        catch (Exception e) {
            throw new ProjectConfigurationException(String.format("A problem occurred configuring %s.", this.getDisplayName()), (Throwable)e);
        }
        return this;
    }

    @Override
    public TaskContainerInternal getTasks() {
        return this.taskContainer;
    }

    @Override
    public void defaultTasks(String ... defaultTasks) {
        if (defaultTasks == null) {
            throw new InvalidUserDataException("Default tasks must not be null!");
        }
        this.defaultTasks = new ArrayList<String>();
        for (String defaultTask : defaultTasks) {
            if (defaultTask == null) {
                throw new InvalidUserDataException("Default tasks must not be null!");
            }
            this.defaultTasks.add(defaultTask);
        }
    }

    @Override
    public File getProjectDir() {
        return this.projectDir;
    }

    @Override
    public File getBuildDir() {
        return this.getLayout().getBuildDirectory().getAsFile().get();
    }

    @Override
    public void setBuildDir(File path) {
        this.setBuildDir((Object)path);
    }

    @Override
    public void setBuildDir(Object path) {
        this.getLayout().setBuildDirectory(path);
    }

    @Override
    public void evaluationDependsOnChildren() {
        for (ProjectState project : this.owner.getChildProjects()) {
            ProjectInternal defaultProjectToEvaluate = project.getMutableModel();
            this.evaluationDependsOn(defaultProjectToEvaluate);
        }
    }

    @Override
    public Project evaluationDependsOn(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            throw new InvalidUserDataException("You must specify a project!");
        }
        ProjectInternal projectToEvaluate = this.project(path);
        return this.evaluationDependsOn(projectToEvaluate);
    }

    private Project evaluationDependsOn(ProjectInternal projectToEvaluate) {
        if (projectToEvaluate.getState().isConfiguring()) {
            throw new CircularReferenceException(String.format("Circular referencing during evaluation for %s.", projectToEvaluate));
        }
        projectToEvaluate.getOwner().ensureConfigured();
        return projectToEvaluate;
    }

    @Override
    public String getDisplayName() {
        StringBuilder builder = new StringBuilder();
        if (this.parent == null && this.gradle.isRootBuild()) {
            builder.append("root project '");
            builder.append(this.name);
            builder.append('\'');
        } else {
            builder.append("project '");
            builder.append(this.getIdentityPath());
            builder.append("'");
        }
        return builder.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public Map<Project, Set<Task>> getAllTasks(boolean recursive) {
        final TreeMap<Project, Set<Task>> foundTargets = new TreeMap<Project, Set<Task>>();
        Action<Project> action = new Action<Project>(){

            @Override
            public void execute(Project project) {
                ((ProjectInternal)project).getOwner().ensureTasksDiscovered();
                foundTargets.put(project, new TreeSet<Task>(project.getTasks()));
            }
        };
        if (recursive) {
            this.allprojects((Action<? super Project>)action);
        } else {
            action.execute(this);
        }
        return foundTargets;
    }

    @Override
    public Set<Task> getTasksByName(final String name, boolean recursive) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new InvalidUserDataException("Name is not specified!");
        }
        final HashSet<Task> foundTasks = new HashSet<Task>();
        Action<Project> action = new Action<Project>(){

            @Override
            public void execute(Project project) {
                ((ProjectInternal)project).getOwner().ensureTasksDiscovered();
                Task task = (Task)project.getTasks().findByName(name);
                if (task != null) {
                    foundTasks.add(task);
                }
            }
        };
        if (recursive) {
            this.allprojects((Action<? super Project>)action);
        } else {
            action.execute(this);
        }
        return foundTasks;
    }

    @Override
    @Inject
    public abstract FileOperations getFileOperations();

    @Override
    @Inject
    public abstract ProviderFactory getProviders();

    @Override
    @Inject
    public abstract ObjectFactory getObjects();

    @Override
    @Inject
    public abstract DefaultProjectLayout getLayout();

    @Override
    public File file(Object path) {
        return this.getFileOperations().file(path);
    }

    @Override
    public File file(Object path, PathValidation validation) {
        return this.getFileOperations().file(path, validation);
    }

    @Override
    public URI uri(Object path) {
        return this.getFileOperations().uri(path);
    }

    @Override
    public ConfigurableFileCollection files(Object ... paths) {
        return this.getObjects().fileCollection().from(paths);
    }

    @Override
    public ConfigurableFileCollection files(Object paths, Closure closure) {
        return ConfigureUtil.configure(closure, this.files(paths));
    }

    @Override
    public ConfigurableFileCollection files(Object paths, Action<? super ConfigurableFileCollection> configureAction) {
        ConfigurableFileCollection files = this.files(paths);
        configureAction.execute(files);
        return files;
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir) {
        return this.getFileOperations().fileTree(baseDir);
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir, Closure closure) {
        return ConfigureUtil.configure(closure, this.fileTree(baseDir));
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir, Action<? super ConfigurableFileTree> configureAction) {
        ConfigurableFileTree fileTree = this.fileTree(baseDir);
        configureAction.execute(fileTree);
        return fileTree;
    }

    @Override
    public ConfigurableFileTree fileTree(Map<String, ?> args) {
        return this.getFileOperations().fileTree(args);
    }

    @Override
    public FileTree zipTree(Object zipPath) {
        return this.getFileOperations().zipTree(zipPath);
    }

    @Override
    public FileTree tarTree(Object tarPath) {
        return this.getFileOperations().tarTree(tarPath);
    }

    @Override
    public <T> Provider<T> provider(Callable<? extends T> value) {
        return this.getProviders().provider(value);
    }

    @Override
    public ResourceHandler getResources() {
        return this.getFileOperations().getResources();
    }

    @Override
    public String relativePath(Object path) {
        return this.getFileOperations().relativePath(path);
    }

    @Override
    public File mkdir(Object path) {
        return this.getFileOperations().mkdir(path);
    }

    @Override
    public boolean delete(Object ... paths) {
        return this.getFileOperations().delete(paths);
    }

    @Override
    public WorkResult delete(Action<? super DeleteSpec> action) {
        return this.getFileOperations().delete(action);
    }

    public Factory<AntBuilder> getAntBuilderFactory() {
        if (this.antBuilderFactory == null) {
            this.antBuilderFactory = this.services.getFactory(AntBuilder.class);
        }
        return this.antBuilderFactory;
    }

    @Override
    public DependencyHandler getDependencies() {
        if (this.dependencyHandler == null) {
            this.dependencyHandler = this.services.get(DependencyHandler.class);
        }
        return this.dependencyHandler;
    }

    @Override
    @Inject
    public abstract DependencyFactory getDependencyFactory();

    @Override
    public ProjectEvaluationListener getProjectEvaluationBroadcaster() {
        return this.evaluationListener.getSource();
    }

    @Override
    public void beforeEvaluate(Action<? super Project> action) {
        this.assertMutatingMethodAllowed("beforeEvaluate(Action)");
        this.evaluationListener.add("beforeEvaluate", this.getListenerBuildOperationDecorator().decorate("Project.beforeEvaluate", action));
    }

    @Override
    public void afterEvaluate(Action<? super Project> action) {
        this.assertMutatingMethodAllowed("afterEvaluate(Action)");
        this.failAfterProjectIsEvaluated("afterEvaluate(Action)");
        this.evaluationListener.add("afterEvaluate", this.getListenerBuildOperationDecorator().decorate("Project.afterEvaluate", action));
    }

    @Override
    public void beforeEvaluate(Closure closure) {
        this.assertMutatingMethodAllowed("beforeEvaluate(Closure)");
        this.evaluationListener.add(new ClosureBackedMethodInvocationDispatch("beforeEvaluate", this.getListenerBuildOperationDecorator().decorate("Project.beforeEvaluate", (Closure)Cast.uncheckedNonnullCast(closure))));
    }

    @Override
    public void afterEvaluate(Closure closure) {
        this.assertMutatingMethodAllowed("afterEvaluate(Closure)");
        this.failAfterProjectIsEvaluated("afterEvaluate(Closure)");
        this.evaluationListener.add(new ClosureBackedMethodInvocationDispatch("afterEvaluate", this.getListenerBuildOperationDecorator().decorate("Project.afterEvaluate", (Closure)Cast.uncheckedNonnullCast(closure))));
    }

    private void failAfterProjectIsEvaluated(String methodPrototype) {
        if (!this.state.isUnconfigured() && !this.state.isConfiguring()) {
            throw new InvalidUserCodeException("Cannot run Project." + methodPrototype + " when the project is already evaluated.");
        }
    }

    @Override
    public Logger getLogger() {
        return BUILD_LOGGER;
    }

    @Override
    public StandardOutputCapture getStandardOutputCapture() {
        return this.getLogging();
    }

    @Override
    @Inject
    public abstract LoggingManagerInternal getLogging();

    @Override
    @Inject
    public abstract SoftwareComponentContainer getComponents();

    @Override
    public void components(Action<? super SoftwareComponentContainer> configuration) {
        configuration.execute(this.getComponents());
    }

    @Nullable
    public Object getProperty(String propertyName) {
        return this.property(propertyName);
    }

    @Nullable
    public Object invokeMethod(String name, Object args) {
        if (args instanceof Object[]) {
            return this.dynamicLookupRoutine.invokeMethod(this.extensibleDynamicObject, name, (Object[])args);
        }
        return this.dynamicLookupRoutine.invokeMethod(this.extensibleDynamicObject, name, args);
    }

    @Override
    public Object property(String propertyName) throws MissingPropertyException {
        return this.dynamicLookupRoutine.property(this.extensibleDynamicObject, propertyName);
    }

    @Override
    public Object findProperty(String propertyName) {
        return this.dynamicLookupRoutine.findProperty(this.extensibleDynamicObject, propertyName);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.dynamicLookupRoutine.setProperty(this.extensibleDynamicObject, name, value);
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.dynamicLookupRoutine.hasProperty(this.extensibleDynamicObject, propertyName);
    }

    @Override
    public Map<String, ?> getProperties() {
        return this.dynamicLookupRoutine.getProperties(this.extensibleDynamicObject);
    }

    @Override
    public WorkResult copy(Closure closure) {
        return this.copy(ConfigureUtil.configureUsing(closure));
    }

    @Override
    public WorkResult copy(Action<? super CopySpec> action) {
        return this.getFileOperations().copy(action);
    }

    @Override
    public WorkResult sync(Action<? super SyncSpec> action) {
        return this.getFileOperations().sync(action);
    }

    @Override
    public CopySpec copySpec(Closure closure) {
        return ConfigureUtil.configure(closure, this.copySpec());
    }

    @Override
    public CopySpec copySpec(Action<? super CopySpec> action) {
        return Actions.with(this.copySpec(), action);
    }

    @Override
    public CopySpec copySpec() {
        return this.getFileOperations().copySpec();
    }

    @Override
    @Inject
    public abstract ProcessOperations getProcessOperations();

    @Override
    public ExecResult javaexec(Closure closure) {
        return this.javaexec(ConfigureUtil.configureUsing(closure));
    }

    @Override
    public ExecResult javaexec(Action<? super JavaExecSpec> action) {
        return this.getProcessOperations().javaexec(action);
    }

    @Override
    public ExecResult exec(Closure closure) {
        return this.exec(ConfigureUtil.configureUsing(closure));
    }

    @Override
    public ExecResult exec(Action<? super ExecSpec> action) {
        return this.getProcessOperations().exec(action);
    }

    @Override
    public ServiceRegistry getServices() {
        return this.services;
    }

    @Override
    public ServiceRegistryFactory getServiceRegistryFactory() {
        return this.services.get(ServiceRegistryFactory.class);
    }

    @Override
    @Inject
    public abstract DependencyMetaDataProvider getDependencyMetaDataProvider();

    @Override
    public AntBuilder ant(Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.getAnt());
    }

    @Override
    public AntBuilder ant(Action<? super AntBuilder> configureAction) {
        AntBuilder ant = this.getAnt();
        configureAction.execute(ant);
        return ant;
    }

    @Override
    public Project project(String path, Closure configureClosure) {
        return this.project(this, path, ConfigureUtil.configureUsing(configureClosure));
    }

    @Override
    public Project project(String path, Action<? super Project> configureAction) {
        return this.project(this, path, configureAction);
    }

    @Override
    public ProjectInternal project(ProjectInternal referrer, String path, Action<? super Project> configureAction) {
        ProjectInternal project = this.project(referrer, path);
        this.getProjectConfigurator().project(project, configureAction);
        return project;
    }

    @Override
    public Object configure(Object object, Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, object);
    }

    @Override
    public Iterable<?> configure(Iterable<?> objects, Closure configureClosure) {
        for (Object object : objects) {
            this.configure(object, configureClosure);
        }
        return objects;
    }

    @Override
    public void configurations(Closure configureClosure) {
        this.getConfigurations().configure(configureClosure);
    }

    @Override
    public void repositories(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getRepositories());
    }

    @Override
    public void dependencies(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getDependencies());
    }

    @Override
    public void artifacts(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getArtifacts());
    }

    @Override
    public void artifacts(Action<? super ArtifactHandler> configureAction) {
        configureAction.execute(this.getArtifacts());
    }

    @Override
    public void buildscript(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getBuildscript());
    }

    @Override
    public Task task(String task) {
        return this.taskContainer.create(task);
    }

    public Task task(Object task) {
        return this.taskContainer.create(task.toString());
    }

    @Override
    public Task task(String task, Action<? super Task> configureAction) {
        return this.taskContainer.create(task, configureAction);
    }

    @Override
    public Task task(String task, Closure configureClosure) {
        return this.taskContainer.create(task).configure(configureClosure);
    }

    public Task task(Object task, Closure configureClosure) {
        return this.task(task.toString(), configureClosure);
    }

    public Task task(Map options, String task) {
        return this.taskContainer.create(GUtil.addMaps((Map)Cast.uncheckedNonnullCast(options), Collections.singletonMap("name", task)));
    }

    public Task task(Map options, Object task) {
        return this.task(options, task.toString());
    }

    public Task task(Map options, String task, Closure configureClosure) {
        return this.taskContainer.create(GUtil.addMaps((Map)Cast.uncheckedNonnullCast(options), Collections.singletonMap("name", task))).configure(configureClosure);
    }

    public Task task(Map options, Object task, Closure configureClosure) {
        return this.task(options, task.toString(), configureClosure);
    }

    @Override
    @Inject
    public abstract ProjectConfigurationActionContainer getConfigurationActions();

    @Override
    @Inject
    public abstract ModelRegistry getModelRegistry();

    @Override
    protected DefaultObjectConfigurationAction createObjectConfigurationAction() {
        TextUriResourceLoader.Factory textUriResourceLoaderFactory = this.services.get(TextUriResourceLoader.Factory.class);
        return new DefaultObjectConfigurationAction(this.getFileResolver(), this.getScriptPluginFactory(), this.getScriptHandlerFactory(), this.getBaseClassLoaderScope(), textUriResourceLoaderFactory, this);
    }

    @Override
    @Inject
    public abstract PluginManagerInternal getPluginManager();

    @Inject
    protected abstract ScriptPluginFactory getScriptPluginFactory();

    @Inject
    protected abstract ScriptHandlerFactory getScriptHandlerFactory();

    @Override
    public ClassLoaderScope getClassLoaderScope() {
        return this.classLoaderScope;
    }

    @Override
    public ClassLoaderScope getBaseClassLoaderScope() {
        return this.baseClassLoaderScope;
    }

    public Object passThrough(Object object) {
        return object;
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> type) {
        return this.getServices().get(DomainObjectCollectionFactory.class).newNamedDomainObjectContainerUndecorated(type);
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> type, NamedDomainObjectFactory<T> factory) {
        return this.getServices().get(DomainObjectCollectionFactory.class).newNamedDomainObjectContainer(type, factory);
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> type, Closure factoryClosure) {
        return this.getServices().get(DomainObjectCollectionFactory.class).newNamedDomainObjectContainer(type, factoryClosure);
    }

    @Override
    public ExtensionContainerInternal getExtensions() {
        return (ExtensionContainerInternal)((Object)DeprecationLogger.whileDisabled(this::getConvention));
    }

    public void model(Closure<?> modelRules) {
        this.prepareForRuleBasedPlugins();
        ModelRegistry modelRegistry = this.getModelRegistry();
        if (TransformedModelDslBacking.isTransformedBlock(modelRules)) {
            ClosureBackedAction.execute(new TransformedModelDslBacking(modelRegistry, this.getRootProject().getFileResolver()), modelRules);
        } else {
            new NonTransformedModelDslBacking(modelRegistry).configure(modelRules);
        }
    }

    @Inject
    protected abstract DeferredProjectConfiguration getDeferredProjectConfiguration();

    @Inject
    protected abstract CrossProjectConfigurator getProjectConfigurator();

    @Inject
    protected abstract ListenerBuildOperationDecorator getListenerBuildOperationDecorator();

    @Override
    public void addDeferredConfiguration(Runnable configuration) {
        this.getDeferredProjectConfiguration().add(configuration);
    }

    @Override
    public void fireDeferredConfiguration() {
        this.getDeferredProjectConfiguration().fire();
    }

    @Override
    public void addRuleBasedPluginListener(RuleBasedPluginListener listener2) {
        if (this.preparedForRuleBasedPlugins) {
            listener2.prepareForRuleBasedPlugins(this);
        } else {
            this.ruleBasedPluginListenerBroadcast.add(listener2);
        }
    }

    @Override
    public void prepareForRuleBasedPlugins() {
        if (!this.preparedForRuleBasedPlugins) {
            this.preparedForRuleBasedPlugins = true;
            this.ruleBasedPluginListenerBroadcast.getSource().prepareForRuleBasedPlugins(this);
        }
    }

    @Override
    @Inject
    public abstract InputNormalizationHandlerInternal getNormalization();

    @Override
    public void normalization(Action<? super InputNormalizationHandler> configuration) {
        configuration.execute(this.getNormalization());
    }

    @Override
    @Inject
    public abstract DependencyLockingHandler getDependencyLocking();

    @Override
    public void dependencyLocking(Action<? super DependencyLockingHandler> configuration) {
        configuration.execute(this.getDependencyLocking());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectEvaluationListener stepEvaluationListener(ProjectEvaluationListener listener2, Action<ProjectEvaluationListener> step) {
        ListenerBroadcast<ProjectEvaluationListener> original = this.evaluationListener;
        ListenerBroadcast<ProjectEvaluationListener> nextBatch = this.newProjectEvaluationListenerBroadcast();
        this.evaluationListener = nextBatch;
        try {
            step.execute(listener2);
        }
        finally {
            this.evaluationListener = original;
        }
        return nextBatch.isEmpty() ? null : nextBatch.getSource();
    }

    private void assertMutatingMethodAllowed(String methodName) {
        MutationGuards.of(this.getProjectConfigurator()).assertMutationAllowed(methodName, this, Project.class);
    }

    @Override
    public ProjectState getOwner() {
        return this.owner;
    }

    @Override
    public ProjectInternal.DetachedResolver newDetachedResolver() {
        final DependencyManagementServices dms = this.getServices().get(DependencyManagementServices.class);
        InstantiatorFactory instantiatorFactory = this.services.get(InstantiatorFactory.class);
        DefaultServiceRegistry lookup = new DefaultServiceRegistry(this.services);
        lookup.addProvider(new Object(){

            public DependencyResolutionServices createServices() {
                return dms.create(DefaultProject.this.services.get(FileResolver.class), DefaultProject.this.services.get(FileCollectionFactory.class), DefaultProject.this.services.get(DependencyMetaDataProvider.class), new UnknownProjectFinder("Detached resolvers do not support resolving projects"), new DetachedDependencyResolutionDomainObjectContext(DefaultProject.this.services.get(DomainObjectContext.class)));
            }
        });
        return instantiatorFactory.decorate(lookup).newInstance(LocalDetachedResolver.class, new Object[0]);
    }

    private static class DetachedDependencyResolutionDomainObjectContext
    implements DomainObjectContext {
        private final DomainObjectContext delegate;

        private DetachedDependencyResolutionDomainObjectContext(DomainObjectContext delegate) {
            this.delegate = delegate;
        }

        @Override
        public Path identityPath(String name) {
            return this.delegate.identityPath(name);
        }

        @Override
        public Path projectPath(String name) {
            return this.delegate.projectPath(name);
        }

        @Override
        @Nullable
        public Path getProjectPath() {
            return this.delegate.getProjectPath();
        }

        @Override
        @Nullable
        public ProjectInternal getProject() {
            return this.delegate.getProject();
        }

        @Override
        public ModelContainer<?> getModel() {
            return this.delegate.getModel();
        }

        @Override
        public Path getBuildPath() {
            return this.delegate.getBuildPath();
        }

        @Override
        public boolean isRootScript() {
            return this.delegate.isRootScript();
        }

        @Override
        public boolean isPluginContext() {
            return this.delegate.isPluginContext();
        }

        @Override
        public boolean isScript() {
            return this.delegate.isScript();
        }

        @Override
        public boolean isDetachedState() {
            return true;
        }
    }

    public static class LocalDetachedResolver
    implements ProjectInternal.DetachedResolver {
        private final DependencyResolutionServices resolutionServices;

        @Inject
        public LocalDetachedResolver(DependencyResolutionServices resolutionServices) {
            this.resolutionServices = resolutionServices;
        }

        @Override
        public RepositoryHandler getRepositories() {
            return this.resolutionServices.getResolveRepositoryHandler();
        }

        @Override
        public DependencyHandler getDependencies() {
            return this.resolutionServices.getDependencyHandler();
        }

        @Override
        public ConfigurationContainer getConfigurations() {
            return this.resolutionServices.getConfigurationContainer();
        }
    }

    static class BasicServicesRules
    extends RuleSource {
        BasicServicesRules() {
        }

        @Hidden
        @Model
        ProjectLayout projectLayoutService(ServiceRegistry serviceRegistry) {
            return serviceRegistry.get(ProjectLayout.class);
        }

        @Hidden
        @Model
        ObjectFactory objectFactory(ServiceRegistry serviceRegistry) {
            return serviceRegistry.get(ObjectFactory.class);
        }

        @Hidden
        @Model
        NamedEntityInstantiator<Task> taskFactory(ServiceRegistry serviceRegistry) {
            return serviceRegistry.get(TaskInstantiator.class);
        }

        @Hidden
        @Model
        CollectionCallbackActionDecorator collectionCallbackActionDecorator(ServiceRegistry serviceRegistry) {
            return serviceRegistry.get(CollectionCallbackActionDecorator.class);
        }

        @Hidden
        @Model
        Instantiator instantiator(ServiceRegistry serviceRegistry) {
            return serviceRegistry.get(Instantiator.class);
        }

        @Hidden
        @Model
        ModelSchemaStore schemaStore(ServiceRegistry serviceRegistry) {
            return serviceRegistry.get(ModelSchemaStore.class);
        }

        @Hidden
        @Model
        ManagedProxyFactory proxyFactory(ServiceRegistry serviceRegistry) {
            return serviceRegistry.get(ManagedProxyFactory.class);
        }

        @Hidden
        @Model
        StructBindingsStore structBindingsStore(ServiceRegistry serviceRegistry) {
            return serviceRegistry.get(StructBindingsStore.class);
        }

        @Hidden
        @Model
        NodeInitializerRegistry nodeInitializerRegistry(ModelSchemaStore schemaStore, StructBindingsStore structBindingsStore) {
            return new DefaultNodeInitializerRegistry(schemaStore, structBindingsStore);
        }

        @Hidden
        @Model
        TypeConverter typeConverter(ServiceRegistry serviceRegistry) {
            return serviceRegistry.get(TypeConverter.class);
        }

        @Hidden
        @Model
        FileOperations fileOperations(ServiceRegistry serviceRegistry) {
            return serviceRegistry.get(FileOperations.class);
        }
    }
}

