/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractProperty;
import org.gradle.api.internal.provider.ManagedFactories;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueSanitizer;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;

public class DefaultProperty<T>
extends AbstractProperty<T, ProviderInternal<? extends T>>
implements Property<T> {
    private final Class<T> type;
    private final ValueSanitizer<T> sanitizer;

    public DefaultProperty(PropertyHost propertyHost, Class<T> type) {
        super(propertyHost);
        this.type = type;
        this.sanitizer = ValueSanitizers.forType(type);
        this.init(Providers.notDefined());
    }

    @Override
    public Object unpackState() {
        return this.getProvider();
    }

    @Override
    public Class<?> publicType() {
        return Property.class;
    }

    @Override
    public int getFactoryId() {
        return ManagedFactories.PropertyManagedFactory.FACTORY_ID;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public void setFromAnyValue(Object object) {
        if (object instanceof Provider) {
            this.set((Provider)Cast.uncheckedNonnullCast(object));
        } else {
            this.set(Cast.uncheckedNonnullCast(object));
        }
    }

    @Override
    public void set(@Nullable T value) {
        if (value == null) {
            this.discardValue();
        } else {
            this.setSupplier(Providers.fixedValue(this.getValidationDisplayName(), value, this.type, this.sanitizer));
        }
    }

    @Override
    public Property<T> value(@Nullable T value) {
        this.set(value);
        return this;
    }

    @Override
    public Property<T> value(Provider<? extends T> provider) {
        this.set(provider);
        return this;
    }

    public ProviderInternal<? extends T> getProvider() {
        return (ProviderInternal)this.getSupplier();
    }

    public DefaultProperty<T> provider(Provider<? extends T> provider) {
        this.set(provider);
        return this;
    }

    @Override
    public void set(Provider<? extends T> provider) {
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (Object)"Cannot set the value of a property using a null provider.");
        ProviderInternal<T> p = Providers.internal(provider);
        this.setSupplier(p.asSupplier(this.getValidationDisplayName(), this.type, this.sanitizer));
    }

    @Override
    public Property<T> convention(@Nullable T value) {
        if (value == null) {
            this.setConvention(Providers.notDefined());
        } else {
            this.setConvention(Providers.fixedValue(this.getValidationDisplayName(), value, this.type, this.sanitizer));
        }
        return this;
    }

    @Override
    public Property<T> convention(Provider<? extends T> provider) {
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (Object)"Cannot set the convention of a property using a null provider.");
        this.setConvention(Providers.internal(provider).asSupplier(this.getValidationDisplayName(), this.type, this.sanitizer));
        return this;
    }

    @Override
    protected ValueSupplier.ExecutionTimeValue<? extends T> calculateOwnExecutionTimeValue(ProviderInternal<? extends T> value) {
        return value.calculateExecutionTimeValue();
    }

    @Override
    protected ValueSupplier.Value<? extends T> calculateValueFrom(ProviderInternal<? extends T> value, ValueSupplier.ValueConsumer consumer) {
        return value.calculateValue(consumer);
    }

    @Override
    protected ProviderInternal<? extends T> finalValue(ProviderInternal<? extends T> value, ValueSupplier.ValueConsumer consumer) {
        return value.withFinalValue(consumer);
    }

    @Override
    protected String describeContents() {
        return String.format("property(%s, %s)", this.type.getName(), this.getSupplier());
    }
}

