/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.compile.ApiCompilerResult;
import org.gradle.api.internal.tasks.compile.CompileJavaBuildOperationType;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingResult;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessorResult;
import org.gradle.api.internal.tasks.compile.incremental.processing.IncrementalAnnotationProcessorType;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.language.base.internal.compile.Compiler;

public class CompileJavaBuildOperationReportingCompiler
implements Compiler<JavaCompileSpec> {
    private final TaskInternal task;
    private final Compiler<JavaCompileSpec> delegate;
    private final BuildOperationExecutor buildOperationExecutor;

    public CompileJavaBuildOperationReportingCompiler(TaskInternal task, Compiler<JavaCompileSpec> delegate, BuildOperationExecutor buildOperationExecutor) {
        this.task = task;
        this.delegate = delegate;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public WorkResult execute(final JavaCompileSpec spec) {
        return this.buildOperationExecutor.call(new CallableBuildOperation<WorkResult>(){

            @Override
            public BuildOperationDescriptor.Builder description() {
                final String taskIdentityPath = CompileJavaBuildOperationReportingCompiler.this.task.getIdentityPath().getPath();
                return BuildOperationDescriptor.displayName("Compile Java for " + taskIdentityPath).details(new CompileJavaBuildOperationType.Details(){

                    @Override
                    public String getTaskIdentityPath() {
                        return taskIdentityPath;
                    }
                });
            }

            @Override
            public WorkResult call(BuildOperationContext context) {
                WorkResult result2 = CompileJavaBuildOperationReportingCompiler.this.delegate.execute(spec);
                context.setResult(this.toBuildOperationResult(result2));
                return result2;
            }

            private Result toBuildOperationResult(WorkResult result2) {
                if (result2 instanceof ApiCompilerResult) {
                    AnnotationProcessingResult annotationProcessingResult = ((ApiCompilerResult)result2).getAnnotationProcessingResult();
                    ArrayList<CompileJavaBuildOperationType.Result.AnnotationProcessorDetails> details = new ArrayList<CompileJavaBuildOperationType.Result.AnnotationProcessorDetails>();
                    for (AnnotationProcessorResult processorResult : annotationProcessingResult.getAnnotationProcessorResults()) {
                        details.add(this.toAnnotationProcessorDetails(processorResult));
                    }
                    return new Result(details);
                }
                return new Result(null);
            }

            private DefaultAnnotationProcessorDetails toAnnotationProcessorDetails(AnnotationProcessorResult result2) {
                return new DefaultAnnotationProcessorDetails(result2.getClassName(), this.toType(result2.getType()), result2.getExecutionTimeInMillis());
            }

            private CompileJavaBuildOperationType.Result.AnnotationProcessorDetails.Type toType(IncrementalAnnotationProcessorType type) {
                if (type == IncrementalAnnotationProcessorType.AGGREGATING) {
                    return CompileJavaBuildOperationType.Result.AnnotationProcessorDetails.Type.AGGREGATING;
                }
                if (type == IncrementalAnnotationProcessorType.ISOLATING) {
                    return CompileJavaBuildOperationType.Result.AnnotationProcessorDetails.Type.ISOLATING;
                }
                return CompileJavaBuildOperationType.Result.AnnotationProcessorDetails.Type.UNKNOWN;
            }
        });
    }

    private static class DefaultAnnotationProcessorDetails
    implements CompileJavaBuildOperationType.Result.AnnotationProcessorDetails {
        private final String className;
        private final CompileJavaBuildOperationType.Result.AnnotationProcessorDetails.Type type;
        private final long executionTimeInMillis;

        DefaultAnnotationProcessorDetails(String className, CompileJavaBuildOperationType.Result.AnnotationProcessorDetails.Type type, long executionTimeInMillis) {
            this.className = className;
            this.type = type;
            this.executionTimeInMillis = executionTimeInMillis;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public CompileJavaBuildOperationType.Result.AnnotationProcessorDetails.Type getType() {
            return this.type;
        }

        @Override
        public long getExecutionTimeInMillis() {
            return this.executionTimeInMillis;
        }
    }

    private static class Result
    implements CompileJavaBuildOperationType.Result {
        private final List<CompileJavaBuildOperationType.Result.AnnotationProcessorDetails> annotationProcessorDetails;

        Result(List<CompileJavaBuildOperationType.Result.AnnotationProcessorDetails> annotationProcessorDetails) {
            this.annotationProcessorDetails = annotationProcessorDetails;
        }

        @Override
        public List<CompileJavaBuildOperationType.Result.AnnotationProcessorDetails> getAnnotationProcessorDetails() {
            return this.annotationProcessorDetails;
        }
    }
}

