/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileType;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.GeneratedResource;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CurrentCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.FileNameDerivingClassNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileClassNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.transaction.CompileTransaction;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.work.FileChange;

abstract class AbstractRecompilationSpecProvider
implements RecompilationSpecProvider {
    private static final String MODULE_INFO_CLASS_NAME = "module-info";
    private static final String PACKAGE_INFO_CLASS_NAME = "package-info";
    private final Deleter deleter;
    private final FileOperations fileOperations;
    private final FileTree sourceTree;
    private final Iterable<FileChange> sourceChanges;
    private final boolean incremental;

    public AbstractRecompilationSpecProvider(Deleter deleter, FileOperations fileOperations, FileTree sourceTree, Iterable<FileChange> sourceChanges, boolean incremental) {
        this.deleter = deleter;
        this.fileOperations = fileOperations;
        this.sourceTree = sourceTree;
        this.sourceChanges = sourceChanges;
        this.incremental = incremental;
    }

    @Override
    public RecompilationSpec provideRecompilationSpec(JavaCompileSpec spec, CurrentCompilation current, PreviousCompilation previous) {
        RecompilationSpec recompilationSpec = new RecompilationSpec();
        FileNameDerivingClassNameConverter sourceFileClassNameConverter = new FileNameDerivingClassNameConverter(previous.getSourceToClassConverter(), this.getFileExtensions());
        AbstractRecompilationSpecProvider.processClasspathChanges(current, previous, recompilationSpec);
        SourceFileChangeProcessor sourceFileChangeProcessor = new SourceFileChangeProcessor(previous);
        this.processSourceChanges(current, sourceFileChangeProcessor, recompilationSpec, sourceFileClassNameConverter);
        this.processCompilerSpecificDependencies(spec, recompilationSpec, sourceFileChangeProcessor, sourceFileClassNameConverter);
        AbstractRecompilationSpecProvider.collectAllSourcePathsAndIndependentClasses(sourceFileChangeProcessor, recompilationSpec, sourceFileClassNameConverter);
        Set<String> typesToReprocess = previous.getTypesToReprocess(recompilationSpec.getClassesToCompile());
        AbstractRecompilationSpecProvider.processTypesToReprocess(typesToReprocess, recompilationSpec, sourceFileClassNameConverter);
        AbstractRecompilationSpecProvider.addModuleInfoToCompile(recompilationSpec, sourceFileClassNameConverter);
        return recompilationSpec;
    }

    protected abstract Set<String> getFileExtensions();

    private static void processClasspathChanges(CurrentCompilation current, PreviousCompilation previous, RecompilationSpec spec) {
        DependentsSet dependents = current.findDependentsOfClasspathChanges(previous);
        if (dependents.isDependencyToAll()) {
            spec.setFullRebuildCause(dependents.getDescription());
            return;
        }
        spec.addClassesToCompile(dependents.getPrivateDependentClasses());
        spec.addClassesToCompile(dependents.getAccessibleDependentClasses());
        spec.addResourcesToGenerate(dependents.getDependentResources());
    }

    private void processSourceChanges(CurrentCompilation current, SourceFileChangeProcessor sourceFileChangeProcessor, RecompilationSpec spec, SourceFileClassNameConverter sourceFileClassNameConverter) {
        if (spec.isFullRebuildNeeded()) {
            return;
        }
        for (FileChange fileChange : this.sourceChanges) {
            if (spec.isFullRebuildNeeded()) {
                return;
            }
            if (fileChange.getFileType() != FileType.FILE) continue;
            String relativeFilePath = fileChange.getNormalizedPath();
            Set<String> changedClasses = sourceFileClassNameConverter.getClassNames(relativeFilePath);
            if (changedClasses.isEmpty() && !this.isIncrementalOnResourceChanges(current)) {
                spec.setFullRebuildCause(this.rebuildClauseForChangedNonSourceFile(fileChange));
            }
            sourceFileChangeProcessor.processChange(changedClasses, spec);
        }
    }

    private String rebuildClauseForChangedNonSourceFile(FileChange fileChange) {
        return String.format("%s '%s' has been %s", "resource", fileChange.getFile().getName(), fileChange.getChangeType().name().toLowerCase(Locale.US));
    }

    protected abstract void processCompilerSpecificDependencies(JavaCompileSpec var1, RecompilationSpec var2, SourceFileChangeProcessor var3, SourceFileClassNameConverter var4);

    protected abstract boolean isIncrementalOnResourceChanges(CurrentCompilation var1);

    private static void collectAllSourcePathsAndIndependentClasses(SourceFileChangeProcessor sourceFileChangeProcessor, RecompilationSpec spec, SourceFileClassNameConverter sourceFileClassNameConverter) {
        Set<String> classesToCompile = new LinkedHashSet<String>(spec.getClassesToCompile());
        while (!classesToCompile.isEmpty() && !spec.isFullRebuildNeeded()) {
            Set<String> independentClasses = AbstractRecompilationSpecProvider.collectSourcePathsAndIndependentClasses(classesToCompile, spec, sourceFileClassNameConverter);
            classesToCompile = independentClasses.isEmpty() ? Collections.emptySet() : sourceFileChangeProcessor.processAnnotationDependenciesOfIndependentClasses(independentClasses, spec);
        }
    }

    private static Set<String> collectSourcePathsAndIndependentClasses(Set<String> classesToCompile, RecompilationSpec spec, SourceFileClassNameConverter sourceFileClassNameConverter) {
        LinkedHashSet<String> independentClasses = new LinkedHashSet<String>();
        for (String classToCompile : classesToCompile) {
            for (String sourcePath : sourceFileClassNameConverter.getRelativeSourcePaths(classToCompile)) {
                independentClasses.addAll(AbstractRecompilationSpecProvider.collectIndependentClassesForSourcePath(sourcePath, spec, sourceFileClassNameConverter));
                spec.addSourcePath(sourcePath);
            }
        }
        return independentClasses;
    }

    private static Set<String> collectIndependentClassesForSourcePath(String sourcePath, RecompilationSpec spec, SourceFileClassNameConverter sourceFileClassNameConverter) {
        Set<String> classNames = sourceFileClassNameConverter.getClassNames(sourcePath);
        if (classNames.size() <= 1) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> newClasses = new LinkedHashSet<String>();
        for (String className : classNames) {
            if (!spec.addClassToCompile(className)) continue;
            newClasses.add(className);
        }
        return newClasses;
    }

    private static void processTypesToReprocess(Set<String> typesToReprocess, RecompilationSpec spec, SourceFileClassNameConverter sourceFileClassNameConverter) {
        for (String typeToReprocess : typesToReprocess) {
            if (typeToReprocess.endsWith(PACKAGE_INFO_CLASS_NAME) || typeToReprocess.equals(MODULE_INFO_CLASS_NAME)) {
                spec.addClassToCompile(typeToReprocess);
                spec.addSourcePaths(sourceFileClassNameConverter.getRelativeSourcePaths(typeToReprocess));
                continue;
            }
            spec.addClassToReprocess(typeToReprocess);
        }
    }

    private static void addModuleInfoToCompile(RecompilationSpec spec, SourceFileClassNameConverter sourceFileClassNameConverter) {
        Set<String> moduleInfoSources = sourceFileClassNameConverter.getRelativeSourcePaths(MODULE_INFO_CLASS_NAME);
        if (!moduleInfoSources.isEmpty()) {
            spec.addClassToCompile(MODULE_INFO_CLASS_NAME);
            spec.addSourcePaths(moduleInfoSources);
        }
    }

    @Override
    public CompileTransaction initCompilationSpecAndTransaction(JavaCompileSpec spec, RecompilationSpec recompilationSpec) {
        if (!recompilationSpec.isBuildNeeded()) {
            spec.setSourceFiles((Iterable<File>)ImmutableSet.of());
            spec.setClassesToProcess(Collections.emptySet());
            return new CompileTransaction(spec, this.fileOperations.patternSet(), (Map<GeneratedResource.Location, PatternSet>)ImmutableMap.of(), this.fileOperations, this.deleter);
        }
        PatternSet classesToDelete = this.fileOperations.patternSet();
        PatternSet sourceToCompile = this.fileOperations.patternSet();
        AbstractRecompilationSpecProvider.prepareFilePatterns(recompilationSpec.getClassesToCompile(), recompilationSpec.getSourcePaths(), classesToDelete, sourceToCompile);
        spec.setSourceFiles(AbstractRecompilationSpecProvider.narrowDownSourcesToCompile(this.sourceTree, sourceToCompile));
        AbstractRecompilationSpecProvider.includePreviousCompilationOutputOnClasspath(spec);
        AbstractRecompilationSpecProvider.addClassesToProcess(spec, recompilationSpec);
        spec.setClassesToCompile(recompilationSpec.getClassesToCompile());
        Map<GeneratedResource.Location, PatternSet> resourcesToDelete = AbstractRecompilationSpecProvider.prepareResourcePatterns(recompilationSpec.getResourcesToGenerate(), this.fileOperations);
        return new CompileTransaction(spec, classesToDelete, resourcesToDelete, this.fileOperations, this.deleter);
    }

    private static Iterable<File> narrowDownSourcesToCompile(FileTree sourceTree, PatternSet sourceToCompile) {
        return sourceTree.matching(sourceToCompile);
    }

    private static Map<GeneratedResource.Location, PatternSet> prepareResourcePatterns(Collection<GeneratedResource> staleResources, FileOperations fileOperations) {
        EnumMap<GeneratedResource.Location, PatternSet> resourcesByLocation = new EnumMap<GeneratedResource.Location, PatternSet>(GeneratedResource.Location.class);
        for (GeneratedResource.Location location : GeneratedResource.Location.values()) {
            resourcesByLocation.put(location, fileOperations.patternSet());
        }
        for (GeneratedResource resource : staleResources) {
            ((PatternSet)resourcesByLocation.get((Object)resource.getLocation())).include(resource.getPath());
        }
        return resourcesByLocation;
    }

    private static void prepareFilePatterns(Collection<String> staleClasses, Collection<String> sourcePaths, PatternSet filesToDelete, PatternSet sourceToCompile) {
        for (String sourcePath : sourcePaths) {
            filesToDelete.include(sourcePath);
            sourceToCompile.include(sourcePath);
        }
        for (String staleClass : staleClasses) {
            filesToDelete.include(staleClass.replaceAll("\\.", "/").concat(".class"));
            filesToDelete.include(staleClass.replaceAll("[.$]", "_").concat(".h"));
        }
    }

    private static void addClassesToProcess(JavaCompileSpec spec, RecompilationSpec recompilationSpec) {
        HashSet<String> classesToProcess = new HashSet<String>(recompilationSpec.getClassesToProcess());
        classesToProcess.removeAll(recompilationSpec.getClassesToCompile());
        spec.setClassesToProcess(classesToProcess);
    }

    private static void includePreviousCompilationOutputOnClasspath(JavaCompileSpec spec) {
        ArrayList<File> classpath = new ArrayList<File>(spec.getCompileClasspath());
        File destinationDir = spec.getDestinationDir();
        classpath.add(destinationDir);
        spec.setCompileClasspath(classpath);
    }

    @Override
    public boolean isIncremental() {
        return this.incremental;
    }
}

