/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.TaskOutputCachingDisabledReasonCategory;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationType;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingDisabledReasonCategory;
import org.gradle.internal.execution.caching.CachingState;

public class ExecuteTaskBuildOperationResult
implements ExecuteTaskBuildOperationType.Result {
    private final TaskStateInternal taskState;
    private final CachingState cachingState;
    private final OriginMetadata originMetadata;
    private final boolean incremental;
    private final List<String> executionReasons;

    public ExecuteTaskBuildOperationResult(TaskStateInternal taskState, CachingState cachingState, @Nullable OriginMetadata originMetadata, boolean incremental, List<String> executionReasons) {
        this.taskState = taskState;
        this.cachingState = cachingState;
        this.originMetadata = originMetadata;
        this.incremental = incremental;
        this.executionReasons = executionReasons;
    }

    @Override
    @Nullable
    public String getSkipMessage() {
        return this.taskState.getSkipMessage();
    }

    @Override
    @Nullable
    public String getSkipReasonMessage() {
        return this.taskState.getSkipReasonMessage();
    }

    @Override
    public boolean isActionable() {
        return this.taskState.isActionable();
    }

    @Override
    @Nullable
    public String getOriginBuildInvocationId() {
        return this.originMetadata == null ? null : this.originMetadata.getBuildInvocationId();
    }

    @Override
    @Nullable
    public Long getOriginExecutionTime() {
        return this.originMetadata == null ? null : Long.valueOf(this.originMetadata.getExecutionTime().toMillis());
    }

    @Override
    @Nullable
    public String getCachingDisabledReasonMessage() {
        return this.getCachingDisabledReason().map(CachingDisabledReason::getMessage).orElse(null);
    }

    @Override
    @Nullable
    public String getCachingDisabledReasonCategory() {
        return this.getCachingDisabledReason().map(CachingDisabledReason::getCategory).map(ExecuteTaskBuildOperationResult::convertNoCacheReasonCategory).map(Enum::name).orElse(null);
    }

    private Optional<CachingDisabledReason> getCachingDisabledReason() {
        return this.cachingState.whenDisabled().map(CachingState.Disabled::getDisabledReasons).map(reasons -> (CachingDisabledReason)reasons.get(0));
    }

    private static TaskOutputCachingDisabledReasonCategory convertNoCacheReasonCategory(CachingDisabledReasonCategory category) {
        switch (category) {
            case UNKNOWN: {
                return TaskOutputCachingDisabledReasonCategory.UNKNOWN;
            }
            case BUILD_CACHE_DISABLED: {
                return TaskOutputCachingDisabledReasonCategory.BUILD_CACHE_DISABLED;
            }
            case NOT_CACHEABLE: {
                return TaskOutputCachingDisabledReasonCategory.NOT_ENABLED_FOR_TASK;
            }
            case ENABLE_CONDITION_NOT_SATISFIED: {
                return TaskOutputCachingDisabledReasonCategory.CACHE_IF_SPEC_NOT_SATISFIED;
            }
            case DISABLE_CONDITION_SATISFIED: {
                return TaskOutputCachingDisabledReasonCategory.DO_NOT_CACHE_IF_SPEC_SATISFIED;
            }
            case NO_OUTPUTS_DECLARED: {
                return TaskOutputCachingDisabledReasonCategory.NO_OUTPUTS_DECLARED;
            }
            case NON_CACHEABLE_OUTPUT: {
                return TaskOutputCachingDisabledReasonCategory.NON_CACHEABLE_TREE_OUTPUT;
            }
            case OVERLAPPING_OUTPUTS: {
                return TaskOutputCachingDisabledReasonCategory.OVERLAPPING_OUTPUTS;
            }
            case VALIDATION_FAILURE: {
                return TaskOutputCachingDisabledReasonCategory.VALIDATION_FAILURE;
            }
        }
        throw new AssertionError();
    }

    @Override
    public List<String> getUpToDateMessages() {
        return this.executionReasons;
    }

    @Override
    public boolean isIncremental() {
        return this.incremental;
    }
}

