/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.internal.JavaPluginHelper;
import org.gradle.api.plugins.jvm.internal.DefaultJvmFeature;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.internal.component.external.model.ProjectTestFixtures;
import org.gradle.jvm.component.internal.DefaultJvmSoftwareComponent;

public abstract class JavaTestFixturesPlugin
implements Plugin<Project> {
    @Inject
    public JavaTestFixturesPlugin() {
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().withPlugin("java", plugin -> {
            JavaPluginExtension extension = project.getExtensions().getByType(JavaPluginExtension.class);
            SourceSet testFixturesSourceSet = (SourceSet)extension.getSourceSets().maybeCreate("testFixtures");
            ConfigurationRole role = ConfigurationRolesForMigration.CONSUMABLE_BUCKET_TO_CONSUMABLE;
            DefaultJvmFeature feature = new DefaultJvmFeature("testFixtures", testFixturesSourceSet, Collections.singletonList(new ProjectDerivedCapability(project, "testFixtures")), (ProjectInternal)project, role, false);
            feature.withApi();
            DefaultJvmSoftwareComponent component = (DefaultJvmSoftwareComponent)JavaPluginHelper.getJavaComponent(project);
            component.addVariantsFromConfiguration(feature.getApiElementsConfiguration(), new JavaConfigurationVariantMapping("compile", true));
            component.addVariantsFromConfiguration(feature.getRuntimeElementsConfiguration(), new JavaConfigurationVariantMapping("runtime", true));
            this.createImplicitTestFixturesDependencies(project);
        });
    }

    private void createImplicitTestFixturesDependencies(Project project) {
        DependencyHandler dependencies = project.getDependencies();
        dependencies.add("testFixturesApi", dependencies.create(project));
        SourceSet testSourceSet = JavaPluginHelper.getDefaultTestSuite(project).getSources();
        ProjectDependency testDependency = (ProjectDependency)dependencies.add(testSourceSet.getImplementationConfigurationName(), dependencies.create(project));
        testDependency.capabilities(new ProjectTestFixtures(project));
        ConfigurationContainer configurations = project.getConfigurations();
        testSourceSet.setCompileClasspath(project.getObjects().fileCollection().from(configurations.getByName(testSourceSet.getCompileClasspathConfigurationName())));
        testSourceSet.setRuntimeClasspath(project.getObjects().fileCollection().from(testSourceSet.getOutput(), configurations.getByName(testSourceSet.getRuntimeClasspathConfigurationName())));
    }
}

