/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.NextGenBuildCacheService;
import org.gradle.caching.internal.controller.NextGenBuildCacheAccess;
import org.gradle.internal.file.BufferProvider;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.internal.impldep.org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;

public class GZipNextGenBuildCacheAccess
implements NextGenBuildCacheAccess {
    private final NextGenBuildCacheAccess delegate;
    private final BufferProvider bufferProvider;

    public GZipNextGenBuildCacheAccess(NextGenBuildCacheAccess delegate, BufferProvider bufferProvider) {
        this.delegate = delegate;
        this.bufferProvider = bufferProvider;
    }

    @Override
    public <T> void load(Map<BuildCacheKey, T> entries, NextGenBuildCacheAccess.LoadHandler<T> handler) {
        this.delegate.load(entries, (inputStream, payload) -> {
            try (GZIPInputStream zipInput = new GZIPInputStream(inputStream);){
                handler.handle(zipInput, payload);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @Override
    public <T> void store(Map<BuildCacheKey, T> entries, NextGenBuildCacheAccess.StoreHandler<T> handler) {
        this.delegate.store(entries, payload -> {
            NextGenBuildCacheService.NextGenWriter delegateWriter = handler.handle(payload);
            final UnsynchronizedByteArrayOutputStream compressed = new UnsynchronizedByteArrayOutputStream((int)((double)delegateWriter.getSize() * 1.2));
            try (GZIPOutputStream zipOutput = new GZIPOutputStream((OutputStream)compressed);
                 InputStream delegateInput = delegateWriter.openStream();){
                IOUtils.copyLarge((InputStream)delegateInput, (OutputStream)zipOutput, (byte[])this.bufferProvider.getBuffer());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return new NextGenBuildCacheService.NextGenWriter(){

                @Override
                public InputStream openStream() {
                    return compressed.toInputStream();
                }

                @Override
                public void writeTo(OutputStream output) throws IOException {
                    compressed.writeTo(output);
                }

                @Override
                public long getSize() {
                    return compressed.size();
                }
            };
        });
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

