/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.services;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.BuildCacheServiceFactory;
import org.gradle.caching.configuration.BuildCache;
import org.gradle.caching.configuration.internal.BuildCacheConfigurationInternal;
import org.gradle.caching.internal.FinalizeBuildCacheConfigurationBuildOperationType;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.NoOpBuildCacheController;
import org.gradle.caching.internal.controller.service.BuildCacheServiceRole;
import org.gradle.caching.internal.origin.OriginMetadataFactory;
import org.gradle.caching.internal.services.BuildCacheControllerFactory;
import org.gradle.caching.local.DirectoryBuildCache;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.vfs.FileSystemAccess;
import org.gradle.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBuildCacheControllerFactory<L extends BuildCacheService>
implements BuildCacheControllerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBuildCacheControllerFactory.class);
    protected final StartParameter startParameter;
    protected final StringInterner stringInterner;
    protected final BuildOperationExecutor buildOperationExecutor;
    protected final FileSystemAccess fileSystemAccess;
    protected final OriginMetadataFactory originMetadataFactory;

    public AbstractBuildCacheControllerFactory(StartParameter startParameter, BuildOperationExecutor buildOperationExecutor, OriginMetadataFactory originMetadataFactory, FileSystemAccess fileSystemAccess, StringInterner stringInterner) {
        this.startParameter = startParameter;
        this.buildOperationExecutor = buildOperationExecutor;
        this.originMetadataFactory = originMetadataFactory;
        this.fileSystemAccess = fileSystemAccess;
        this.stringInterner = stringInterner;
    }

    protected abstract BuildCacheController doCreateController(@Nullable DescribedBuildCacheService<DirectoryBuildCache, L> var1, @Nullable DescribedBuildCacheService<BuildCache, BuildCacheService> var2);

    @Override
    public BuildCacheController createController(final Path buildIdentityPath, final BuildCacheConfigurationInternal buildCacheConfiguration, final InstanceGenerator instanceGenerator) {
        final BuildCacheMode buildCacheState = this.startParameter.isBuildCacheEnabled() ? BuildCacheMode.ENABLED : BuildCacheMode.DISABLED;
        final RemoteAccessMode remoteAccessMode = this.startParameter.isOffline() ? RemoteAccessMode.OFFLINE : RemoteAccessMode.ONLINE;
        return this.buildOperationExecutor.call(new CallableBuildOperation<BuildCacheController>(){

            @Override
            public BuildCacheController call(BuildOperationContext context) {
                boolean remoteEnabled;
                if (buildCacheState == BuildCacheMode.DISABLED) {
                    context.setResult(ResultImpl.disabled());
                    return NoOpBuildCacheController.INSTANCE;
                }
                DirectoryBuildCache local = buildCacheConfiguration.getLocal();
                BuildCache remote = buildCacheConfiguration.getRemote();
                boolean localEnabled = local.isEnabled();
                boolean bl = remoteEnabled = remote != null && remote.isEnabled();
                if (remoteEnabled && remoteAccessMode == RemoteAccessMode.OFFLINE) {
                    remoteEnabled = false;
                    LOGGER.warn("Remote build cache is disabled when running with --offline.");
                }
                DescribedBuildCacheService localDescribedService = localEnabled ? AbstractBuildCacheControllerFactory.createBuildCacheService(local, BuildCacheServiceRole.LOCAL, buildIdentityPath, buildCacheConfiguration, instanceGenerator) : null;
                DescribedBuildCacheService remoteDescribedService = remoteEnabled ? AbstractBuildCacheControllerFactory.createBuildCacheService(remote, BuildCacheServiceRole.REMOTE, buildIdentityPath, buildCacheConfiguration, instanceGenerator) : null;
                context.setResult(new ResultImpl(true, local.isEnabled(), remote != null && remote.isEnabled() && remoteAccessMode == RemoteAccessMode.ONLINE, localDescribedService == null ? null : localDescribedService.description, remoteDescribedService == null ? null : remoteDescribedService.description));
                if (!localEnabled && !remoteEnabled) {
                    LOGGER.warn("Using the build cache is enabled, but no build caches are configured or enabled.");
                    return NoOpBuildCacheController.INSTANCE;
                }
                return AbstractBuildCacheControllerFactory.this.doCreateController(localDescribedService, remoteDescribedService);
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Finalize build cache configuration").details(new DetailsImpl(buildIdentityPath.getPath()));
            }
        });
    }

    private static <C extends BuildCache, S> DescribedBuildCacheService<C, S> createBuildCacheService(C configuration, BuildCacheServiceRole role, Path buildIdentityPath, BuildCacheConfigurationInternal buildCacheConfiguration, InstanceGenerator instantiator2) {
        Class castFactoryType = (Class)Cast.uncheckedNonnullCast(buildCacheConfiguration.getBuildCacheServiceFactoryType(configuration.getClass()));
        BuildCacheServiceFactory factory = (BuildCacheServiceFactory)instantiator2.newInstance(castFactoryType, new Object[0]);
        Describer describer = new Describer();
        Object service = Cast.uncheckedNonnullCast(factory.createBuildCacheService(configuration, describer));
        ImmutableSortedMap config = ImmutableSortedMap.copyOf((Map)describer.configParams);
        BuildCacheDescription description = new BuildCacheDescription(configuration, describer.type, config);
        AbstractBuildCacheControllerFactory.logConfig(buildIdentityPath, role, description);
        return new DescribedBuildCacheService(configuration, service, description);
    }

    private static void logConfig(Path buildIdentityPath, BuildCacheServiceRole role, BuildCacheDescription description) {
        if (LOGGER.isInfoEnabled()) {
            boolean pullOnly;
            StringBuilder config = new StringBuilder();
            boolean bl = pullOnly = !description.isPush();
            if (!description.config.isEmpty() || pullOnly) {
                Object configMap;
                if (pullOnly) {
                    configMap = new LinkedHashMap();
                    configMap.put("pull-only", null);
                    configMap.putAll(description.config);
                } else {
                    configMap = description.config;
                }
                config.append(" (");
                config.append(configMap.entrySet().stream().map(input -> {
                    if (input.getValue() == null) {
                        return (String)input.getKey();
                    }
                    return (String)input.getKey() + " = " + (String)input.getValue();
                }).collect(Collectors.joining(", ")));
                config.append(")");
            }
            String buildDescription = buildIdentityPath.equals(Path.ROOT) ? "the root build" : "build '" + buildIdentityPath + "'";
            LOGGER.info("Using {} {} build cache for {}{}.", new Object[]{role.getDisplayName(), description.type == null ? description.className : description.type, buildDescription, config});
        }
    }

    private static class ResultImpl
    implements FinalizeBuildCacheConfigurationBuildOperationType.Result {
        private final boolean enabled;
        private final boolean localEnabled;
        private final FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription local;
        private final boolean remoteEnabled;
        private final FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription remote;

        ResultImpl(boolean enabled, boolean localEnabled, boolean remoteEnabled, @Nullable FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription local, @Nullable FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription remote) {
            this.enabled = enabled;
            this.localEnabled = localEnabled;
            this.remoteEnabled = remoteEnabled;
            this.local = local;
            this.remote = remote;
        }

        static FinalizeBuildCacheConfigurationBuildOperationType.Result disabled() {
            return new ResultImpl(false, false, false, null, null);
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public boolean isLocalEnabled() {
            return this.localEnabled;
        }

        @Override
        public boolean isRemoteEnabled() {
            return this.remoteEnabled;
        }

        @Override
        @Nullable
        public FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription getLocal() {
            return this.local;
        }

        @Override
        @Nullable
        public FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription getRemote() {
            return this.remote;
        }
    }

    private static class DetailsImpl
    implements FinalizeBuildCacheConfigurationBuildOperationType.Details {
        private final String buildPath;

        private DetailsImpl(String buildPath) {
            this.buildPath = buildPath;
        }

        @Override
        public String getBuildPath() {
            return this.buildPath;
        }
    }

    protected static class DescribedBuildCacheService<C, S> {
        public final C config;
        public final S service;
        public final BuildCacheDescription description;

        public DescribedBuildCacheService(C config, S service, BuildCacheDescription description) {
            this.config = config;
            this.service = service;
            this.description = description;
        }
    }

    private static class Describer
    implements BuildCacheServiceFactory.Describer {
        private String type;
        private final Map<String, String> configParams = new HashMap<String, String>();

        private Describer() {
        }

        @Override
        public BuildCacheServiceFactory.Describer type(String type) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"'type' argument cannot be null");
            return this;
        }

        @Override
        public BuildCacheServiceFactory.Describer config(String name, String value) {
            Preconditions.checkNotNull((Object)name, (Object)"'name' argument cannot be null");
            Preconditions.checkNotNull((Object)value, (Object)"'value' argument cannot be null");
            this.configParams.put(name, value);
            return this;
        }
    }

    private static final class BuildCacheDescription
    implements FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription {
        private final String className;
        private final boolean push;
        private final String type;
        private final ImmutableSortedMap<String, String> config;

        private BuildCacheDescription(BuildCache buildCache, String type, ImmutableSortedMap<String, String> config) {
            this.className = GeneratedSubclasses.unpackType(buildCache).getName();
            this.push = buildCache.isPush();
            this.type = type;
            this.config = config;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public boolean isPush() {
            return this.push;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public Map<String, String> getConfig() {
            return this.config;
        }
    }

    public static enum RemoteAccessMode {
        ONLINE,
        OFFLINE;

    }

    public static enum BuildCacheMode {
        ENABLED,
        DISABLED;

    }
}

