/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.extensions;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.gradle.internal.vfs.FileSystemAccess;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0007"}, d2={"fileSystemEntryType", "Lorg/gradle/internal/file/FileType;", "file", "Ljava/io/File;", "directoryContentHash", "Lorg/gradle/internal/hash/HashCode;", "Lorg/gradle/internal/vfs/FileSystemAccess;", "configuration-cache"})
public final class FileSystemExtensionsKt {
    @NotNull
    public static final FileType fileSystemEntryType(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return !file.exists() ? FileType.Missing : (file.isDirectory() ? FileType.Directory : FileType.RegularFile);
    }

    @NotNull
    public static final HashCode directoryContentHash(@NotNull FileSystemAccess $this$directoryContentHash, @NotNull File file) {
        HashCode hashCode;
        Intrinsics.checkNotNullParameter((Object)$this$directoryContentHash, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileSystemLocationSnapshot fileSystemLocationSnapshot = $this$directoryContentHash.read(file.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)fileSystemLocationSnapshot, (String)"read(file.path)");
        FileSystemLocationSnapshot location = fileSystemLocationSnapshot;
        if (location instanceof DirectorySnapshot) {
            Hasher hasher = Hashing.newHasher();
            Intrinsics.checkNotNullExpressionValue((Object)hasher, (String)"newHasher()");
            Hasher hasher2 = hasher;
            location.accept(new FileSystemSnapshotHierarchyVisitor(location, hasher2){
                final /* synthetic */ FileSystemLocationSnapshot $location;
                final /* synthetic */ Hasher $hasher;
                {
                    this.$location = $location;
                    this.$hasher = $hasher;
                }

                @NotNull
                public final SnapshotVisitResult visitEntry(@NotNull FileSystemLocationSnapshot locationOrChild) {
                    SnapshotVisitResult snapshotVisitResult;
                    Intrinsics.checkNotNullParameter((Object)locationOrChild, (String)"locationOrChild");
                    if (Intrinsics.areEqual((Object)locationOrChild, (Object)this.$location)) {
                        snapshotVisitResult = SnapshotVisitResult.CONTINUE;
                    } else {
                        this.$hasher.putString(locationOrChild.getName());
                        snapshotVisitResult = SnapshotVisitResult.SKIP_SUBTREE;
                    }
                    return snapshotVisitResult;
                }
            });
            HashCode hashCode2 = hasher2.hash();
            Intrinsics.checkNotNullExpressionValue((Object)hashCode2, (String)"location = read(file.pat\u2026  hasher.hash()\n        }");
            hashCode = hashCode2;
        } else {
            byte[] byArray = new byte[]{0, 0, 0, 0};
            HashCode hashCode3 = HashCode.fromBytes(byArray);
            hashCode = hashCode3;
            Intrinsics.checkNotNullExpressionValue((Object)hashCode3, (String)"fromBytes(byteArrayOf(0, 0, 0, 0))");
        }
        return hashCode;
    }
}

