/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.initialization;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.provider.ConfigurationTimeBarrier;
import org.gradle.configurationcache.InputTrackingState;
import org.gradle.configurationcache.InstrumentedExecutionAccessListener;
import org.gradle.configurationcache.initialization.ConfigurationCacheProblemsListener;
import org.gradle.configurationcache.problems.DocumentationSection;
import org.gradle.configurationcache.problems.ProblemFactory;
import org.gradle.configurationcache.problems.ProblemsListener;
import org.gradle.configurationcache.problems.PropertyProblem;
import org.gradle.configurationcache.problems.PropertyTrace;
import org.gradle.configurationcache.problems.StructuredMessage;
import org.gradle.configurationcache.serialization.Workarounds;
import org.gradle.internal.buildoption.FeatureFlags;
import org.gradle.internal.classpath.InstrumentedExecutionAccess;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.execution.WorkExecutionTracker;
import org.gradle.internal.service.scopes.ListenerService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ListenerService
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B?\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0013H\u0002J\b\u0010\u001f\u001a\u00020\u0013H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)H\u0002J \u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\"\u0010,\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)2\b\u0010-\u001a\u0004\u0018\u00010)H\u0016J\u001a\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0016J\"\u00100\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)2\b\u0010-\u001a\u0004\u0018\u00010)H\u0016J\"\u00101\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)2\b\u0010-\u001a\u0004\u0018\u00010)H\u0016J\"\u00102\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)2\b\u0010-\u001a\u0004\u0018\u00010)H\u0002J\u0018\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u00105\u001a\u00020\u00042\u0006\u0010(\u001a\u00020)H\u0002J\b\u00106\u001a\u00020\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/gradle/configurationcache/initialization/DefaultConfigurationCacheProblemsListener;", "Lorg/gradle/configurationcache/initialization/ConfigurationCacheProblemsListener;", "Lorg/gradle/internal/concurrent/Stoppable;", "problems", "Lorg/gradle/configurationcache/problems/ProblemsListener;", "problemFactory", "Lorg/gradle/configurationcache/problems/ProblemFactory;", "configurationTimeBarrier", "Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;", "workExecutionTracker", "Lorg/gradle/internal/execution/WorkExecutionTracker;", "featureFlags", "Lorg/gradle/internal/buildoption/FeatureFlags;", "inputTrackingState", "Lorg/gradle/configurationcache/InputTrackingState;", "instrumentedExecutionAccessListener", "Lorg/gradle/configurationcache/InstrumentedExecutionAccessListener;", "(Lorg/gradle/configurationcache/problems/ProblemsListener;Lorg/gradle/configurationcache/problems/ProblemFactory;Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;Lorg/gradle/internal/execution/WorkExecutionTracker;Lorg/gradle/internal/buildoption/FeatureFlags;Lorg/gradle/configurationcache/InputTrackingState;Lorg/gradle/configurationcache/InstrumentedExecutionAccessListener;)V", "atConfigurationTime", "", "disallowedAtExecutionInjectedServiceAccessed", "", "injectedServiceType", "Ljava/lang/Class;", "getterName", "", "consumer", "isBuildSrcBuild", "invocationSource", "", "isExecutingWork", "isInputTrackingDisabled", "listenerRegistrationProblem", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "invocationDescription", "exception", "Lorg/gradle/api/InvalidUserCodeException;", "locationForTask", "Lorg/gradle/configurationcache/problems/PropertyTrace;", "location", "task", "Lorg/gradle/api/internal/TaskInternal;", "onBuildScopeListenerRegistration", "listener", "onConventionAccess", "runningTask", "onExternalProcessStarted", "command", "onProjectAccess", "onTaskDependenciesAccess", "onTaskExecutionAccessProblem", "onUnsafeCredentials", "locationSpecificReason", "problemsListenerFor", "stop", "configuration-cache"})
public final class DefaultConfigurationCacheProblemsListener
implements ConfigurationCacheProblemsListener,
Stoppable {
    @NotNull
    private final ProblemsListener problems;
    @NotNull
    private final ProblemFactory problemFactory;
    @NotNull
    private final ConfigurationTimeBarrier configurationTimeBarrier;
    @NotNull
    private final WorkExecutionTracker workExecutionTracker;
    @NotNull
    private final FeatureFlags featureFlags;
    @NotNull
    private final InputTrackingState inputTrackingState;

    public DefaultConfigurationCacheProblemsListener(@NotNull ProblemsListener problems, @NotNull ProblemFactory problemFactory, @NotNull ConfigurationTimeBarrier configurationTimeBarrier, @NotNull WorkExecutionTracker workExecutionTracker, @NotNull FeatureFlags featureFlags, @NotNull InputTrackingState inputTrackingState, @NotNull InstrumentedExecutionAccessListener instrumentedExecutionAccessListener) {
        Intrinsics.checkNotNullParameter((Object)problems, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)problemFactory, (String)"problemFactory");
        Intrinsics.checkNotNullParameter((Object)configurationTimeBarrier, (String)"configurationTimeBarrier");
        Intrinsics.checkNotNullParameter((Object)workExecutionTracker, (String)"workExecutionTracker");
        Intrinsics.checkNotNullParameter((Object)featureFlags, (String)"featureFlags");
        Intrinsics.checkNotNullParameter((Object)inputTrackingState, (String)"inputTrackingState");
        Intrinsics.checkNotNullParameter((Object)instrumentedExecutionAccessListener, (String)"instrumentedExecutionAccessListener");
        this.problems = problems;
        this.problemFactory = problemFactory;
        this.configurationTimeBarrier = configurationTimeBarrier;
        this.workExecutionTracker = workExecutionTracker;
        this.featureFlags = featureFlags;
        this.inputTrackingState = inputTrackingState;
        InstrumentedExecutionAccess.setListener(instrumentedExecutionAccessListener);
    }

    @Override
    public void stop() {
        InstrumentedExecutionAccess.discardListener();
    }

    @Override
    public void disallowedAtExecutionInjectedServiceAccessed(@NotNull Class<?> injectedServiceType, @NotNull String getterName, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter(injectedServiceType, (String)"injectedServiceType");
        Intrinsics.checkNotNullParameter((Object)getterName, (String)"getterName");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.problems.onProblem(new PropertyProblem(this.problemFactory.locationForCaller(consumer), StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(injectedServiceType, getterName){
            final /* synthetic */ Class<?> $injectedServiceType;
            final /* synthetic */ String $getterName;
            {
                this.$injectedServiceType = $injectedServiceType;
                this.$getterName = $getterName;
                super(1);
            }

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                $this$build.text("accessing non-serializable type ");
                $this$build.reference(this.$injectedServiceType);
                $this$build.text(" caused by invocation ");
                $this$build.reference(this.$getterName);
            }
        })), new InvalidUserCodeException("Accessing non-serializable type '" + injectedServiceType + "' during execution time is unsupported."), DocumentationSection.RequirementsDisallowedTypes));
    }

    @Override
    public void onProjectAccess(@NotNull String invocationDescription, @NotNull TaskInternal task, @Nullable TaskInternal runningTask) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.onTaskExecutionAccessProblem(invocationDescription, task, runningTask);
    }

    @Override
    public void onConventionAccess(@NotNull String invocationDescription, @NotNull TaskInternal task, @Nullable TaskInternal runningTask) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String string2 = task.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"task.javaClass.name");
        if (Workarounds.INSTANCE.canAccessConventions(string2, invocationDescription)) {
            return;
        }
        this.onTaskExecutionAccessProblem(invocationDescription, task, runningTask);
    }

    @Override
    public void onTaskDependenciesAccess(@NotNull String invocationDescription, @NotNull TaskInternal task, @Nullable TaskInternal runningTask) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.onTaskExecutionAccessProblem(invocationDescription, task, runningTask);
    }

    @Override
    public void onExternalProcessStarted(@NotNull String command, @Nullable String consumer) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (!this.atConfigurationTime() || this.isExecutingWork() || this.isInputTrackingDisabled()) {
            return;
        }
        this.problems.onProblem(new PropertyProblem(this.problemFactory.locationForCaller(consumer), StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(command){
            final /* synthetic */ String $command;
            {
                this.$command = $command;
                super(1);
            }

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                $this$build.text("external process started ");
                $this$build.reference(this.$command);
            }
        })), new InvalidUserCodeException("Starting an external process '" + command + "' during configuration time is unsupported."), DocumentationSection.RequirementsExternalProcess));
    }

    private final void onTaskExecutionAccessProblem(String invocationDescription, TaskInternal task, TaskInternal runningTask) {
        TaskInternal contextTask;
        TaskInternal taskInternal = runningTask;
        if (taskInternal == null) {
            taskInternal = task;
        }
        boolean isExecutingOtherTask = !Intrinsics.areEqual((Object)(contextTask = taskInternal), (Object)task);
        this.problemsListenerFor(contextTask).onProblem(this.problemFactory.problem((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(isExecutingOtherTask, contextTask, invocationDescription){
            final /* synthetic */ boolean $isExecutingOtherTask;
            final /* synthetic */ TaskInternal $contextTask;
            final /* synthetic */ String $invocationDescription;
            {
                this.$isExecutingOtherTask = $isExecutingOtherTask;
                this.$contextTask = $contextTask;
                this.$invocationDescription = $invocationDescription;
                super(1);
            }

            public final void invoke(@NotNull StructuredMessage.Builder $this$problem) {
                Intrinsics.checkNotNullParameter((Object)$this$problem, (String)"$this$problem");
                if (this.$isExecutingOtherTask) {
                    $this$problem.text("execution of task ");
                    String string2 = this.$contextTask.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"contextTask.path");
                    $this$problem.reference(string2);
                    $this$problem.text(" caused invocation of ");
                    $this$problem.reference(this.$invocationDescription);
                    $this$problem.text(" in other task at execution time which is unsupported.");
                } else {
                    $this$problem.text("invocation of ");
                    $this$problem.reference(this.$invocationDescription);
                    $this$problem.text(" at execution time is unsupported.");
                }
            }
        })).exception(isExecutingOtherTask ? "Execution of " + runningTask + " caused invocation of '" + invocationDescription + "' by " + task + " at execution time which is unsupported." : "Invocation of '" + invocationDescription + "' by " + task + " at execution time is unsupported.").documentationSection(DocumentationSection.RequirementsUseProjectDuringExecution).mapLocation((Function1<? super PropertyTrace, ? extends PropertyTrace>)((Function1)new Function1<PropertyTrace, PropertyTrace>(this, contextTask){
            final /* synthetic */ DefaultConfigurationCacheProblemsListener this$0;
            final /* synthetic */ TaskInternal $contextTask;
            {
                this.this$0 = $receiver;
                this.$contextTask = $contextTask;
                super(1);
            }

            @NotNull
            public final PropertyTrace invoke(@NotNull PropertyTrace it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DefaultConfigurationCacheProblemsListener.access$locationForTask(this.this$0, it, this.$contextTask);
            }
        })).build());
    }

    private final PropertyTrace locationForTask(PropertyTrace location, TaskInternal task) {
        PropertyTrace propertyTrace;
        if (location instanceof PropertyTrace.BuildLogic) {
            propertyTrace = location;
        } else {
            Class<?> clazz = GeneratedSubclasses.unpackType(task);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"unpackType(task)");
            String string2 = task.getIdentityPath().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"task.identityPath.path");
            propertyTrace = new PropertyTrace.Task(clazz, string2);
        }
        return propertyTrace;
    }

    private final ProblemsListener problemsListenerFor(TaskInternal task) {
        ProblemsListener problemsListener;
        if (task.isCompatibleWithConfigurationCache()) {
            problemsListener = this.problems;
        } else {
            String string2 = task.getIdentityPath().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"task.identityPath.path");
            problemsListener = this.problems.forIncompatibleTask(string2);
        }
        return problemsListener;
    }

    @Override
    public void onBuildScopeListenerRegistration(@NotNull Object listener2, @NotNull String invocationDescription, @NotNull Object invocationSource) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)invocationSource, (String)"invocationSource");
        if (this.isBuildSrcBuild(invocationSource)) {
            return;
        }
        this.problems.onProblem(this.listenerRegistrationProblem(invocationDescription, new InvalidUserCodeException("Listener registration '" + invocationDescription + "' by " + invocationSource + " is unsupported.")));
    }

    @Override
    public void onUnsafeCredentials(@NotNull String locationSpecificReason, @NotNull TaskInternal task) {
        Intrinsics.checkNotNullParameter((Object)locationSpecificReason, (String)"locationSpecificReason");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.problems.onProblem(this.problemFactory.problem((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(locationSpecificReason){
            final /* synthetic */ String $locationSpecificReason;
            {
                this.$locationSpecificReason = $locationSpecificReason;
                super(1);
            }

            public final void invoke(@NotNull StructuredMessage.Builder $this$problem) {
                Intrinsics.checkNotNullParameter((Object)$this$problem, (String)"$this$problem");
                $this$problem.text("Credential values found in configuration for: ");
                $this$problem.text(this.$locationSpecificReason);
            }
        })).exception().documentationSection(DocumentationSection.RequirementsSafeCredentials).mapLocation((Function1<? super PropertyTrace, ? extends PropertyTrace>)((Function1)new Function1<PropertyTrace, PropertyTrace>(this, task){
            final /* synthetic */ DefaultConfigurationCacheProblemsListener this$0;
            final /* synthetic */ TaskInternal $task;
            {
                this.this$0 = $receiver;
                this.$task = $task;
                super(1);
            }

            @NotNull
            public final PropertyTrace invoke(@NotNull PropertyTrace it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DefaultConfigurationCacheProblemsListener.access$locationForTask(this.this$0, it, this.$task);
            }
        })).build());
    }

    private final PropertyProblem listenerRegistrationProblem(String invocationDescription, InvalidUserCodeException exception) {
        return this.problemFactory.problem(StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(invocationDescription){
            final /* synthetic */ String $invocationDescription;
            {
                this.$invocationDescription = $invocationDescription;
                super(1);
            }

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                $this$build.text("registration of listener on ");
                $this$build.reference(this.$invocationDescription);
                $this$build.text(" is unsupported");
            }
        })), exception, DocumentationSection.RequirementsBuildListeners);
    }

    private final boolean isBuildSrcBuild(Object invocationSource) {
        boolean bl;
        GradleInternal gradleInternal = invocationSource instanceof GradleInternal ? (GradleInternal)invocationSource : null;
        if (gradleInternal != null) {
            GradleInternal $this$isBuildSrcBuild_u24lambda_u240 = gradleInternal;
            boolean bl2 = false;
            bl = !$this$isBuildSrcBuild_u24lambda_u240.isRootBuild() && Intrinsics.areEqual((Object)$this$isBuildSrcBuild_u24lambda_u240.getIdentityPath().getName(), (Object)"buildSrc");
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean atConfigurationTime() {
        return this.configurationTimeBarrier.isAtConfigurationTime();
    }

    private final boolean isInputTrackingDisabled() {
        return !this.inputTrackingState.isEnabledForCurrentThread();
    }

    private final boolean isExecutingWork() {
        return this.workExecutionTracker.getCurrentTask().isPresent() || this.workExecutionTracker.isExecutingTransformAction();
    }

    public static final /* synthetic */ PropertyTrace access$locationForTask(DefaultConfigurationCacheProblemsListener $this, PropertyTrace location, TaskInternal task) {
        return $this.locationForTask(location, task);
    }
}

