/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.problems;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.configurationcache.ConfigurationCacheAction;
import org.gradle.configurationcache.ConfigurationCacheKey;
import org.gradle.configurationcache.ConfigurationCacheProblemsException;
import org.gradle.configurationcache.TooManyConfigurationCacheProblemsException;
import org.gradle.configurationcache.initialization.ConfigurationCacheStartParameter;
import org.gradle.configurationcache.problems.ConfigurationCacheProblems;
import org.gradle.configurationcache.problems.ConfigurationCacheProblemsSummary;
import org.gradle.configurationcache.problems.ConfigurationCacheReport;
import org.gradle.configurationcache.problems.ProblemSeverity;
import org.gradle.configurationcache.problems.ProblemsListener;
import org.gradle.configurationcache.problems.PropertyProblem;
import org.gradle.configurationcache.problems.PropertyTrace;
import org.gradle.configurationcache.problems.StructuredMessage;
import org.gradle.configurationcache.problems.Summary;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.problems.buildtree.ProblemReporter;
import org.jetbrains.annotations.NotNull;

@ServiceScope(value=Scopes.BuildTree.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001GB%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010#\u001a\u00020$2\u0006\u0010#\u001a\u00020\u000eJ\b\u0010%\u001a\u00020$H\u0016J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(H\u0002J\u0006\u0010)\u001a\u00020$J\u0010\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020\u0011H\u0016J\b\u0010,\u001a\u00020\u0011H\u0016J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010.\u001a\u00020\u0011H\u0002J+\u0010/\u001a\u00020$2\u0006\u00100\u001a\u00020\u00112\u0014\b\u0002\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020302\"\u000203H\u0002\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u00020$2\u0006\u00106\u001a\u000207H\u0016J\u0018\u00105\u001a\u00020$2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;H\u0002J\u0016\u0010=\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001cJ \u0010\u0006\u001a\u00020$2\u0006\u0010>\u001a\u00020;2\u000e\u0010?\u001a\n\u0012\u0006\b\u0000\u0012\u00020A0@H\u0016J\u001e\u0010B\u001a\u00020\u0011*\u00020\u001c2\u0006\u0010C\u001a\u00020\u00112\b\b\u0002\u0010D\u001a\u00020\u0011H\u0002J\f\u0010E\u001a\u00020\u0011*\u00020\u0005H\u0002J\f\u0010F\u001a\u00020\u0011*\u00020\u000eH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u000f\u001a$\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011 \u0012*\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u00130\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u0012*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u001aR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems;", "Lorg/gradle/configurationcache/problems/ProblemsListener;", "Lorg/gradle/problems/buildtree/ProblemReporter;", "Ljava/lang/AutoCloseable;", "startParameter", "Lorg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter;", "report", "Lorg/gradle/configurationcache/problems/ConfigurationCacheReport;", "cacheKey", "Lorg/gradle/configurationcache/ConfigurationCacheKey;", "listenerManager", "Lorg/gradle/internal/event/ListenerManager;", "(Lorg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter;Lorg/gradle/configurationcache/problems/ConfigurationCacheReport;Lorg/gradle/configurationcache/ConfigurationCacheKey;Lorg/gradle/internal/event/ListenerManager;)V", "cacheAction", "Lorg/gradle/configurationcache/ConfigurationCacheAction;", "incompatibleTasks", "", "", "kotlin.jvm.PlatformType", "", "isFailOnProblems", "", "isFailingBuildDueToSerializationError", "logger", "Lorg/gradle/api/logging/Logger;", "postBuildHandler", "Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems$PostBuildProblemsHandler;", "reusedProjects", "", "shouldDiscardEntry", "getShouldDiscardEntry", "()Z", "summarizer", "Lorg/gradle/configurationcache/problems/ConfigurationCacheProblemsSummary;", "updatedProjects", "action", "", "close", "discardStateDueToProblems", "summary", "Lorg/gradle/configurationcache/problems/Summary;", "failingBuildDueToSerializationError", "forIncompatibleTask", "path", "getId", "hasTooManyProblems", "incompatibleTasksSummary", "log", "msg", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "onProblem", "problem", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "severity", "Lorg/gradle/configurationcache/problems/ProblemSeverity;", "outputDirectoryFor", "Ljava/io/File;", "buildDir", "projectStateStats", "reportDir", "validationFailures", "Ljava/util/function/Consumer;", "", "counter", "singular", "plural", "requestedTasksOrDefault", "summaryText", "PostBuildProblemsHandler", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nConfigurationCacheProblems.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationCacheProblems.kt\norg/gradle/configurationcache/problems/ConfigurationCacheProblems\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,264:1\n1#2:265\n26#3:266\n*S KotlinDebug\n*F\n+ 1 ConfigurationCacheProblems.kt\norg/gradle/configurationcache/problems/ConfigurationCacheProblems\n*L\n248#1:266\n*E\n"})
public final class ConfigurationCacheProblems
implements ProblemsListener,
ProblemReporter,
AutoCloseable {
    @NotNull
    private final ConfigurationCacheStartParameter startParameter;
    @NotNull
    private final ConfigurationCacheReport report;
    @NotNull
    private final ConfigurationCacheKey cacheKey;
    @NotNull
    private final ListenerManager listenerManager;
    @NotNull
    private final ConfigurationCacheProblemsSummary summarizer;
    @NotNull
    private final PostBuildProblemsHandler postBuildHandler;
    private boolean isFailOnProblems;
    private boolean isFailingBuildDueToSerializationError;
    private int reusedProjects;
    private int updatedProjects;
    @NotNull
    private Set<String> incompatibleTasks;
    private ConfigurationCacheAction cacheAction;
    private final Logger logger;

    public ConfigurationCacheProblems(@NotNull ConfigurationCacheStartParameter startParameter, @NotNull ConfigurationCacheReport report2, @NotNull ConfigurationCacheKey cacheKey, @NotNull ListenerManager listenerManager) {
        Intrinsics.checkNotNullParameter((Object)startParameter, (String)"startParameter");
        Intrinsics.checkNotNullParameter((Object)report2, (String)"report");
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        Intrinsics.checkNotNullParameter((Object)listenerManager, (String)"listenerManager");
        this.startParameter = startParameter;
        this.report = report2;
        this.cacheKey = cacheKey;
        this.listenerManager = listenerManager;
        this.summarizer = new ConfigurationCacheProblemsSummary();
        this.postBuildHandler = new PostBuildProblemsHandler();
        this.isFailOnProblems = this.startParameter.getFailOnProblems();
        Set set2 = Sets.newConcurrentHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"newConcurrentHashSet<String>()");
        this.incompatibleTasks = set2;
        this.listenerManager.addListener(this.postBuildHandler);
        this.logger = Logging.getLogger(ConfigurationCacheProblems.class);
    }

    public final boolean getShouldDiscardEntry() {
        ConfigurationCacheAction configurationCacheAction = this.cacheAction;
        if (configurationCacheAction == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
            configurationCacheAction = null;
        }
        if (configurationCacheAction == ConfigurationCacheAction.LOAD) {
            return false;
        }
        if (this.isFailingBuildDueToSerializationError) {
            return true;
        }
        Summary summary = this.summarizer.get();
        return this.discardStateDueToProblems(summary) || this.hasTooManyProblems(summary);
    }

    @Override
    public void close() {
        this.listenerManager.removeListener(this.postBuildHandler);
    }

    public final void action(@NotNull ConfigurationCacheAction action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        this.cacheAction = action;
    }

    public final void failingBuildDueToSerializationError() {
        this.isFailingBuildDueToSerializationError = true;
        this.isFailOnProblems = false;
    }

    public final void projectStateStats(int reusedProjects, int updatedProjects) {
        this.reusedProjects = reusedProjects;
        this.updatedProjects = updatedProjects;
    }

    @Override
    @NotNull
    public ProblemsListener forIncompatibleTask(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.incompatibleTasks.add(path);
        return new ProblemsListener(this){
            final /* synthetic */ ConfigurationCacheProblems this$0;
            {
                this.this$0 = $receiver;
            }

            public void onProblem(@NotNull PropertyProblem problem2) {
                Intrinsics.checkNotNullParameter((Object)problem2, (String)"problem");
                ConfigurationCacheProblems.access$onProblem(this.this$0, problem2, ProblemSeverity.Suppressed);
            }

            public void onError(@NotNull PropertyTrace trace, @NotNull Exception error, @NotNull Function1<? super StructuredMessage.Builder, Unit> message2) {
                Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                Intrinsics.checkNotNullParameter(message2, (String)"message");
                this.onProblem(new PropertyProblem(trace, StructuredMessage.Companion.build(message2), error, null, 8, null));
            }

            @NotNull
            public ProblemsListener forIncompatibleTask(@NotNull String path) {
                return ProblemsListener.DefaultImpls.forIncompatibleTask(this, path);
            }
        };
    }

    @Override
    public void onProblem(@NotNull PropertyProblem problem2) {
        Intrinsics.checkNotNullParameter((Object)problem2, (String)"problem");
        this.onProblem(problem2, ProblemSeverity.Failure);
    }

    private final void onProblem(PropertyProblem problem2, ProblemSeverity severity) {
        if (this.summarizer.onProblem(problem2, severity)) {
            this.report.onProblem(problem2);
        }
    }

    @Override
    @NotNull
    public String getId() {
        return "configuration-cache";
    }

    @Override
    public void report(@NotNull File reportDir, @NotNull Consumer<? super Throwable> validationFailures) {
        String requestedTasks;
        String cacheActionText;
        File htmlReportFile;
        Intrinsics.checkNotNullParameter((Object)reportDir, (String)"reportDir");
        Intrinsics.checkNotNullParameter(validationFailures, (String)"validationFailures");
        Summary summary = this.summarizer.get();
        boolean failDueToProblems = summary.getFailureCount() > 0 && this.isFailOnProblems;
        boolean hasTooManyProblems = this.hasTooManyProblems(summary);
        File outputDirectory = this.outputDirectoryFor(reportDir);
        ConfigurationCacheAction configurationCacheAction = this.cacheAction;
        if (configurationCacheAction == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
            configurationCacheAction = null;
        }
        if ((htmlReportFile = this.report.writeReportFileTo$configuration_cache(outputDirectory, cacheActionText = this.summaryText(configurationCacheAction), requestedTasks = this.requestedTasksOrDefault(this.startParameter), summary.getProblemCount())) == null) {
            if (!(summary.getProblemCount() == 0)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            return;
        }
        if (failDueToProblems) {
            validationFailures.accept(new ConfigurationCacheProblemsException(summary.getCauses(), (Function0<String>)((Function0)new Function0<String>(summary, cacheActionText, htmlReportFile){
                final /* synthetic */ Summary $summary;
                final /* synthetic */ String $cacheActionText;
                final /* synthetic */ File $htmlReportFile;
                {
                    this.$summary = $summary;
                    this.$cacheActionText = $cacheActionText;
                    this.$htmlReportFile = $htmlReportFile;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$summary.textForConsole(this.$cacheActionText, this.$htmlReportFile);
                }
            })));
        } else if (hasTooManyProblems) {
            validationFailures.accept(new TooManyConfigurationCacheProblemsException(summary.getCauses(), (Function0<String>)((Function0)new Function0<String>(summary, cacheActionText, htmlReportFile){
                final /* synthetic */ Summary $summary;
                final /* synthetic */ String $cacheActionText;
                final /* synthetic */ File $htmlReportFile;
                {
                    this.$summary = $summary;
                    this.$cacheActionText = $cacheActionText;
                    this.$htmlReportFile = $htmlReportFile;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$summary.textForConsole(this.$cacheActionText, this.$htmlReportFile);
                }
            })));
        } else {
            this.logger.warn(summary.textForConsole(cacheActionText, htmlReportFile));
        }
    }

    private final String summaryText(ConfigurationCacheAction $this$summaryText) {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$summaryText.ordinal()]) {
            case 1: {
                string2 = "reusing";
                break;
            }
            case 2: {
                string2 = "storing";
                break;
            }
            case 3: {
                string2 = "updating";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    private final String requestedTasksOrDefault(ConfigurationCacheStartParameter $this$requestedTasksOrDefault) {
        List<String> list;
        List<String> it = list = $this$requestedTasksOrDefault.getRequestedTaskNames();
        boolean bl = false;
        List<String> list2 = !((Collection)it).isEmpty() ? list : null;
        if (list2 == null || (list2 = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)) == null) {
            list2 = "default tasks";
        }
        return list2;
    }

    private final File outputDirectoryFor(File buildDir) {
        return FilesKt.resolve((File)buildDir, (String)("reports/configuration-cache/" + this.cacheKey));
    }

    private final String incompatibleTasksSummary() {
        return !((Collection)this.incompatibleTasks).isEmpty() ? " because incompatible " + (this.incompatibleTasks.size() > 1 ? "tasks were" : "task was") + " found: " + CollectionsKt.joinToString$default((Iterable)this.incompatibleTasks, (CharSequence)", ", null, null, (int)0, null, (Function1)incompatibleTasksSummary.1.INSTANCE, (int)30, null) + '.' : ".";
    }

    private final boolean discardStateDueToProblems(Summary summary) {
        return (summary.getProblemCount() > 0 || !((Collection)this.incompatibleTasks).isEmpty()) && this.isFailOnProblems;
    }

    private final boolean hasTooManyProblems(Summary summary) {
        return summary.getNonSuppressedProblemCount() > this.startParameter.getMaxProblems();
    }

    private final void log(String msg, Object ... args) {
        this.logger.warn(msg, Arrays.copyOf(args, args.length));
    }

    static /* synthetic */ void log$default(ConfigurationCacheProblems configurationCacheProblems, String string2, Object[] objectArray, int n, Object object) {
        if ((n & 2) != 0) {
            boolean $i$f$emptyArray = false;
            objectArray = new Object[]{};
        }
        configurationCacheProblems.log(string2, objectArray);
    }

    private final String counter(int $this$counter, String singular, String plural) {
        String string2;
        switch ($this$counter) {
            case 0: {
                string2 = "no " + plural;
                break;
            }
            case 1: {
                string2 = "1 " + singular;
                break;
            }
            default: {
                string2 = "" + $this$counter + ' ' + plural;
            }
        }
        return string2;
    }

    static /* synthetic */ String counter$default(ConfigurationCacheProblems configurationCacheProblems, int n, String string2, String string3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string3 = string2 + 's';
        }
        return configurationCacheProblems.counter(n, string2, string3);
    }

    @Override
    public void onError(@NotNull PropertyTrace trace, @NotNull Exception error, @NotNull Function1<? super StructuredMessage.Builder, Unit> message2) {
        ProblemsListener.DefaultImpls.onError(this, trace, error, message2);
    }

    public static final /* synthetic */ void access$onProblem(ConfigurationCacheProblems $this, PropertyProblem problem2, ProblemSeverity severity) {
        $this.onProblem(problem2, severity);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems$PostBuildProblemsHandler;", "Lorg/gradle/initialization/RootBuildLifecycleListener;", "(Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems;)V", "afterStart", "", "beforeComplete", "configuration-cache"})
    private final class PostBuildProblemsHandler
    implements RootBuildLifecycleListener {
        @Override
        public void afterStart() {
        }

        @Override
        public void beforeComplete() {
            Summary summary = ConfigurationCacheProblems.this.summarizer.get();
            int problemCount = summary.getProblemCount();
            boolean hasProblems = problemCount > 0;
            boolean discardStateDueToProblems = ConfigurationCacheProblems.this.discardStateDueToProblems(summary);
            boolean hasTooManyProblems = ConfigurationCacheProblems.this.hasTooManyProblems(summary);
            String problemCountString = ConfigurationCacheProblems.counter$default(ConfigurationCacheProblems.this, problemCount, "problem", null, 2, null);
            String reusedProjectsString = ConfigurationCacheProblems.counter$default(ConfigurationCacheProblems.this, ConfigurationCacheProblems.this.reusedProjects, "project", null, 2, null);
            String updatedProjectsString = ConfigurationCacheProblems.counter$default(ConfigurationCacheProblems.this, ConfigurationCacheProblems.this.updatedProjects, "project", null, 2, null);
            if (ConfigurationCacheProblems.this.isFailingBuildDueToSerializationError && !hasProblems) {
                ConfigurationCacheProblems.log$default(ConfigurationCacheProblems.this, "Configuration cache entry discarded due to serialization error.", null, 2, null);
            } else if (ConfigurationCacheProblems.this.isFailingBuildDueToSerializationError) {
                Object[] objectArray = new Object[]{problemCountString};
                ConfigurationCacheProblems.this.log("Configuration cache entry discarded with {}.", objectArray);
            } else {
                ConfigurationCacheAction configurationCacheAction = ConfigurationCacheProblems.this.cacheAction;
                if (configurationCacheAction == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
                    configurationCacheAction = null;
                }
                if (configurationCacheAction == ConfigurationCacheAction.STORE && discardStateDueToProblems && !hasProblems) {
                    ConfigurationCacheProblems.log$default(ConfigurationCacheProblems.this, "Configuration cache entry discarded" + ConfigurationCacheProblems.this.incompatibleTasksSummary(), null, 2, null);
                } else {
                    ConfigurationCacheAction configurationCacheAction2 = ConfigurationCacheProblems.this.cacheAction;
                    if (configurationCacheAction2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
                        configurationCacheAction2 = null;
                    }
                    if (configurationCacheAction2 == ConfigurationCacheAction.STORE && discardStateDueToProblems) {
                        Object[] objectArray = new Object[]{problemCountString};
                        ConfigurationCacheProblems.this.log("Configuration cache entry discarded with {}.", objectArray);
                    } else {
                        ConfigurationCacheAction configurationCacheAction3 = ConfigurationCacheProblems.this.cacheAction;
                        if (configurationCacheAction3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
                            configurationCacheAction3 = null;
                        }
                        if (configurationCacheAction3 == ConfigurationCacheAction.STORE && hasTooManyProblems) {
                            Object[] objectArray = new Object[]{problemCountString};
                            ConfigurationCacheProblems.this.log("Configuration cache entry discarded with too many problems ({}).", objectArray);
                        } else {
                            ConfigurationCacheAction configurationCacheAction4 = ConfigurationCacheProblems.this.cacheAction;
                            if (configurationCacheAction4 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
                                configurationCacheAction4 = null;
                            }
                            if (configurationCacheAction4 == ConfigurationCacheAction.STORE && !hasProblems) {
                                ConfigurationCacheProblems.log$default(ConfigurationCacheProblems.this, "Configuration cache entry stored.", null, 2, null);
                            } else {
                                ConfigurationCacheAction configurationCacheAction5 = ConfigurationCacheProblems.this.cacheAction;
                                if (configurationCacheAction5 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
                                    configurationCacheAction5 = null;
                                }
                                if (configurationCacheAction5 == ConfigurationCacheAction.STORE) {
                                    Object[] objectArray = new Object[]{problemCountString};
                                    ConfigurationCacheProblems.this.log("Configuration cache entry stored with {}.", objectArray);
                                } else {
                                    ConfigurationCacheAction configurationCacheAction6 = ConfigurationCacheProblems.this.cacheAction;
                                    if (configurationCacheAction6 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
                                        configurationCacheAction6 = null;
                                    }
                                    if (configurationCacheAction6 == ConfigurationCacheAction.UPDATE && !hasProblems) {
                                        Object[] objectArray = new Object[]{updatedProjectsString, reusedProjectsString};
                                        ConfigurationCacheProblems.this.log("Configuration cache entry updated for {}, {} up-to-date.", objectArray);
                                    } else {
                                        ConfigurationCacheAction configurationCacheAction7 = ConfigurationCacheProblems.this.cacheAction;
                                        if (configurationCacheAction7 == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
                                            configurationCacheAction7 = null;
                                        }
                                        if (configurationCacheAction7 == ConfigurationCacheAction.UPDATE) {
                                            Object[] objectArray = new Object[]{updatedProjectsString, problemCountString, reusedProjectsString};
                                            ConfigurationCacheProblems.this.log("Configuration cache entry updated for {} with {}, {} up-to-date.", objectArray);
                                        } else {
                                            ConfigurationCacheAction configurationCacheAction8 = ConfigurationCacheProblems.this.cacheAction;
                                            if (configurationCacheAction8 == null) {
                                                Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
                                                configurationCacheAction8 = null;
                                            }
                                            if (configurationCacheAction8 == ConfigurationCacheAction.LOAD && !hasProblems) {
                                                ConfigurationCacheProblems.log$default(ConfigurationCacheProblems.this, "Configuration cache entry reused.", null, 2, null);
                                            } else {
                                                ConfigurationCacheAction configurationCacheAction9 = ConfigurationCacheProblems.this.cacheAction;
                                                if (configurationCacheAction9 == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
                                                    configurationCacheAction9 = null;
                                                }
                                                if (configurationCacheAction9 == ConfigurationCacheAction.LOAD) {
                                                    Object[] objectArray = new Object[]{problemCountString};
                                                    ConfigurationCacheProblems.this.log("Configuration cache entry reused with {}.", objectArray);
                                                } else if (hasTooManyProblems) {
                                                    Object[] objectArray = new Object[]{problemCountString};
                                                    ConfigurationCacheProblems.this.log("Too many configuration cache problems found ({}).", objectArray);
                                                } else if (hasProblems) {
                                                    Object[] objectArray = new Object[]{problemCountString};
                                                    ConfigurationCacheProblems.this.log("Configuration cache problems found ({}).", objectArray);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConfigurationCacheAction.values().length];
            try {
                nArray[ConfigurationCacheAction.LOAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigurationCacheAction.STORE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigurationCacheAction.UPDATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

