/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.List;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.TaskInternal;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.NodeValidator;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.WorkValidationException;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblem;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.internal.reflect.validation.UserManualReference;

public class DefaultNodeValidator
implements NodeValidator {
    @Override
    public boolean hasValidationProblems(LocalTaskNode node) {
        WorkValidationContext validationContext = this.validateNode(node);
        List<TypeValidationProblem> problems = validationContext.getProblems();
        this.logWarnings(problems);
        this.reportErrors(problems, node.getTask(), validationContext);
        return !problems.isEmpty();
    }

    private WorkValidationContext validateNode(LocalTaskNode node) {
        WorkValidationContext validationContext = node.getValidationContext();
        Class<?> taskType = GeneratedSubclasses.unpackType(node.getTask());
        TypeValidationContext typeValidationContext = validationContext.forType(taskType, false);
        node.getTaskProperties().validateType(typeValidationContext);
        return validationContext;
    }

    private void logWarnings(List<TypeValidationProblem> problems) {
        problems.stream().filter(problem2 -> ((Severity)((Object)((Object)problem2.getSeverity()))).isWarning()).forEach(problem2 -> {
            UserManualReference userManualReference = problem2.getUserManualReference();
            String warning = TypeValidationProblemRenderer.convertToSingleLine(TypeValidationProblemRenderer.renderMinimalInformationAbout(problem2, false, false));
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour(warning).withContext("Execution optimizations are disabled to ensure correctness.")).willBeRemovedInGradle9().withUserManual(userManualReference.getId(), userManualReference.getSection())).nagUser();
        });
    }

    private void reportErrors(List<TypeValidationProblem> problems, TaskInternal task, WorkValidationContext validationContext) {
        ImmutableSet<String> uniqueErrors = DefaultNodeValidator.getUniqueErrors(problems);
        if (!uniqueErrors.isEmpty()) {
            throw WorkValidationException.forProblems(uniqueErrors).withSummaryForContext(task.toString(), validationContext).get();
        }
    }

    private static ImmutableSet<String> getUniqueErrors(List<TypeValidationProblem> problems) {
        return (ImmutableSet)problems.stream().filter(problem2 -> !((Severity)((Object)((Object)problem2.getSeverity()))).isWarning()).map(TypeValidationProblemRenderer::renderMinimalInformationAbout).collect(ImmutableSet.toImmutableSet());
    }
}

