/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.execution.plan.ExecutionNodeAccessHierarchies;
import org.gradle.execution.plan.ExecutionNodeAccessHierarchy;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.OrdinalNode;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationContext;

public class MissingTaskDependencyDetector {
    private final ExecutionNodeAccessHierarchy outputHierarchy;
    private final ExecutionNodeAccessHierarchies.InputNodeAccessHierarchy inputHierarchy;

    public MissingTaskDependencyDetector(ExecutionNodeAccessHierarchy outputHierarchy, ExecutionNodeAccessHierarchies.InputNodeAccessHierarchy inputHierarchy) {
        this.outputHierarchy = outputHierarchy;
        this.inputHierarchy = inputHierarchy;
    }

    public void detectMissingDependencies(LocalTaskNode node, TypeValidationContext validationContext) {
        for (String outputPath : node.getMutationInfo().outputPaths) {
            this.inputHierarchy.getNodesAccessing(outputPath).stream().filter(consumerNode -> this.hasNoSpecifiedOrder(node, (Node)consumerNode)).filter(MissingTaskDependencyDetector::isEnabled).forEach(consumerWithoutDependency -> this.collectValidationProblem(node, (Node)consumerWithoutDependency, validationContext, outputPath));
        }
        final LinkedHashSet<String> taskInputs = new LinkedHashSet<String>();
        final LinkedHashSet filteredFileTreeTaskInputs = new LinkedHashSet();
        node.getTaskProperties().getInputFileProperties().forEach(spec -> spec.getPropertyFiles().visitStructure(new FileCollectionStructureVisitor(){

            @Override
            public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
                contents.forEach(location -> taskInputs.add(location.getAbsolutePath()));
            }

            @Override
            public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
                if (patterns.isEmpty()) {
                    taskInputs.add(root.getAbsolutePath());
                } else {
                    filteredFileTreeTaskInputs.add(new FilteredTree(root.getAbsolutePath(), patterns));
                }
            }

            @Override
            public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                taskInputs.add(file.getAbsolutePath());
            }
        }));
        this.inputHierarchy.recordNodeAccessingLocations(node, taskInputs);
        for (String locationConsumedByThisTask : taskInputs) {
            this.collectValidationProblemsForConsumer(node, validationContext, locationConsumedByThisTask, (Collection<Node>)this.outputHierarchy.getNodesAccessing(locationConsumedByThisTask));
        }
        for (FilteredTree filteredFileTreeInput : filteredFileTreeTaskInputs) {
            Spec<FileTreeElement> spec2 = filteredFileTreeInput.getPatterns().getAsSpec();
            this.inputHierarchy.recordNodeAccessingFileTree(node, filteredFileTreeInput.getRoot(), spec2);
            this.collectValidationProblemsForConsumer(node, validationContext, filteredFileTreeInput.getRoot(), (Collection<Node>)this.outputHierarchy.getNodesAccessing(filteredFileTreeInput.getRoot(), spec2));
        }
    }

    private void collectValidationProblemsForConsumer(LocalTaskNode consumer, TypeValidationContext validationContext, String locationConsumedByThisTask, Collection<Node> producers) {
        producers.stream().filter(producerNode -> this.hasNoSpecifiedOrder((Node)producerNode, consumer)).filter(MissingTaskDependencyDetector::isEnabled).forEach(producerWithoutDependency -> this.collectValidationProblem((Node)producerWithoutDependency, consumer, validationContext, locationConsumedByThisTask));
    }

    private static boolean isEnabled(Node node) {
        if (node instanceof LocalTaskNode) {
            TaskInternal task = ((LocalTaskNode)node).getTask();
            return task.getOnlyIf().isSatisfiedBy(task);
        }
        return false;
    }

    private boolean hasNoSpecifiedOrder(Node producerNode, Node consumerNode) {
        return MissingTaskDependencyDetector.missesDependency(producerNode, consumerNode) && MissingTaskDependencyDetector.missesDependency(consumerNode, producerNode);
    }

    private static boolean missesDependency(Node producer, Node consumer) {
        if (consumer == producer) {
            return false;
        }
        if (consumer.getDependencySuccessors().contains(producer)) {
            return false;
        }
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        HashSet<Node> seenNodes = new HashSet<Node>();
        MissingTaskDependencyDetector.addHardSuccessorTasksToQueue(consumer, seenNodes, queue);
        while (!queue.isEmpty()) {
            Node dependency = (Node)queue.removeFirst();
            if (dependency == producer) {
                return false;
            }
            MissingTaskDependencyDetector.addHardSuccessorTasksToQueue(dependency, seenNodes, queue);
        }
        return true;
    }

    private static void addHardSuccessorTasksToQueue(Node node, Set<Node> seenNodes, Queue<Node> queue) {
        node.getHardSuccessors().forEach(successor -> {
            if (successor instanceof TaskNode || successor instanceof OrdinalNode) {
                if (seenNodes.add((Node)successor)) {
                    queue.add((Node)successor);
                }
            } else {
                MissingTaskDependencyDetector.addHardSuccessorTasksToQueue(successor, seenNodes, queue);
            }
        });
    }

    private void collectValidationProblem(Node producer, Node consumer, TypeValidationContext validationContext, String consumerProducerPath) {
        validationContext.visitPropertyProblem(problem2 -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem2.withId(ValidationProblemId.IMPLICIT_DEPENDENCY)).reportAs(Severity.ERROR)).withDescription(() -> "Gradle detected a problem with the following location: '" + consumerProducerPath + "'")).happensBecause(() -> String.format("Task '%s' uses this output of task '%s' without declaring an explicit or implicit dependency. This can lead to incorrect results being produced, depending on what order the tasks are executed", consumer, producer))).addPossibleSolution(() -> "Declare task '" + producer + "' as an input of '" + consumer + "'")).addPossibleSolution(() -> "Declare an explicit dependency on '" + producer + "' from '" + consumer + "' using Task#dependsOn")).addPossibleSolution(() -> "Declare an explicit dependency on '" + producer + "' from '" + consumer + "' using Task#mustRunAfter")).documentedAt("validation_problems", "implicit_dependency")).typeIsIrrelevantInErrorMessage());
    }

    private static class FilteredTree {
        private final String root;
        private final PatternSet patterns;

        private FilteredTree(String root, PatternSet patterns) {
            this.root = root;
            this.patterns = patterns;
        }

        public String getRoot() {
            return this.root;
        }

        public PatternSet getPatterns() {
            return this.patterns;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilteredTree that = (FilteredTree)o;
            return this.root.equals(that.root) && this.patterns.equals(that.patterns);
        }

        public int hashCode() {
            return Objects.hash(this.root, this.patterns);
        }
    }
}

