/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan.edges;

import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Consumer;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.edges.ComplexDependentNodesSet;
import org.gradle.execution.plan.edges.DependencyPredecessorsOnlyNodeSet;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;

public interface DependentNodesSet {
    public static final DependentNodesSet EMPTY = new DependentNodesSet(){

        @Override
        public DependentNodesSet addDependencyPredecessors(Node fromNode) {
            return new DependencyPredecessorsOnlyNodeSet().addDependencyPredecessors(fromNode);
        }

        @Override
        public DependentNodesSet addFinalizer(Node finalizer) {
            return new ComplexDependentNodesSet(new DependencyPredecessorsOnlyNodeSet()).addFinalizer(finalizer);
        }

        @Override
        public DependentNodesSet addMustPredecessor(Node fromNode) {
            return new DependencyPredecessorsOnlyNodeSet().addMustPredecessor(fromNode);
        }

        @Override
        public void visitAllNodes(Consumer<Node> visitor) {
        }
    };

    default public SortedSet<Node> getDependencyPredecessors() {
        return ImmutableSortedSet.of();
    }

    public DependentNodesSet addDependencyPredecessors(Node var1);

    default public SortedSet<Node> getFinalizers() {
        return ImmutableSortedSet.of();
    }

    public DependentNodesSet addFinalizer(Node var1);

    default public Set<Node> getMustPredecessors() {
        return Collections.emptySet();
    }

    public DependentNodesSet addMustPredecessor(Node var1);

    public void visitAllNodes(Consumer<Node> var1);
}

