/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.TextResourceScriptSource;
import org.gradle.initialization.SettingsFactory;
import org.gradle.initialization.SettingsLocation;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.initialization.SettingsState;
import org.gradle.internal.resource.TextFileResourceLoader;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEvaluatingSettingsProcessor
implements SettingsProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptEvaluatingSettingsProcessor.class);
    private final SettingsFactory settingsFactory;
    private final GradleProperties gradleProperties;
    private final ScriptPluginFactory configurerFactory;
    private final TextFileResourceLoader textFileResourceLoader;

    public ScriptEvaluatingSettingsProcessor(ScriptPluginFactory configurerFactory, SettingsFactory settingsFactory, GradleProperties gradleProperties2, TextFileResourceLoader textFileResourceLoader) {
        this.configurerFactory = configurerFactory;
        this.settingsFactory = settingsFactory;
        this.gradleProperties = gradleProperties2;
        this.textFileResourceLoader = textFileResourceLoader;
    }

    @Override
    public SettingsState process(GradleInternal gradle, SettingsLocation settingsLocation, ClassLoaderScope baseClassLoaderScope, StartParameter startParameter) {
        Timer settingsProcessingClock = Time.startTimer();
        TextResourceScriptSource settingsScript = new TextResourceScriptSource(this.textFileResourceLoader.loadFile("settings file", settingsLocation.getSettingsFile()));
        SettingsState state = this.settingsFactory.createSettings(gradle, settingsLocation.getSettingsDir(), settingsScript, this.gradleProperties, startParameter, baseClassLoaderScope);
        SettingsInternal settings = state.getSettings();
        gradle.getBuildListenerBroadcaster().beforeSettings(settings);
        settings.getCaches().finalizeConfiguration(gradle);
        this.applySettingsScript(settingsScript, settings);
        LOGGER.debug("Timing: Processing settings took: {}", (Object)settingsProcessingClock.getElapsed());
        return state;
    }

    private void applySettingsScript(TextResourceScriptSource settingsScript, SettingsInternal settings) {
        ScriptPlugin configurer = this.configurerFactory.create(settingsScript, settings.getBuildscript(), settings.getClassLoaderScope(), settings.getBaseClassLoaderScope(), true);
        configurer.apply(settings);
    }
}

