/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.extensibility;

import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.plugins.Convention;
import org.gradle.internal.Cast;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.deprecation.DocumentedFailure;
import org.gradle.internal.reflect.JavaPropertyReflectionUtil;
import org.gradle.util.internal.GUtil;

public class ConventionAwareHelper
implements ConventionMapping,
HasConvention {
    private final Convention _convention;
    private final IConventionAware _source;
    private final Set<String> _propertyNames;
    private final Set<String> _ineligiblePropertyNames;
    private final Map<String, MappedPropertyImpl> _mappings = new HashMap<String, MappedPropertyImpl>();

    public ConventionAwareHelper(IConventionAware source, Convention convention) {
        this._source = source;
        this._convention = convention;
        this._propertyNames = JavaPropertyReflectionUtil.propertyNames(source);
        this._ineligiblePropertyNames = new HashSet<String>();
    }

    private ConventionMapping.MappedProperty map(String propertyName, MappedPropertyImpl mapping) {
        if (!this._propertyNames.contains(propertyName)) {
            throw new InvalidUserDataException("You can't map a property that does not exist: propertyName=" + propertyName);
        }
        if (this._ineligiblePropertyNames.contains(propertyName)) {
            throw ((DocumentedFailure.Builder)DocumentedFailure.builder().withSummary("Using internal convention mapping with a Provider backed property.").withUpgradeGuideSection(7, "convention_mapping")).build();
        }
        this._mappings.put(propertyName, mapping);
        return mapping;
    }

    @Override
    public ConventionMapping.MappedProperty map(String propertyName, final Closure<?> value) {
        return this.map(propertyName, new MappedPropertyImpl(){

            @Override
            public Object doGetValue(Convention convention, IConventionAware conventionAwareObject) {
                switch (value.getMaximumNumberOfParameters()) {
                    case 0: {
                        return value.call();
                    }
                    case 1: {
                        return value.call((Object)convention);
                    }
                }
                return value.call(new Object[]{convention, conventionAwareObject});
            }
        });
    }

    @Override
    public ConventionMapping.MappedProperty map(String propertyName, final Callable<?> value) {
        return this.map(propertyName, new MappedPropertyImpl(){

            @Override
            public Object doGetValue(Convention convention, IConventionAware conventionAwareObject) {
                return GUtil.uncheckedCall(value);
            }
        });
    }

    public void propertyMissing(String name, Object value) {
        if (!(value instanceof Closure)) {
            throw new MissingPropertyException(name, this.getClass());
        }
        this.map(name, (Closure)Cast.uncheckedNonnullCast(value));
    }

    @Override
    public void ineligible(String propertyName) {
        this._ineligiblePropertyNames.add(propertyName);
    }

    @Override
    public <T> T getConventionValue(T actualValue, String propertyName, boolean isExplicitValue) {
        if (isExplicitValue) {
            return actualValue;
        }
        T returnValue = actualValue;
        if (this._mappings.containsKey(propertyName)) {
            boolean useMapping = true;
            if (actualValue instanceof Collection && !((Collection)actualValue).isEmpty()) {
                useMapping = false;
            } else if (actualValue instanceof Map && !((Map)actualValue).isEmpty()) {
                useMapping = false;
            }
            if (useMapping) {
                returnValue = Cast.uncheckedNonnullCast(this._mappings.get(propertyName).getValue(this._convention, this._source));
            }
        }
        return returnValue;
    }

    @Override
    @Deprecated
    public Convention getConvention() {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateType(HasConvention.class).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_access_to_conventions")).nagUser();
        return this._convention;
    }

    private static abstract class MappedPropertyImpl
    implements ConventionMapping.MappedProperty {
        private boolean haveValue;
        private boolean cache;
        private Object cachedValue;

        private MappedPropertyImpl() {
        }

        public Object getValue(Convention convention, IConventionAware conventionAwareObject) {
            if (!this.cache) {
                return this.doGetValue(convention, conventionAwareObject);
            }
            if (!this.haveValue) {
                this.cachedValue = this.doGetValue(convention, conventionAwareObject);
                this.haveValue = true;
            }
            return this.cachedValue;
        }

        @Override
        public void cache() {
            this.cache = true;
            this.cachedValue = null;
        }

        abstract Object doGetValue(Convention var1, IConventionAware var2);
    }
}

