/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.metaobject;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.metaobject.DynamicObjectUtil;

@NotThreadSafe
public class ConfigureDelegate
extends GroovyObjectSupport {
    protected final DynamicObject _owner;
    protected final DynamicObject _delegate;
    private final Object _original_owner;
    private boolean _configuring;

    public ConfigureDelegate(Closure<?> configureClosure, Object delegate) {
        this._original_owner = configureClosure.getOwner();
        this._owner = DynamicObjectUtil.asDynamicObject(this._original_owner);
        this._delegate = DynamicObjectUtil.asDynamicObject(delegate);
    }

    public String toString() {
        return this._delegate.toString();
    }

    public Object _original_owner() {
        return this._original_owner;
    }

    protected DynamicInvokeResult _configure(String name, Object[] params) {
        return DynamicInvokeResult.notFound();
    }

    protected DynamicInvokeResult _configure(String name) {
        return DynamicInvokeResult.notFound();
    }

    public Object invokeMethod(String name, Object paramsObj) {
        Object[] params = (Object[])paramsObj;
        boolean isAlreadyConfiguring = this._configuring;
        this._configuring = true;
        try {
            DynamicInvokeResult result2 = this._delegate.tryInvokeMethod(name, params);
            if (result2.isFound()) {
                Object object = result2.getValue();
                return object;
            }
            if (!isAlreadyConfiguring && (result2 = this._configure(name, params)).isFound()) {
                Object object = result2.getValue();
                return object;
            }
            result2 = this._owner.tryInvokeMethod(name, params);
            if (result2.isFound()) {
                Object object = result2.getValue();
                return object;
            }
            throw this._delegate.methodMissingException(name, params);
        }
        finally {
            this._configuring = isAlreadyConfiguring;
        }
    }

    public void setProperty(String property2, Object newValue) {
        DynamicInvokeResult result2 = this._delegate.trySetProperty(property2, newValue);
        if (result2.isFound()) {
            return;
        }
        result2 = this._owner.trySetProperty(property2, newValue);
        if (result2.isFound()) {
            return;
        }
        throw this._delegate.setMissingProperty(property2);
    }

    public Object getProperty(String name) {
        boolean isAlreadyConfiguring = this._configuring;
        this._configuring = true;
        try {
            DynamicInvokeResult result2 = this._delegate.tryGetProperty(name);
            if (result2.isFound()) {
                Object object = result2.getValue();
                return object;
            }
            result2 = this._owner.tryGetProperty(name);
            if (result2.isFound()) {
                Object object = result2.getValue();
                return object;
            }
            if (!isAlreadyConfiguring && (result2 = this._configure(name)).isFound()) {
                Object object = result2.getValue();
                return object;
            }
            throw this._delegate.getMissingProperty(name);
        }
        finally {
            this._configuring = isAlreadyConfiguring;
        }
    }
}

