/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import javax.annotation.Nullable;
import org.gradle.internal.resolve.result.BuildableTypedResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;

public class DefaultBuildableTypedResolveResult<T, E extends Throwable>
extends DefaultResourceAwareResolveResult
implements BuildableTypedResolveResult<T, E> {
    private T result;
    private E failure;

    @Override
    public void failed(E failure) {
        this.result = null;
        this.failure = failure;
    }

    @Override
    public void resolved(T result2) {
        this.result = result2;
        this.failure = null;
    }

    @Override
    public T getResult() throws E {
        this.assertHasResult();
        if (this.failure != null) {
            throw this.failure;
        }
        return this.result;
    }

    @Override
    @Nullable
    public E getFailure() {
        this.assertHasResult();
        return this.failure;
    }

    public boolean isSuccessful() {
        return this.result != null;
    }

    @Override
    public boolean hasResult() {
        return this.failure != null || this.result != null;
    }

    protected void assertHasResult() {
        if (!this.hasResult()) {
            throw new IllegalStateException("No result has been specified.");
        }
    }
}

