/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.FileUtils;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.file.RelativeFilePathResolver;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.hash.PrimitiveHasher;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.internal.resource.EmptyFileTextResource;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.ResourceIsAFolderException;
import org.gradle.internal.resource.ResourceLocation;
import org.gradle.internal.resource.TextResource;
import org.gradle.util.GradleVersion;

public class UriTextResource
implements TextResource {
    private static final HashCode SIGNATURE = Hashing.signature(UriTextResource.class);
    protected static final Charset DEFAULT_ENCODING = Charset.forName("utf-8");
    private static final String USER_AGENT;
    private final String description;
    private final File sourceFile;
    private final URI sourceUri;
    private final RelativeFilePathResolver resolver;

    UriTextResource(String description, @Nonnull File sourceFile, RelativeFilePathResolver resolver) {
        this.description = description;
        this.sourceFile = FileUtils.normalize(sourceFile);
        this.sourceUri = sourceFile.toURI();
        this.resolver = resolver;
    }

    public UriTextResource(String description, @Nonnull URI sourceUri, RelativeFilePathResolver resolver) {
        this.description = description;
        this.sourceFile = sourceUri.getScheme().equals("file") ? FileUtils.normalize(new File(sourceUri.getPath())) : null;
        this.sourceUri = sourceUri;
        this.resolver = resolver;
    }

    public static UriTextResource from(String description, File sourceFile, RelativeFilePathResolver resolver) {
        return sourceFile.exists() ? new UriTextResource(description, sourceFile, resolver) : new EmptyFileTextResource(description, sourceFile, resolver);
    }

    @Override
    public String getDisplayName() {
        return this.getLongDisplayName().getDisplayName();
    }

    @Override
    public DisplayName getLongDisplayName() {
        if (this.sourceFile != null) {
            return Describables.quoted(this.description, this.sourceFile.getAbsolutePath());
        }
        return Describables.quoted(this.description, this.sourceUri);
    }

    @Override
    public DisplayName getShortDisplayName() {
        if (this.sourceFile != null) {
            return Describables.quoted(this.description, this.resolver.resolveForDisplay(this.sourceFile));
        }
        return Describables.quoted(this.description, this.sourceUri);
    }

    @Override
    public boolean isContentCached() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getHasEmptyContent() {
        boolean bl;
        File file = this.getFile();
        if (file != null) {
            this.assertNoDirectory();
            if (!file.exists()) {
                throw new MissingResourceException(this.sourceUri, String.format("Could not read %s as it does not exist.", this.getDisplayName()));
            }
            return file.length() == 0L;
        }
        Reader reader2 = this.getAsReader();
        try {
            bl = reader2.read() == -1;
        }
        catch (Throwable throwable) {
            try {
                reader2.close();
                throw throwable;
            }
            catch (Exception e) {
                throw ResourceExceptions.failure(this.sourceUri, String.format("Could not read %s.", this.getDisplayName()), e);
            }
        }
        reader2.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getText() {
        String string2;
        File file = this.getFile();
        if (file != null) {
            this.assertNoDirectory();
            try {
                return Files.asCharSource((File)file, (Charset)this.getCharset()).read();
            }
            catch (FileNotFoundException e) {
                throw new MissingResourceException(this.sourceUri, String.format("Could not read %s as it does not exist.", this.getDisplayName()));
            }
            catch (Exception e) {
                throw ResourceExceptions.failure(this.sourceUri, String.format("Could not read %s.", this.getDisplayName()), e);
            }
        }
        Reader reader2 = this.getAsReader();
        try {
            string2 = IOUtils.toString((Reader)reader2);
        }
        catch (Throwable throwable) {
            try {
                reader2.close();
                throw throwable;
            }
            catch (Exception e) {
                throw ResourceExceptions.failure(this.sourceUri, String.format("Could not read %s.", this.getDisplayName()), e);
            }
        }
        reader2.close();
        return string2;
    }

    @Override
    public HashCode getContentHash() throws ResourceException {
        PrimitiveHasher hasher = Hashing.newPrimitiveHasher();
        hasher.putHash(SIGNATURE);
        hasher.putString(this.getText());
        return hasher.hash();
    }

    @Override
    public Reader getAsReader() {
        this.assertNoDirectory();
        try {
            return this.openReader();
        }
        catch (FileNotFoundException e) {
            throw new MissingResourceException(this.sourceUri, String.format("Could not read %s as it does not exist.", this.getDisplayName()));
        }
        catch (Exception e) {
            throw ResourceExceptions.failure(this.sourceUri, String.format("Could not read %s.", this.getDisplayName()), e);
        }
    }

    private void assertNoDirectory() {
        if (this.sourceFile != null && this.sourceFile.isDirectory()) {
            throw new ResourceIsAFolderException(this.sourceUri, String.format("Could not read %s as it is a directory.", this.getDisplayName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getExists() {
        boolean bl;
        File file = this.getFile();
        if (file != null) {
            return file.exists();
        }
        Reader reader2 = this.openReader();
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                reader2.close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return false;
            }
            catch (Exception e) {
                throw ResourceExceptions.failure(this.sourceUri, String.format("Could not determine if %s exists.", this.getDisplayName()), e);
            }
        }
        reader2.close();
        return bl;
    }

    protected Reader openReader() throws IOException {
        File file = this.getFile();
        if (file != null) {
            return new InputStreamReader((InputStream)new FileInputStream(file), this.getCharset());
        }
        URLConnection urlConnection = this.sourceUri.toURL().openConnection();
        urlConnection.setRequestProperty("User-Agent", UriTextResource.getUserAgentString());
        if (urlConnection instanceof JarURLConnection) {
            urlConnection.setUseCaches(false);
        }
        urlConnection.connect();
        String contentType = urlConnection.getContentType();
        Charset charset = UriTextResource.extractCharacterEncoding(contentType, DEFAULT_ENCODING);
        return new InputStreamReader(urlConnection.getInputStream(), charset);
    }

    @Override
    public File getFile() {
        return this.sourceFile;
    }

    @Override
    public Charset getCharset() {
        if (this.getFile() != null) {
            return DEFAULT_ENCODING;
        }
        return null;
    }

    @Override
    public ResourceLocation getLocation() {
        return new UriResourceLocation();
    }

    public static Charset extractCharacterEncoding(String contentType, Charset defaultEncoding) {
        if (contentType == null) {
            return defaultEncoding;
        }
        int pos = UriTextResource.findFirstParameter(0, contentType);
        if (pos == -1) {
            return defaultEncoding;
        }
        StringBuilder paramName = new StringBuilder();
        StringBuilder paramValue = new StringBuilder();
        pos = UriTextResource.findNextParameter(pos, contentType, paramName, paramValue);
        while (pos != -1) {
            if (paramName.toString().equals("charset") && paramValue.length() > 0) {
                return Charset.forName(paramValue.toString());
            }
            pos = UriTextResource.findNextParameter(pos, contentType, paramName, paramValue);
        }
        return defaultEncoding;
    }

    private static int findFirstParameter(int pos, String contentType) {
        int index = contentType.indexOf(59, pos);
        if (index < 0) {
            return -1;
        }
        return index + 1;
    }

    private static int findNextParameter(int pos, String contentType, StringBuilder paramName, StringBuilder paramValue) {
        int endValue;
        if (pos >= contentType.length()) {
            return -1;
        }
        paramName.setLength(0);
        paramValue.setLength(0);
        int separator = contentType.indexOf("=", pos);
        if (separator < 0) {
            separator = contentType.length();
        }
        paramName.append(contentType.substring(pos, separator).trim());
        if (separator >= contentType.length() - 1) {
            return contentType.length();
        }
        int startValue = separator + 1;
        if (contentType.charAt(startValue) == '\"') {
            int i = ++startValue;
            while (i < contentType.length()) {
                char ch = contentType.charAt(i);
                if (ch == '\\' && i < contentType.length() - 1 && contentType.charAt(i + 1) == '\"') {
                    paramValue.append('\"');
                    i += 2;
                    continue;
                }
                if (ch == '\"') break;
                paramValue.append(ch);
                ++i;
            }
            endValue = i + 1;
        } else {
            endValue = contentType.indexOf(59, startValue);
            if (endValue < 0) {
                endValue = contentType.length();
            }
            paramValue.append(contentType.substring(startValue, endValue));
        }
        if (endValue < contentType.length() && contentType.charAt(endValue) == ';') {
            ++endValue;
        }
        return endValue;
    }

    public static String getUserAgentString() {
        return USER_AGENT;
    }

    static {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        String javaVendor = System.getProperty("java.vendor");
        String javaVersion = SystemProperties.getInstance().getJavaVersion();
        String javaVendorVersion = System.getProperty("java.vm.version");
        USER_AGENT = String.format("Gradle/%s (%s;%s;%s) (%s;%s;%s)", GradleVersion.current().getVersion(), osName, osVersion, osArch, javaVendor, javaVersion, javaVendorVersion);
    }

    private class UriResourceLocation
    implements ResourceLocation {
        private UriResourceLocation() {
        }

        @Override
        public String getDisplayName() {
            return UriTextResource.this.getDisplayName();
        }

        @Override
        @Nullable
        public File getFile() {
            return UriTextResource.this.sourceFile;
        }

        @Override
        public URI getURI() {
            return UriTextResource.this.sourceUri;
        }
    }
}

