/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.org.apache.http.client.utils.DateUtils;
import org.gradle.internal.resource.metadata.DefaultExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.gradle.internal.resource.transport.http.HttpClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseResource
implements ExternalResourceReadResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResponseResource.class);
    private final String method;
    private final URI source;
    private final HttpClientResponse response;
    private final ExternalResourceMetaData metaData;
    private boolean wasOpened;

    public HttpResponseResource(String method, URI source, HttpClientResponse response) {
        this.method = method;
        this.source = source;
        this.response = response;
        String etag = HttpResponseResource.getEtag(response);
        this.metaData = new DefaultExternalResourceMetaData(source, this.getLastModified(), this.getContentLength(), this.getContentType(), etag, HttpResponseResource.getSha1(response, etag), this.getFilename(), response.wasMissing());
    }

    public URI getURI() {
        return this.source;
    }

    public String toString() {
        return "Http " + this.method + " Resource: " + this.source;
    }

    @Override
    public ExternalResourceMetaData getMetaData() {
        return this.metaData;
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public Date getLastModified() {
        String responseHeader = this.response.getHeader("Last-Modified");
        if (responseHeader == null) {
            return new Date(0L);
        }
        try {
            return DateUtils.parseDate((String)responseHeader);
        }
        catch (Exception e) {
            return new Date(0L);
        }
    }

    private String getFilename() {
        String disposition = this.response.getHeader("Content-Disposition");
        if (disposition != null) {
            int beginIndex = disposition.indexOf("filename=\"");
            if (beginIndex > 0) {
                int endIndex = disposition.indexOf(59, beginIndex + 11);
                endIndex = endIndex < 0 ? disposition.length() : endIndex;
                return disposition.substring(beginIndex + 10, --endIndex);
            }
            beginIndex = disposition.indexOf("filename=");
            if (beginIndex > 0) {
                int endIndex = disposition.indexOf(59, beginIndex + 10);
                endIndex = endIndex < 0 ? disposition.length() : endIndex;
                return disposition.substring(beginIndex + 9, endIndex);
            }
        } else {
            URI uri = this.response.getEffectiveUri() == null ? this.source : this.response.getEffectiveUri();
            String sourceInStringForm = uri.toString();
            int fileNameIndex = sourceInStringForm.lastIndexOf("/");
            if (fileNameIndex >= 0) {
                return sourceInStringForm.substring(fileNameIndex + 1);
            }
        }
        return null;
    }

    public long getContentLength() {
        String header = this.response.getHeader("Content-Length");
        if (header == null) {
            return -1L;
        }
        try {
            return Long.parseLong(header);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public String getHeaderValue(String name) {
        return this.response.getHeader(name);
    }

    public String getContentType() {
        return this.response.getHeader("Content-Type");
    }

    public boolean isLocal() {
        return false;
    }

    @Override
    public InputStream openStream() throws IOException {
        if (this.wasOpened) {
            throw new IOException("Unable to open Stream as it was opened before.");
        }
        LOGGER.debug("Attempting to download resource {}.", (Object)this.source);
        this.wasOpened = true;
        return this.response.getContent();
    }

    @Override
    public void close() {
        this.response.close();
    }

    private static String getEtag(HttpClientResponse response) {
        return response.getHeader("ETag");
    }

    private static HashCode getSha1(HttpClientResponse response, String etag) {
        String sha1Header = response.getHeader("X-Checksum-Sha1");
        if (sha1Header != null) {
            return HashCode.fromString(sha1Header);
        }
        if (etag != null && etag.startsWith("{SHA1{")) {
            String hash = etag.substring(6, etag.length() - 2);
            return HashCode.fromString(hash);
        }
        return null;
    }
}

