/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.work;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.api.specs.Spec;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.impldep.com.google.common.base.Supplier;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.resources.AbstractResourceLockRegistry;
import org.gradle.internal.resources.DefaultLease;
import org.gradle.internal.resources.DefaultResourceLockCoordinationService;
import org.gradle.internal.resources.LeaseHolder;
import org.gradle.internal.resources.ProjectLock;
import org.gradle.internal.resources.ProjectLockRegistry;
import org.gradle.internal.resources.ProjectLockStatistics;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockContainer;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.TaskExecutionLockRegistry;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.internal.work.DefaultSynchronizer;
import org.gradle.internal.work.NoAvailableWorkerLeaseException;
import org.gradle.internal.work.Synchronizer;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.Path;
import org.gradle.util.internal.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkerLeaseService
implements WorkerLeaseService,
Stoppable {
    public static final String PROJECT_LOCK_STATS_PROPERTY = "org.gradle.internal.project.lock.stats";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWorkerLeaseService.class);
    private final int maxWorkerCount;
    private final ResourceLockCoordinationService coordinationService;
    private final TaskExecutionLockRegistry taskLockRegistry;
    private final ProjectLockRegistry projectLockRegistry;
    private final WorkerLeaseLockRegistry workerLeaseLockRegistry;
    private final ProjectLockStatisticsImpl projectLockStatistics = new ProjectLockStatisticsImpl();

    public DefaultWorkerLeaseService(ResourceLockCoordinationService coordinationService, ParallelismConfiguration parallelismConfiguration) {
        this.maxWorkerCount = parallelismConfiguration.getMaxWorkerCount();
        this.coordinationService = coordinationService;
        this.projectLockRegistry = new ProjectLockRegistry(coordinationService, parallelismConfiguration.isParallelProjectExecutionEnabled());
        this.taskLockRegistry = new TaskExecutionLockRegistry(coordinationService, this.projectLockRegistry);
        this.workerLeaseLockRegistry = new WorkerLeaseLockRegistry(coordinationService);
        LOGGER.info("Using {} worker leases.", (Object)this.maxWorkerCount);
    }

    @Override
    public int getMaxWorkerCount() {
        return this.maxWorkerCount;
    }

    @Override
    public WorkerLeaseRegistry.WorkerLease getCurrentWorkerLease() {
        Collection operations = this.workerLeaseLockRegistry.getResourceLocksByCurrentThread();
        if (operations.isEmpty()) {
            throw new NoAvailableWorkerLeaseException("No worker lease associated with the current thread");
        }
        if (operations.size() != 1) {
            throw new IllegalStateException("Expected the current thread to hold a single worker lease");
        }
        return (WorkerLeaseRegistry.WorkerLease)operations.get(0);
    }

    @Override
    public DefaultWorkerLease newWorkerLease() {
        return this.workerLeaseLockRegistry.newResourceLock();
    }

    @Override
    public boolean isWorkerThread() {
        return this.workerLeaseLockRegistry.holdsLock();
    }

    @Override
    public <T> T runAsWorkerThread(Factory<T> action) {
        Collection locks = this.workerLeaseLockRegistry.getResourceLocksByCurrentThread();
        if (!locks.isEmpty()) {
            return action.create();
        }
        return this.withLocks(Collections.singletonList(this.newWorkerLease()), action);
    }

    @Override
    public void runAsWorkerThread(Runnable action) {
        this.runAsWorkerThread(Factories.toFactory(action));
    }

    @Override
    public void runAsUnmanagedWorkerThread(Runnable action) {
        Collection locks = this.workerLeaseLockRegistry.getResourceLocksByCurrentThread();
        if (!locks.isEmpty()) {
            action.run();
        } else {
            this.withLocks(Collections.singletonList(this.workerLeaseLockRegistry.newUnmanagedLease()), action);
        }
    }

    @Override
    public Synchronizer newResource() {
        return new DefaultSynchronizer(this);
    }

    @Override
    public void stop() {
        this.coordinationService.withStateLock(new Runnable(){

            @Override
            public void run() {
                if (DefaultWorkerLeaseService.this.workerLeaseLockRegistry.hasOpenLocks()) {
                    throw new IllegalStateException("Some worker leases have not been marked as completed.");
                }
                if (DefaultWorkerLeaseService.this.projectLockRegistry.hasOpenLocks()) {
                    throw new IllegalStateException("Some project locks have not been unlocked.");
                }
                if (DefaultWorkerLeaseService.this.taskLockRegistry.hasOpenLocks()) {
                    throw new IllegalStateException("Some task execution locks have not been unlocked.");
                }
            }
        });
        if (this.projectLockStatistics.isEnabled()) {
            LOGGER.warn("Time spent waiting on project locks: " + this.projectLockStatistics.getTotalWaitTimeMillis() + "ms");
        }
    }

    @Override
    public boolean getAllowsParallelExecution() {
        return this.projectLockRegistry.getAllowsParallelExecution();
    }

    @Override
    public ResourceLock getAllProjectsLock(Path buildIdentityPath) {
        return this.projectLockRegistry.getAllProjectsLock(buildIdentityPath);
    }

    @Override
    public ResourceLock getProjectLock(Path buildIdentityPath, Path projectIdentityPath) {
        return this.projectLockRegistry.getProjectLock(buildIdentityPath, projectIdentityPath);
    }

    @Override
    public ResourceLock getTaskExecutionLock(Path buildIdentityPath, Path projectIdentityPath) {
        return this.taskLockRegistry.getTaskExecutionLock(buildIdentityPath, projectIdentityPath);
    }

    @Override
    public Collection<? extends ResourceLock> getCurrentProjectLocks() {
        return this.projectLockRegistry.getResourceLocksByCurrentThread();
    }

    @Override
    public void runAsIsolatedTask() {
        Collection<? extends ResourceLock> projectLocks = this.getCurrentProjectLocks();
        this.releaseLocks(projectLocks);
        this.releaseLocks(this.taskLockRegistry.getResourceLocksByCurrentThread());
    }

    @Override
    public void runAsIsolatedTask(Runnable runnable) {
        this.runAsIsolatedTask(Factories.toFactory(runnable));
    }

    @Override
    public <T> T runAsIsolatedTask(Factory<T> factory) {
        Collection<? extends ResourceLock> projectLocks = this.getCurrentProjectLocks();
        Collection taskLocks = this.taskLockRegistry.getResourceLocksByCurrentThread();
        ArrayList<? extends ResourceLock> locks = new ArrayList<ResourceLock>(projectLocks.size() + taskLocks.size());
        locks.addAll(projectLocks);
        locks.addAll(taskLocks);
        return this.withoutLocks(locks, factory);
    }

    @Override
    public void blocking(Runnable action) {
        Collection<? extends ResourceLock> projectLocks;
        if (this.projectLockRegistry.mayAttemptToChangeLocks() && !(projectLocks = this.getCurrentProjectLocks()).isEmpty()) {
            ArrayList<? extends ResourceLock> locks = new ArrayList<ResourceLock>(projectLocks.size() + 1);
            locks.addAll(projectLocks);
            locks.addAll(this.workerLeaseLockRegistry.getResourceLocksByCurrentThread());
            this.withoutLocks(locks, action);
            return;
        }
        Collection locks = this.workerLeaseLockRegistry.getResourceLocksByCurrentThread();
        this.withoutLocks((Collection<? extends ResourceLock>)locks, action);
    }

    @Override
    public <T> T whileDisallowingProjectLockChanges(Factory<T> action) {
        return this.projectLockRegistry.whileDisallowingLockChanges(action);
    }

    @Override
    public <T> T allowUncontrolledAccessToAnyProject(Factory<T> factory) {
        return this.projectLockRegistry.allowUncontrolledAccessToAnyResource(factory);
    }

    @Override
    public boolean isAllowedUncontrolledAccessToAnyProject() {
        return this.projectLockRegistry.isAllowedUncontrolledAccessToAnyResource();
    }

    @Override
    public void withLocks(Collection<? extends ResourceLock> locks, Runnable runnable) {
        this.withLocks(locks, Factories.toFactory(runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withLocks(Collection<? extends ResourceLock> locks, Factory<T> factory) {
        Collection<? extends ResourceLock> locksToAcquire = this.locksNotHeld(locks);
        if (locksToAcquire.isEmpty()) {
            return factory.create();
        }
        this.acquireLocksWithoutWorkerLeaseWhileBlocked(locksToAcquire);
        try {
            T t = factory.create();
            return t;
        }
        finally {
            this.releaseLocks(locksToAcquire);
        }
    }

    private void releaseLocks(Iterable<? extends ResourceLock> locks) {
        this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(locks));
    }

    private void acquireLocks(final Iterable<? extends ResourceLock> locks) {
        if (this.containsProjectLocks(locks)) {
            this.projectLockStatistics.measure(new Runnable(){

                @Override
                public void run() {
                    DefaultWorkerLeaseService.this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock(locks));
                }
            });
        } else {
            this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock(locks));
        }
    }

    private boolean containsProjectLocks(Iterable<? extends ResourceLock> locks) {
        for (ResourceLock resourceLock : locks) {
            if (!(resourceLock instanceof ProjectLock)) continue;
            return true;
        }
        return false;
    }

    private Collection<? extends ResourceLock> locksNotHeld(Collection<? extends ResourceLock> locks) {
        if (locks.isEmpty()) {
            return locks;
        }
        final ArrayList locksNotHeld = Lists.newArrayList(locks);
        this.coordinationService.withStateLock(new Runnable(){

            @Override
            public void run() {
                Iterator iterator = locksNotHeld.iterator();
                while (iterator.hasNext()) {
                    ResourceLock lock = (ResourceLock)iterator.next();
                    if (!lock.isLockedByCurrentThread()) continue;
                    iterator.remove();
                }
            }
        });
        return locksNotHeld;
    }

    @Override
    public void withoutLocks(Collection<? extends ResourceLock> locks, Runnable runnable) {
        this.withoutLocks(locks, Factories.toFactory(runnable));
    }

    @Override
    public void withoutLock(ResourceLock lock, Runnable runnable) {
        this.withoutLocks(Collections.singletonList(lock), runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withoutLocks(Collection<? extends ResourceLock> locks, Factory<T> factory) {
        if (locks.isEmpty()) {
            return factory.create();
        }
        this.assertAllLocked(locks);
        this.releaseLocks(locks);
        try {
            T t = factory.create();
            return t;
        }
        finally {
            this.acquireLocksWithoutWorkerLeaseWhileBlocked(locks);
        }
    }

    private void assertAllLocked(Collection<? extends ResourceLock> locks) {
        if (!this.allLockedByCurrentThread(locks)) {
            throw new IllegalStateException("Not all of the locks specified are currently held by the current thread.  This could lead to orphaned locks.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withReplacedLocks(Collection<? extends ResourceLock> currentLocks, ResourceLock newLock, Factory<T> factory) {
        if (currentLocks.contains(newLock)) {
            return factory.create();
        }
        List<ResourceLock> newLocks = Collections.singletonList(newLock);
        this.assertAllLocked(currentLocks);
        this.releaseLocks(currentLocks);
        this.acquireLocksWithoutWorkerLeaseWhileBlocked(newLocks);
        try {
            T t = factory.create();
            return t;
        }
        finally {
            this.releaseLocks(newLocks);
            this.acquireLocksWithoutWorkerLeaseWhileBlocked(currentLocks);
        }
    }

    @Override
    public WorkerLeaseRegistry.WorkerLeaseCompletion startWorker() {
        if (!this.workerLeaseLockRegistry.getResourceLocksByCurrentThread().isEmpty()) {
            throw new IllegalStateException("Current thread is already a worker thread");
        }
        DefaultWorkerLease lease = this.newWorkerLease();
        this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock(lease));
        return lease;
    }

    @Override
    public WorkerLeaseRegistry.WorkerLeaseCompletion maybeStartWorker() {
        Collection operations = this.workerLeaseLockRegistry.getResourceLocksByCurrentThread();
        if (operations.isEmpty()) {
            return this.startWorker();
        }
        return (WorkerLeaseRegistry.WorkerLeaseCompletion)operations.get(0);
    }

    private void acquireLocksWithoutWorkerLeaseWhileBlocked(Collection<? extends ResourceLock> locks) {
        if (!this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.tryLock(locks))) {
            this.releaseWorkerLeaseAndWaitFor(locks);
        }
    }

    private void releaseWorkerLeaseAndWaitFor(Collection<? extends ResourceLock> locks) {
        Collection workerLeases = this.workerLeaseLockRegistry.getResourceLocksByCurrentThread();
        ArrayList<? extends ResourceLock> allLocks = new ArrayList<ResourceLock>(locks.size() + workerLeases.size());
        allLocks.addAll(workerLeases);
        allLocks.addAll(locks);
        this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(workerLeases));
        this.acquireLocks(allLocks);
    }

    private boolean allLockedByCurrentThread(final Iterable<? extends ResourceLock> locks) {
        return this.coordinationService.withStateLock(new Supplier<Boolean>(){

            public Boolean get() {
                return CollectionUtils.every(locks, new Spec<ResourceLock>(){

                    @Override
                    public boolean isSatisfiedBy(ResourceLock lock) {
                        return lock.isLockedByCurrentThread();
                    }
                });
            }
        });
    }

    private static class ProjectLockStatisticsImpl
    implements ProjectLockStatistics {
        private final AtomicLong total = new AtomicLong(-1L);

        private ProjectLockStatisticsImpl() {
        }

        @Override
        public void measure(Runnable runnable) {
            if (this.isEnabled()) {
                Timer timer = Time.startTimer();
                runnable.run();
                this.total.addAndGet(timer.getElapsedMillis());
            } else {
                runnable.run();
            }
        }

        @Override
        public long getTotalWaitTimeMillis() {
            return this.total.get();
        }

        public boolean isEnabled() {
            return System.getProperty(DefaultWorkerLeaseService.PROJECT_LOCK_STATS_PROPERTY) != null;
        }
    }

    private class DefaultWorkerLease
    extends DefaultLease
    implements WorkerLeaseRegistry.WorkerLeaseCompletion,
    WorkerLeaseRegistry.WorkerLease {
        public DefaultWorkerLease(String displayName, ResourceLockCoordinationService coordinationService, ResourceLockContainer owner, LeaseHolder parent) {
            super(displayName, coordinationService, owner, parent);
        }

        @Override
        public void leaseFinish() {
            DefaultWorkerLeaseService.this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(this));
        }
    }

    private class WorkerLeaseLockRegistry
    extends AbstractResourceLockRegistry<String, DefaultWorkerLease> {
        private final LeaseHolder root;

        WorkerLeaseLockRegistry(ResourceLockCoordinationService coordinationService) {
            super(coordinationService);
            this.root = new LeaseHolder(DefaultWorkerLeaseService.this.maxWorkerCount);
        }

        DefaultWorkerLease newResourceLock() {
            return new DefaultWorkerLease("worker lease", DefaultWorkerLeaseService.this.coordinationService, this, this.root);
        }

        DefaultWorkerLease newUnmanagedLease() {
            return new DefaultWorkerLease("unmanaged lease", DefaultWorkerLeaseService.this.coordinationService, this, new LeaseHolder(1));
        }
    }
}

