/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.internal.AutoDetectingInstallationSupplier;
import org.gradle.jvm.toolchain.internal.FileBasedInstallationFactory;
import org.gradle.jvm.toolchain.internal.InstallationLocation;

public class IntellijInstallationSupplier
extends AutoDetectingInstallationSupplier {
    private static final String IDEA_JDKS_DIRECTORY_PROPERTY = "org.gradle.java.installations.idea-jdks-directory";
    private final Provider<String> ideaJdksDirectory;
    private final FileResolver fileResolver;

    @Inject
    public IntellijInstallationSupplier(ProviderFactory factory, FileResolver fileResolver) {
        this(factory, fileResolver, OperatingSystem.current());
    }

    public IntellijInstallationSupplier(ProviderFactory factory, FileResolver fileResolver, OperatingSystem os) {
        super(factory);
        this.ideaJdksDirectory = factory.gradleProperty(IDEA_JDKS_DIRECTORY_PROPERTY).orElse(this.defaultJdksDirectory(os));
        this.fileResolver = fileResolver;
    }

    private String defaultJdksDirectory(OperatingSystem os) {
        if (os.isMacOsX()) {
            return new File(System.getProperty("user.home"), "Library/Java/JavaVirtualMachines").getAbsolutePath();
        }
        return new File(System.getProperty("user.home"), ".jdks").getAbsolutePath();
    }

    @Override
    public String getSourceName() {
        return "IntelliJ IDEA";
    }

    @Override
    protected Set<InstallationLocation> findCandidates() {
        File directory = this.fileResolver.resolve(this.ideaJdksDirectory.get());
        return FileBasedInstallationFactory.fromDirectory(directory, this.getSourceName());
    }
}

