/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal.install;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.authentication.Authentication;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.verifier.HttpRedirectVerifier;
import org.gradle.internal.verifier.HttpRedirectVerifierFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureFileDownloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecureFileDownloader.class);
    private final RepositoryTransportFactory repositoryTransportFactory;

    public SecureFileDownloader(RepositoryTransportFactory repositoryTransportFactory) {
        this.repositoryTransportFactory = repositoryTransportFactory;
    }

    public ExternalResource getResourceFor(URI source, Collection<Authentication> authentications) {
        return this.createExternalResource(source, authentications);
    }

    public void download(URI source, File destination, ExternalResource resource) {
        try {
            this.downloadResource(source, destination, resource);
        }
        catch (MissingResourceException e) {
            throw new MissingResourceException(source, String.format("Unable to download '%s' into file '%s'", source, destination), e);
        }
    }

    private ExternalResource createExternalResource(final URI source, Collection<Authentication> authentications) {
        ExternalResourceName resourceName = new ExternalResourceName(source){

            @Override
            public String getShortDisplayName() {
                return source.toString();
            }
        };
        return this.getTransport(source, authentications).getRepository().withProgressLogging().resource(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadResource(URI source, File targetFile, ExternalResource resource) {
        File downloadFile = new File(targetFile.getAbsoluteFile() + ".part");
        try {
            resource.withContent(inputStream -> {
                LOGGER.info("Downloading {} to {}", (Object)resource.getDisplayName(), (Object)targetFile);
                this.copyIntoFile(source, (InputStream)inputStream, downloadFile);
            });
            try {
                this.moveFile(targetFile, downloadFile);
            }
            catch (IOException e) {
                throw new GradleException("Unable to move downloaded file to target destination", e);
            }
        }
        finally {
            downloadFile.delete();
        }
    }

    private void moveFile(File targetFile, File downloadFile) throws IOException {
        try {
            Files.move(downloadFile.toPath(), targetFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            Files.move(downloadFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void copyIntoFile(URI source, InputStream inputStream, File destination) {
        try (FileOutputStream outputStream = new FileOutputStream(destination);){
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw ResourceExceptions.getFailed(source, e);
        }
    }

    private RepositoryTransport getTransport(URI source, Collection<Authentication> authentications) {
        HttpRedirectVerifier redirectVerifier;
        try {
            redirectVerifier = HttpRedirectVerifierFactory.create(new URI(source.getScheme(), source.getAuthority(), null, null, null), false, () -> {
                throw new InvalidUserCodeException("Attempting to download a file from an insecure URI " + source + ". This is not supported, use a secure URI instead.");
            }, uri -> {
                throw new InvalidUserCodeException("Attempting to download a file from an insecure URI " + uri + ". This URI was reached as a redirect from " + source + ". This is not supported, make sure no insecure URIs appear in the redirect");
            });
        }
        catch (URISyntaxException e) {
            throw new InvalidUserCodeException("Cannot extract host information from specified URI " + source);
        }
        return this.repositoryTransportFactory.createTransport("https", "jdk toolchains", authentications, redirectVerifier);
    }
}

