/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import java.lang.management.ManagementFactory;
import java.util.UUID;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.Actions;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.agents.AgentInitializer;
import org.gradle.internal.agents.AgentStatus;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.BasicGlobalScopeServices;
import org.gradle.internal.service.scopes.GlobalScopeServices;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.launcher.bootstrap.ExecutionListener;
import org.gradle.launcher.cli.CommandLineActionCreator;
import org.gradle.launcher.cli.Parameters;
import org.gradle.launcher.cli.ParametersConverter;
import org.gradle.launcher.cli.ReportDaemonStatusAction;
import org.gradle.launcher.cli.RunBuildAction;
import org.gradle.launcher.cli.StopDaemonAction;
import org.gradle.launcher.daemon.bootstrap.ForegroundDaemonAction;
import org.gradle.launcher.daemon.client.DaemonClient;
import org.gradle.launcher.daemon.client.DaemonClientFactory;
import org.gradle.launcher.daemon.client.DaemonClientGlobalServices;
import org.gradle.launcher.daemon.client.DaemonStopClient;
import org.gradle.launcher.daemon.client.ReportDaemonStatusClient;
import org.gradle.launcher.daemon.configuration.BuildProcess;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.configuration.ForegroundDaemonConfiguration;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildExecuter;
import org.gradle.launcher.exec.DefaultBuildActionParameters;

class BuildActionsFactory
implements CommandLineActionCreator {
    private final ParametersConverter parametersConverter;
    private final ServiceRegistry loggingServices;
    private final JvmVersionDetector jvmVersionDetector;
    private final FileCollectionFactory fileCollectionFactory;
    private final ServiceRegistry basicServices;

    public BuildActionsFactory(ServiceRegistry loggingServices) {
        this.basicServices = ServiceRegistryBuilder.builder().parent(loggingServices).parent(NativeServices.getInstance()).provider(new BasicGlobalScopeServices()).build();
        this.loggingServices = loggingServices;
        this.fileCollectionFactory = this.basicServices.get(FileCollectionFactory.class);
        this.parametersConverter = new ParametersConverter(new BuildLayoutFactory(), this.basicServices.get(FileCollectionFactory.class));
        this.jvmVersionDetector = this.basicServices.get(JvmVersionDetector.class);
    }

    @Override
    public void configureCommandLineParser(CommandLineParser parser) {
        this.parametersConverter.configure(parser);
    }

    @Override
    public Action<? super ExecutionListener> createAction(CommandLineParser parser, ParsedCommandLine commandLine) {
        Parameters parameters = this.parametersConverter.convert(commandLine, null);
        parameters.getDaemonParameters().applyDefaultsFor(this.jvmVersionDetector.getJavaVersion(parameters.getDaemonParameters().getEffectiveJvm()));
        if (parameters.getDaemonParameters().isStop()) {
            return Actions.toAction(this.stopAllDaemons(parameters.getDaemonParameters()));
        }
        if (parameters.getDaemonParameters().isStatus()) {
            return Actions.toAction(this.showDaemonStatus(parameters.getDaemonParameters()));
        }
        if (parameters.getDaemonParameters().isForeground()) {
            DaemonParameters daemonParameters = parameters.getDaemonParameters();
            ForegroundDaemonConfiguration conf = new ForegroundDaemonConfiguration(UUID.randomUUID().toString(), daemonParameters.getBaseDir(), daemonParameters.getIdleTimeout(), daemonParameters.getPeriodicCheckInterval(), this.fileCollectionFactory, daemonParameters.shouldApplyInstrumentationAgent());
            return Actions.toAction(new ForegroundDaemonAction(this.loggingServices, conf));
        }
        if (parameters.getDaemonParameters().isEnabled()) {
            return Actions.toAction(this.runBuildWithDaemon(parameters.getStartParameter(), parameters.getDaemonParameters()));
        }
        if (this.canUseCurrentProcess(parameters.getDaemonParameters())) {
            return Actions.toAction(this.runBuildInProcess(parameters.getStartParameter(), parameters.getDaemonParameters()));
        }
        return Actions.toAction(this.runBuildInSingleUseDaemon(parameters.getStartParameter(), parameters.getDaemonParameters()));
    }

    private Runnable stopAllDaemons(DaemonParameters daemonParameters) {
        ServiceRegistry clientSharedServices = this.createGlobalClientServices(false);
        ServiceRegistry clientServices = clientSharedServices.get(DaemonClientFactory.class).createMessageDaemonServices(this.loggingServices.get(OutputEventListener.class), daemonParameters);
        DaemonStopClient stopClient = clientServices.get(DaemonStopClient.class);
        return new StopDaemonAction(stopClient);
    }

    private Runnable showDaemonStatus(DaemonParameters daemonParameters) {
        ServiceRegistry clientSharedServices = this.createGlobalClientServices(false);
        ServiceRegistry clientServices = clientSharedServices.get(DaemonClientFactory.class).createMessageDaemonServices(this.loggingServices.get(OutputEventListener.class), daemonParameters);
        ReportDaemonStatusClient statusClient = clientServices.get(ReportDaemonStatusClient.class);
        return new ReportDaemonStatusAction(statusClient);
    }

    private Runnable runBuildWithDaemon(StartParameterInternal startParameter, DaemonParameters daemonParameters) {
        ServiceRegistry clientSharedServices = this.createGlobalClientServices(true);
        ServiceRegistry clientServices = clientSharedServices.get(DaemonClientFactory.class).createBuildClientServices(this.loggingServices.get(OutputEventListener.class), daemonParameters, System.in);
        DaemonClient client = clientServices.get(DaemonClient.class);
        return this.runBuildAndCloseServices(startParameter, daemonParameters, client, clientSharedServices, clientServices);
    }

    @VisibleForTesting
    boolean canUseCurrentProcess(DaemonParameters requiredBuildParameters) {
        BuildProcess currentProcess = new BuildProcess(this.fileCollectionFactory);
        return currentProcess.configureForBuild(requiredBuildParameters);
    }

    private Runnable runBuildInProcess(StartParameterInternal startParameter, DaemonParameters daemonParameters) {
        ServiceRegistry globalServices = ServiceRegistryBuilder.builder().displayName("Global services").parent(this.loggingServices).parent(NativeServices.getInstance()).provider(new GlobalScopeServices(startParameter.isContinuous(), AgentStatus.of(daemonParameters.shouldApplyInstrumentationAgent()))).build();
        globalServices.get(AgentInitializer.class).maybeConfigureInstrumentationAgent();
        return this.runBuildAndCloseServices(startParameter, daemonParameters, globalServices.get(BuildExecuter.class), globalServices, globalServices.get(GradleUserHomeScopeServiceRegistry.class));
    }

    private Runnable runBuildInSingleUseDaemon(StartParameterInternal startParameter, DaemonParameters daemonParameters) {
        int maxTimeout = 120000;
        if (daemonParameters.getIdleTimeout() > maxTimeout) {
            daemonParameters.setIdleTimeout(maxTimeout);
        }
        ServiceRegistry clientSharedServices = this.createGlobalClientServices(true);
        ServiceRegistry clientServices = clientSharedServices.get(DaemonClientFactory.class).createSingleUseDaemonClientServices(clientSharedServices.get(OutputEventListener.class), daemonParameters, System.in);
        DaemonClient client = clientServices.get(DaemonClient.class);
        return this.runBuildAndCloseServices(startParameter, daemonParameters, client, clientSharedServices, clientServices);
    }

    private ServiceRegistry createGlobalClientServices(boolean usingDaemon) {
        ServiceRegistryBuilder builder = ServiceRegistryBuilder.builder().displayName("Daemon client global services").parent(NativeServices.getInstance());
        if (usingDaemon) {
            builder.parent(this.basicServices);
        } else {
            builder.provider(new GlobalScopeServices(false, AgentStatus.disabled()));
        }
        return builder.provider(new DaemonClientGlobalServices()).build();
    }

    private Runnable runBuildAndCloseServices(StartParameterInternal startParameter, DaemonParameters daemonParameters, BuildActionExecuter<BuildActionParameters, BuildRequestContext> executer, ServiceRegistry sharedServices, Object ... stopBeforeSharedServices) {
        BuildActionParameters parameters = this.createBuildActionParameters(startParameter, daemonParameters);
        CompositeStoppable stoppable = new CompositeStoppable().add(stopBeforeSharedServices).add((Object)sharedServices);
        return new RunBuildAction(executer, startParameter, this.clientMetaData(), this.getBuildStartTime(), parameters, sharedServices, stoppable);
    }

    private BuildActionParameters createBuildActionParameters(StartParameter startParameter, DaemonParameters daemonParameters) {
        return new DefaultBuildActionParameters(daemonParameters.getEffectiveSystemProperties(), daemonParameters.getEnvironmentVariables(), SystemProperties.getInstance().getCurrentDir(), startParameter.getLogLevel(), daemonParameters.isEnabled(), ClassPath.EMPTY);
    }

    private long getBuildStartTime() {
        return ManagementFactory.getRuntimeMXBean().getStartTime();
    }

    private GradleLauncherMetaData clientMetaData() {
        return new GradleLauncherMetaData();
    }
}

