/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import org.gradle.internal.UncheckedException;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginManager;
import org.gradle.internal.invocation.BuildAction;

public class BuildCompletionNotifyingBuildActionRunner
implements BuildActionRunner {
    private final BuildActionRunner delegate;
    private final GradleEnterprisePluginManager gradleEnterprisePluginManager;

    public BuildCompletionNotifyingBuildActionRunner(BuildActionRunner delegate, GradleEnterprisePluginManager gradleEnterprisePluginManager) {
        this.delegate = delegate;
        this.gradleEnterprisePluginManager = gradleEnterprisePluginManager;
    }

    @Override
    public BuildActionRunner.Result run(BuildAction action, BuildTreeLifecycleController buildController) {
        BuildActionRunner.Result result2;
        try {
            result2 = this.delegate.run(action, buildController);
        }
        catch (Throwable t) {
            this.notifyEnterprisePluginManager(BuildActionRunner.Result.failed(t));
            throw UncheckedException.throwAsUncheckedException(t);
        }
        this.notifyEnterprisePluginManager(result2);
        return result2;
    }

    private void notifyEnterprisePluginManager(BuildActionRunner.Result result2) {
        this.gradleEnterprisePluginManager.buildFinished(result2.getBuildFailure());
    }
}

