/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.plugins;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.nativeplatform.DependentSourceSet;
import org.gradle.model.Defaults;
import org.gradle.model.Each;
import org.gradle.model.Finalize;
import org.gradle.model.ModelMap;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelTypes;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.internal.NativeDependentBinariesResolutionStrategy;
import org.gradle.nativeplatform.plugins.NativeComponentPlugin;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.test.NativeTestSuiteBinarySpec;
import org.gradle.nativeplatform.test.internal.DefaultNativeTestSuiteBinarySpec;
import org.gradle.nativeplatform.test.internal.NativeDependentBinariesResolutionStrategyTestSupport;
import org.gradle.nativeplatform.test.internal.NativeTestSuiteBinarySpecInternal;
import org.gradle.nativeplatform.test.tasks.RunTestExecutable;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolvedResult;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolver;
import org.gradle.testing.base.TestSuiteContainer;
import org.gradle.testing.base.plugins.TestingModelBasePlugin;

@Incubating
public abstract class NativeBinariesTestPlugin
implements Plugin<Project> {
    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(NativeComponentPlugin.class);
        project.getPluginManager().apply(TestingModelBasePlugin.class);
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @ComponentType
        void nativeTestSuiteBinary(TypeBuilder<NativeTestSuiteBinarySpec> builder) {
            builder.defaultImplementation(DefaultNativeTestSuiteBinarySpec.class);
            builder.internalView(NativeTestSuiteBinarySpecInternal.class);
        }

        @Finalize
        void attachTestedBinarySourcesToTestBinaries(final @Each NativeTestSuiteBinarySpecInternal testSuiteBinary) {
            final NativeBinarySpec testedBinary = testSuiteBinary.getTestedBinary();
            testSuiteBinary.getInputs().withType(DependentSourceSet.class).all(new Action<DependentSourceSet>(){

                @Override
                public void execute(DependentSourceSet testSource) {
                    testSource.lib(testedBinary.getInputs());
                }
            });
            testedBinary.getInputs().all(new Action<LanguageSourceSet>(){

                @Override
                public void execute(LanguageSourceSet testedSource) {
                    testSuiteBinary.getInputs().add(testedSource);
                }
            });
        }

        @Finalize
        void configureRunTask(@Each NativeTestSuiteBinarySpecInternal testSuiteBinary) {
            BinaryNamingScheme namingScheme = testSuiteBinary.getNamingScheme();
            NativeTestSuiteBinarySpec.TasksCollection tasks = testSuiteBinary.getTasks();
            InstallExecutable installTask = (InstallExecutable)tasks.getInstall();
            RunTestExecutable runTask = (RunTestExecutable)tasks.getRun();
            runTask.getInputs().files(installTask.getOutputs().getFiles()).withPropertyName("installTask.outputs").withPathSensitivity(PathSensitivity.RELATIVE);
            runTask.setExecutable(installTask.getRunScriptFile().get().getAsFile().getPath());
            Project project = runTask.getProject();
            runTask.setOutputDir(namingScheme.getOutputDirectory(project.getBuildDir(), "test-results"));
        }

        @Defaults
        void registerNativeDependentBinariesResolutionStrategyTestSupport(DependentBinariesResolver resolver) {
            NativeDependentBinariesResolutionStrategy nativeStrategy = resolver.getStrategy("native", NativeDependentBinariesResolutionStrategy.class);
            nativeStrategy.setTestSupport(new NativeDependentBinariesResolutionStrategyTestSupport());
        }

        @Finalize
        public void wireBuildDependentsTasks(ModelMap<Task> tasks, TestSuiteContainer testSuites, BinaryContainer binaries, final DependentBinariesResolver dependentsResolver, ServiceRegistry serviceRegistry) {
            Task buildDependents;
            final ProjectModelResolver projectModelResolver = serviceRegistry.get(ProjectModelResolver.class);
            ModelMap<NativeBinarySpecInternal> nativeBinaries = binaries.withType(NativeBinarySpecInternal.class);
            for (final NativeBinarySpecInternal binary : nativeBinaries) {
                buildDependents = tasks.get(binary.getNamingScheme().getTaskName("buildDependents"));
                Callable<Iterable<Task>> deferredDependencies = new Callable<Iterable<Task>>(){

                    @Override
                    public Iterable<Task> call() {
                        ArrayList dependencies = Lists.newArrayList();
                        DependentBinariesResolvedResult result2 = dependentsResolver.resolve(binary).getRoot();
                        for (DependentBinariesResolvedResult dependent : result2.getChildren()) {
                            if (!dependent.isBuildable() || !dependent.isTestSuite()) continue;
                            ModelRegistry modelRegistry = projectModelResolver.resolveProjectModel(dependent.getId().getProjectPath());
                            ModelMap<NativeBinarySpecInternal> projectBinaries = modelRegistry.realize("binaries", ModelTypes.modelMap(NativeBinarySpecInternal.class));
                            NativeBinarySpecInternal dependentBinary = projectBinaries.get(dependent.getProjectScopedName());
                            NativeTestSuiteBinarySpecInternal testSuiteBinary = (NativeTestSuiteBinarySpecInternal)dependentBinary;
                            dependencies.add(testSuiteBinary.getCheckTask());
                        }
                        return dependencies;
                    }
                };
                buildDependents.dependsOn(deferredDependencies);
            }
            for (NativeTestSuiteBinarySpecInternal testSuiteBinary : nativeBinaries.withType(NativeTestSuiteBinarySpecInternal.class)) {
                buildDependents = tasks.get(testSuiteBinary.getNamingScheme().getTaskName("buildDependents"));
                buildDependents.dependsOn(testSuiteBinary.getCheckTask());
            }
        }
    }
}

