/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.tasks;

import java.io.File;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.AbstractExecTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not made cacheable, yet")
public abstract class RunTestExecutable
extends AbstractExecTask<RunTestExecutable>
implements VerificationTask {
    private File outputDir;
    private boolean ignoreFailures;

    public RunTestExecutable() {
        super(RunTestExecutable.class);
    }

    @Override
    @TaskAction
    protected void exec() {
        this.getOutputDir().mkdirs();
        this.setExecutable(this.getExecutable());
        this.setWorkingDir(this.getOutputDir());
        try {
            super.exec();
        }
        catch (Exception e) {
            this.handleTestFailures(e);
        }
    }

    private void handleTestFailures(Exception e) {
        String message2 = "There were failing tests";
        String resultsUrl = new ConsoleRenderer().asClickableFileUrl(this.getOutputDir());
        message2 = message2.concat(". See the results at: " + resultsUrl);
        if (!this.isIgnoreFailures()) {
            throw new GradleException(message2, e);
        }
        this.getLogger().warn(message2);
    }

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    @Override
    @Input
    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    @Internal
    public boolean isIgnoreFailures() {
        return this.ignoreFailures;
    }

    @Override
    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }
}

