/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.org.apache.commons.lang.StringEscapeUtils;

@Deprecated
public class TextUtil {
    private static final Pattern WHITESPACE = Pattern.compile("\\s*");
    private static final Pattern UPPER_CASE = Pattern.compile("(?=\\p{Upper})");
    private static final Joiner KEBAB_JOINER = Joiner.on((String)"-");
    private static final Function<String, String> TO_LOWERCASE = new Function<String, String>(){

        public String apply(String input) {
            return input.toLowerCase();
        }
    };
    private static final Pattern NON_UNIX_LINE_SEPARATORS = Pattern.compile("\r\n|\r");

    private static void logDeprecation() {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateType(TextUtil.class).willBeRemovedInGradle9().withUpgradeGuideSection(7, "org_gradle_util_reports_deprecations")).nagUser();
    }

    public TextUtil() {
        TextUtil.logDeprecation();
    }

    public static String getWindowsLineSeparator() {
        TextUtil.logDeprecation();
        return "\r\n";
    }

    public static String getUnixLineSeparator() {
        TextUtil.logDeprecation();
        return "\n";
    }

    public static String getPlatformLineSeparator() {
        TextUtil.logDeprecation();
        return TextUtil.getPlatformLineSeparatorInternal();
    }

    private static String getPlatformLineSeparatorInternal() {
        return SystemProperties.getInstance().getLineSeparator();
    }

    @Nullable
    public static String convertLineSeparators(@Nullable String str, String sep) {
        TextUtil.logDeprecation();
        return str == null ? null : TextUtil.replaceLineSeparatorsOf(str, sep);
    }

    public static String convertLineSeparatorsToUnix(String str) {
        TextUtil.logDeprecation();
        return TextUtil.convertLineSeparatorsToUnixInternal(str);
    }

    private static String convertLineSeparatorsToUnixInternal(String str) {
        return TextUtil.replaceAll(NON_UNIX_LINE_SEPARATORS, (CharSequence)str, "\n");
    }

    public static String replaceLineSeparatorsOf(CharSequence string2, String bySeparator) {
        TextUtil.logDeprecation();
        return TextUtil.replaceLineSeparatorsInternalOf(string2, bySeparator);
    }

    private static String replaceLineSeparatorsInternalOf(CharSequence string2, String bySeparator) {
        TextUtil.logDeprecation();
        return TextUtil.replaceAll("\r\n|\r|\n", string2, bySeparator);
    }

    private static String replaceAll(String regex, CharSequence inString, String byString) {
        return TextUtil.replaceAll(Pattern.compile(regex), inString, byString);
    }

    private static String replaceAll(Pattern pattern, CharSequence inString, String byString) {
        return pattern.matcher(inString).replaceAll(byString);
    }

    public static String toPlatformLineSeparators(String str) {
        TextUtil.logDeprecation();
        return str == null ? null : TextUtil.replaceLineSeparatorsInternalOf(str, TextUtil.getPlatformLineSeparatorInternal());
    }

    @Nullable
    public static String normaliseLineSeparators(@Nullable String str) {
        TextUtil.logDeprecation();
        return TextUtil.normaliseLineSeparatorsInternal(str);
    }

    private static String normaliseLineSeparatorsInternal(@Nullable String str) {
        return str == null ? null : TextUtil.convertLineSeparatorsToUnixInternal(str);
    }

    public static String normaliseFileSeparators(String path) {
        TextUtil.logDeprecation();
        return TextUtil.normaliseFileSeparatorsInternal(path);
    }

    private static String normaliseFileSeparatorsInternal(String path) {
        return path.replace(File.separatorChar, '/');
    }

    public static String escapeString(Object obj) {
        TextUtil.logDeprecation();
        return obj == null ? null : StringEscapeUtils.escapeJava((String)obj.toString());
    }

    public static boolean containsWhitespace(String str) {
        TextUtil.logDeprecation();
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String indent(String text, String indent) {
        TextUtil.logDeprecation();
        StringBuilder builder = new StringBuilder();
        String[] lines = text.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!WHITESPACE.matcher(line).matches()) {
                builder.append(indent);
            }
            builder.append(line);
            if (i >= lines.length - 1) continue;
            builder.append('\n');
        }
        return builder.toString();
    }

    public static String shorterOf(String s1, String s2) {
        TextUtil.logDeprecation();
        if (s2.length() >= s1.length()) {
            return s1;
        }
        return s2;
    }

    public static String minus(String originalString, String removeString) {
        TextUtil.logDeprecation();
        String s = originalString.toString();
        int index = s.indexOf(removeString);
        if (index == -1) {
            return s;
        }
        int end = index + removeString.length();
        if (s.length() > end) {
            return s.substring(0, index) + s.substring(end);
        }
        return s.substring(0, index);
    }

    public static String normaliseFileAndLineSeparators(String in) {
        TextUtil.logDeprecation();
        return TextUtil.normaliseLineSeparatorsInternal(TextUtil.normaliseFileSeparatorsInternal(in));
    }

    public static String camelToKebabCase(String camelCase) {
        TextUtil.logDeprecation();
        return KEBAB_JOINER.join(Iterables.transform(Arrays.asList(UPPER_CASE.split(camelCase)), TO_LOWERCASE));
    }

    public static String toLowerCaseLocaleSafe(String s) {
        TextUtil.logDeprecation();
        return s.toLowerCase(Locale.ENGLISH);
    }
}

