/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.quickfix.OpenMavenImportingSettingsQuickFix;
import org.jetbrains.idea.maven.buildtool.quickfix.OpenMavenRunnerSettingsQuickFix;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.MavenJvmConfigOpenQuickFix;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.MavenRunConfigurationOpenQuickFix;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ&\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/MavenJvmConfigBuildIssue;", "", "()V", "VM_INIT_ERROR", "", "getImportIssue", "Lcom/intellij/build/issue/BuildIssue;", "title", "errorMessage", "project", "Lcom/intellij/openapi/project/Project;", "getRunnerIssue", "runConfiguration", "Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenBadJvmConfigEventParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenBadJvmConfigEventParser.kt\norg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/MavenJvmConfigBuildIssue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n1#2:192\n1855#3,2:193\n*S KotlinDebug\n*F\n+ 1 MavenBadJvmConfigEventParser.kt\norg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/MavenJvmConfigBuildIssue\n*L\n171#1:193,2\n*E\n"})
public final class MavenJvmConfigBuildIssue {
    @NotNull
    public static final MavenJvmConfigBuildIssue INSTANCE = new MavenJvmConfigBuildIssue();
    @NotNull
    public static final String VM_INIT_ERROR = "Error occurred during initialization of VM";

    private MavenJvmConfigBuildIssue() {
    }

    @NotNull
    public final BuildIssue getRunnerIssue(@NotNull String title, @NotNull String errorMessage, @NotNull Project project2, @NotNull MavenRunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)runConfiguration), (String)"runConfiguration");
        VirtualFile jvmConfig = MavenExternalParameters.getJvmConfig(runConfiguration.getRunnerParameters().getWorkingDirPath());
        List<VirtualFile> list = MavenProjectsManager.getInstance(project2).getProjectsFiles();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getInstance(project).projectsFiles");
        MavenProject mavenProject2 = (MavenProject)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<VirtualFile, Boolean>(runConfiguration){
            final /* synthetic */ MavenRunConfiguration $runConfiguration;
            {
                this.$runConfiguration = $runConfiguration;
                super(1);
            }

            @NotNull
            public final Boolean invoke(VirtualFile it) {
                return ((Object)Paths.get(this.$runConfiguration.getRunnerParameters().getWorkingDirPath(), new String[0])).equals(it.toNioPath().getParent());
            }
        })), (Function1)((Function1)new Function1<VirtualFile, MavenProject>(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            @Nullable
            public final MavenProject invoke(VirtualFile it) {
                return MavenProjectsManager.getInstance(this.$project).findProject(it);
            }
        })));
        List quickFixes = new ArrayList();
        StringBuilder issueDescription = new StringBuilder(errorMessage);
        issueDescription.append("\n\n");
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.header.possible.solution", new Object[0]));
        issueDescription.append("\n");
        OpenMavenRunnerSettingsQuickFix openMavenRunnerSettingsQuickFix = new OpenMavenRunnerSettingsQuickFix(MavenConfigurableBundle.message("maven.settings.runner.vm.options", new Object[0]));
        quickFixes.add(openMavenRunnerSettingsQuickFix);
        Object[] objectArray = new Object[]{openMavenRunnerSettingsQuickFix.getId()};
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.jvm.options.runner.settings", objectArray));
        issueDescription.append("\n");
        Object it = runConfiguration;
        boolean bl = false;
        RunManagerImpl runManagerImpl = RunManagerImpl.Companion.getInstanceImpl(project2);
        MavenRunConfigurationType mavenRunConfigurationType = MavenRunConfigurationType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)mavenRunConfigurationType, (String)"getInstance()");
        ConfigurationType configurationType = mavenRunConfigurationType;
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
        RunnerAndConfigurationSettings configurationById = runManagerImpl.findConfigurationByTypeAndName(configurationType, string);
        if (configurationById != null && configurationById.getConfiguration() instanceof MavenRunConfiguration) {
            RunConfiguration runConfiguration2 = configurationById.getConfiguration();
            Intrinsics.checkNotNull((Object)runConfiguration2, (String)"null cannot be cast to non-null type org.jetbrains.idea.maven.execution.MavenRunConfiguration");
            MavenRunConfiguration configuration = (MavenRunConfiguration)runConfiguration2;
            MavenRunnerSettings mavenRunnerSettings = configuration.getRunnerSettings();
            it = mavenRunnerSettings != null ? mavenRunnerSettings.getVmOptions() : null;
            if (!(it == null || StringsKt.isBlank((CharSequence)it))) {
                MavenRunConfigurationOpenQuickFix mavenRunConfigurationOpenQuickFix = new MavenRunConfigurationOpenQuickFix(configurationById);
                quickFixes.add(mavenRunConfigurationOpenQuickFix);
                Object[] objectArray2 = new Object[]{mavenRunConfigurationOpenQuickFix.getId()};
                issueDescription.append(MavenProjectBundle.message("maven.quickfix.jvm.options.run.configuration", objectArray2));
                issueDescription.append("\n");
            }
        }
        if (jvmConfig != null) {
            MavenJvmConfigOpenQuickFix mavenJvmConfigOpenQuickFix = new MavenJvmConfigOpenQuickFix(jvmConfig);
            quickFixes.add(mavenJvmConfigOpenQuickFix);
            Object[] objectArray3 = new Object[2];
            Object object = mavenProject2;
            if (object == null || (object = ((MavenProject)object).getDisplayName()) == null) {
                object = "";
            }
            objectArray3[0] = object;
            objectArray3[1] = mavenJvmConfigOpenQuickFix.getId();
            issueDescription.append(MavenProjectBundle.message("maven.quickfix.jvm.options.config.file", objectArray3));
        }
        return new BuildIssue(title, issueDescription, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            {
                this.title = $title;
                String string = $issueDescription.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"issueDescription.toString()");
                this.description = string;
                this.quickFixes = $quickFixes;
            }

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                return null;
            }
        };
    }

    @NotNull
    public final BuildIssue getImportIssue(@NotNull String title, @NotNull String errorMessage, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        List quickFixes = new ArrayList();
        StringBuilder issueDescription = new StringBuilder(errorMessage);
        issueDescription.append("\n\n");
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.header.possible.solution", new Object[0]));
        issueDescription.append("\n");
        OpenMavenImportingSettingsQuickFix openMavenImportingSettingsQuickFix = new OpenMavenImportingSettingsQuickFix(MavenConfigurableBundle.message("maven.settings.importing.vm.options", new Object[0]));
        quickFixes.add(openMavenImportingSettingsQuickFix);
        Object[] objectArray = new Object[]{openMavenImportingSettingsQuickFix.getId()};
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.jvm.options.import.settings", objectArray));
        List<MavenProject> list = MavenProjectsManager.getInstance(project2).getRootProjects();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getInstance(project).rootProjects");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MavenProject it = (MavenProject)element$iv;
            boolean bl = false;
            String it2 = it.getFile().getPath();
            boolean bl2 = false;
            it2 = MavenDistributionsCache.getInstance(project2).getMultimoduleDirectory(it2);
            boolean bl3 = false;
            VirtualFile jvmConfig = MavenExternalParameters.getJvmConfig(it2);
            if (jvmConfig == null) continue;
            MavenJvmConfigOpenQuickFix mavenJvmConfigOpenQuickFix = new MavenJvmConfigOpenQuickFix(jvmConfig);
            quickFixes.add(mavenJvmConfigOpenQuickFix);
            issueDescription.append("\n");
            Object[] objectArray2 = new Object[]{it.getDisplayName(), mavenJvmConfigOpenQuickFix.getId()};
            issueDescription.append(MavenProjectBundle.message("maven.quickfix.jvm.options.config.file", objectArray2));
        }
        return new BuildIssue(title, issueDescription, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            {
                this.title = $title;
                String string = $issueDescription.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"issueDescription.toString()");
                this.description = string;
                this.quickFixes = $quickFixes;
            }

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                return null;
            }
        };
    }
}

