/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.codeInsight.ExternalAnnotationsArtifactsResolver;
import com.intellij.codeInsight.externalAnnotation.location.AnnotationsLocation;
import com.intellij.codeInsight.externalAnnotation.location.AnnotationsLocationSearcher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryEntityUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenExternalAnnotationsConfigurator;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.TasksBundle;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016JC\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102#\u0010\u0012\u001a\u001f\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0013H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J(\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u001dH\u0016J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenExternalAnnotationsConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenImporter;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;", "()V", "myProcessedLibraries", "Ljava/util/HashSet;", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "Lkotlin/collections/HashSet;", "afterModelApplied", "", "context", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$AppliedModelContext;", "doConfigure", "project", "Lcom/intellij/openapi/project/Project;", "mavenProjects", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/idea/maven/project/MavenProject;", "libraryFinder", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "libraryName", "Lcom/intellij/openapi/roots/libraries/Library;", "getResolvers", "", "Lcom/intellij/codeInsight/ExternalAnnotationsArtifactsResolver;", "isMigratedToConfigurator", "", "postProcess", "module", "Lcom/intellij/openapi/module/Module;", "mavenProject", "changes", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "modifiableModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "processChangedModulesOnly", "shouldImportExternalAnnotations", "shouldRun", "Companion", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenExternalAnnotationsConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenExternalAnnotationsConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenExternalAnnotationsConfigurator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n*L\n1#1,122:1\n674#2:123\n704#2,4:124\n1295#2:128\n1295#2,2:129\n1296#2:131\n42#3,10:132\n*S KotlinDebug\n*F\n+ 1 MavenExternalAnnotationsConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenExternalAnnotationsConfigurator\n*L\n40#1:123\n40#1:124,4\n69#1:128\n72#1:129,2\n69#1:131\n89#1:132,10\n*E\n"})
final class MavenExternalAnnotationsConfigurator
extends MavenImporter
implements MavenWorkspaceConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashSet<MavenArtifact> myProcessedLibraries = new HashSet();
    @NotNull
    private static final Logger LOG;

    public MavenExternalAnnotationsConfigurator() {
        super("org.apache.maven.plugins", "maven-compiler-plugin");
    }

    @Override
    public boolean processChangedModulesOnly() {
        return false;
    }

    @Override
    public boolean isMigratedToConfigurator() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void afterModelApplied(@NotNull MavenWorkspaceConfigurator.AppliedModelContext context2) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!this.shouldRun(context2.getProject())) {
            return;
        }
        Sequence projectsWithChanges2 = SequencesKt.map((Sequence)SequencesKt.filter(context2.getMavenProjectsWithModules(), (Function1)afterModelApplied.projectsWithChanges.1.INSTANCE), (Function1)afterModelApplied.projectsWithChanges.2.INSTANCE);
        if (SequencesKt.none((Sequence)projectsWithChanges2)) {
            return;
        }
        Sequence sequence = SequencesKt.mapNotNull(context2.importedEntities(LibraryEntity.class), (Function1)((Function1)new Function1<LibraryEntity, Library>(context2){
            final /* synthetic */ MavenWorkspaceConfigurator.AppliedModelContext $context;
            {
                this.$context = $context;
                super(1);
            }

            @Nullable
            public final Library invoke(@NotNull LibraryEntity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return LibraryEntityUtils.findLibraryBridge((LibraryEntity)it, this.$context.getStorage());
            }
        }));
        boolean $i$f$associateBy = false;
        void var6_5 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Library library = (Library)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        Map libraryNameMap2 = destination$iv$iv;
        this.doConfigure(context2.getProject(), (Sequence<? extends MavenProject>)projectsWithChanges2, (Function1<? super String, ? extends Library>)((Function1)new Function1<String, Library>((Map<String, ? extends Library>)libraryNameMap2){
            final /* synthetic */ Map<String, Library> $libraryNameMap;
            {
                this.$libraryNameMap = $libraryNameMap;
                super(1);
            }

            @Nullable
            public final Library invoke(@NotNull String libraryName) {
                Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
                return this.$libraryNameMap.get(libraryName);
            }
        }));
    }

    @Override
    public void postProcess(@NotNull Module module2, @NotNull MavenProject mavenProject2, @NotNull MavenProjectChanges changes, @NotNull IdeModifiableModelsProvider modifiableModelsProvider) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        if (!this.shouldRun(project2)) {
            return;
        }
        Project project3 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"module.project");
        Object[] objectArray = new MavenProject[]{mavenProject2};
        this.doConfigure(project3, (Sequence<? extends MavenProject>)SequencesKt.sequenceOf((Object[])objectArray), (Function1<? super String, ? extends Library>)((Function1)new Function1<String, Library>(modifiableModelsProvider){
            final /* synthetic */ IdeModifiableModelsProvider $modifiableModelsProvider;
            {
                this.$modifiableModelsProvider = $modifiableModelsProvider;
                super(1);
            }

            @Nullable
            public final Library invoke(@NotNull String libraryName) {
                Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
                return this.$modifiableModelsProvider.getLibraryByName(libraryName);
            }
        }));
    }

    private final boolean shouldRun(Project project2) {
        if (!this.shouldImportExternalAnnotations(project2)) {
            return false;
        }
        List<ExternalAnnotationsArtifactsResolver> resolvers = this.getResolvers();
        return !((Collection)resolvers).isEmpty();
    }

    private final List<ExternalAnnotationsArtifactsResolver> getResolvers() {
        return ExternalAnnotationsArtifactsResolver.EP_NAME.getExtensionList();
    }

    /*
     * WARNING - void declaration
     */
    private final void doConfigure(Project project2, Sequence<? extends MavenProject> mavenProjects2, Function1<? super String, ? extends Library> libraryFinder) {
        Map toProcess = new LinkedHashMap();
        Sequence<? extends MavenProject> $this$forEach$iv = mavenProjects2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            MavenProject eachMavenProject = (MavenProject)element$iv;
            boolean bl = false;
            List<MavenArtifact> list = eachMavenProject.getDependencies();
            Intrinsics.checkNotNullExpressionValue(list, (String)"eachMavenProject.dependencies");
            Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<MavenArtifact, Boolean>(this){
                final /* synthetic */ MavenExternalAnnotationsConfigurator this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(MavenArtifact it) {
                    return !MavenExternalAnnotationsConfigurator.access$getMyProcessedLibraries$p(this.this$0).contains(it);
                }
            }));
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                MavenArtifact it = (MavenArtifact)element$iv2;
                boolean bl2 = false;
                String string = it.getLibraryName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.libraryName");
                Library library = (Library)libraryFinder.invoke((Object)string);
                if (library == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                toProcess.put(it, library);
                this.myProcessedLibraries.add(it);
            }
        }
        if (toProcess.isEmpty()) {
            return;
        }
        int totalSize = toProcess.size();
        Ref.IntRef count = new Ref.IntRef();
        Set locationsToSkip = new LinkedHashSet();
        String string = TasksBundle.message("maven.tasks.external.annotations.resolving.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"maven.tasks.ext\u2026tations.resolving.title\")");
        String title$iv = string;
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, title$iv, cancellable$iv, this, toProcess, project2, count, totalSize, locationsToSkip){
            final /* synthetic */ MavenExternalAnnotationsConfigurator this$0;
            final /* synthetic */ Map $toProcess$inlined;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ Ref.IntRef $count$inlined;
            final /* synthetic */ int $totalSize$inlined;
            final /* synthetic */ Set $locationsToSkip$inlined;
            {
                this.this$0 = mavenExternalAnnotationsConfigurator;
                this.$toProcess$inlined = map;
                this.$project$inlined = project2;
                this.$count$inlined = intRef;
                this.$totalSize$inlined = n;
                this.$locationsToSkip$inlined = set;
                super($project, $title, $cancellable);
            }

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator indicator2 = indicator;
                boolean bl = false;
                List resolvers = MavenExternalAnnotationsConfigurator.access$getResolvers(this.this$0);
                indicator2.setIndeterminate(false);
                Map $this$forEach$iv = this.$toProcess$inlined;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    MavenArtifact mavenArtifact = (MavenArtifact)entry.getKey();
                    Library library = (Library)entry.getValue();
                    if (indicator2.isCanceled()) continue;
                    Object[] objectArray = new Object[]{mavenArtifact.getLibraryName()};
                    indicator2.setText(TasksBundle.message("maven.tasks.external.annotations.looking.for", objectArray));
                    Collection locations = AnnotationsLocationSearcher.Companion.findAnnotationsLocation(this.$project$inlined, library, mavenArtifact.getArtifactId(), mavenArtifact.getGroupId(), mavenArtifact.getVersion());
                    Iterable $this$forEach$iv2 = locations;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        void $this$fold$iv;
                        AnnotationsLocation location = (AnnotationsLocation)element$iv2;
                        boolean bl3 = false;
                        if (this.$locationsToSkip$inlined.contains(location)) continue;
                        Iterable iterable = resolvers;
                        boolean initial$iv = false;
                        boolean $i$f$fold = false;
                        boolean accumulator$iv = initial$iv;
                        for (T element$iv3 : $this$fold$iv) {
                            void res;
                            ExternalAnnotationsArtifactsResolver externalAnnotationsArtifactsResolver = (ExternalAnnotationsArtifactsResolver)element$iv3;
                            boolean acc = accumulator$iv;
                            boolean bl4 = false;
                            accumulator$iv = acc || res.resolve(this.$project$inlined, library, location);
                        }
                        if (accumulator$iv) continue;
                        this.$locationsToSkip$inlined.add(location);
                    }
                    ++this.$count$inlined.element;
                    indicator2.setFraction((double)this.$count$inlined.element / (double)this.$totalSize$inlined);
                }
            }
        });
    }

    private final boolean shouldImportExternalAnnotations(Project project2) {
        MavenProjectsManager $this$shouldImportExternalAnnotations_u24lambda_u247 = MavenProjectsManager.getInstance(project2);
        boolean bl = false;
        return $this$shouldImportExternalAnnotations_u24lambda_u247.getImportingSettings().isDownloadAnnotationsAutomatically() && !$this$shouldImportExternalAnnotations_u24lambda_u247.getGeneralSettings().isWorkOffline();
    }

    public static final /* synthetic */ HashSet access$getMyProcessedLibraries$p(MavenExternalAnnotationsConfigurator $this) {
        return $this.myProcessedLibraries;
    }

    public static final /* synthetic */ List access$getResolvers(MavenExternalAnnotationsConfigurator $this) {
        return $this.getResolvers();
    }

    static {
        Logger logger = Logger.getInstance(MavenExternalAnnotationsConfigurator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(MavenExterna\u2026Configurator::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenExternalAnnotationsConfigurator$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

