/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndexException;
import org.jetbrains.idea.maven.indices.MavenRepositoryProvider;
import org.jetbrains.idea.maven.indices.MavenSearchIndex;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenIndexUtils {
    private static final String CURRENT_VERSION = "5";
    private static final String INDEX_INFO_FILE = "index.properties";
    private static final String INDEX_VERSION_KEY = "version";
    private static final String KIND_KEY = "kind";
    private static final String ID_KEY = "id";
    private static final String PATH_OR_URL_KEY = "pathOrUrl";
    private static final String TIMESTAMP_KEY = "lastUpdate";
    private static final String DATA_DIR_NAME_KEY = "dataDirName";
    private static final String FAILURE_MESSAGE_KEY = "failureMessage";

    private MavenIndexUtils() {
    }

    public static IndexPropertyHolder readIndexProperty(File dir2) throws MavenIndexException {
        Properties props = new Properties();
        try (FileInputStream s = new FileInputStream(new File(dir2, INDEX_INFO_FILE));){
            props.load(s);
        }
        catch (IOException e) {
            throw new MavenIndexException("Cannot read index.properties file", e);
        }
        if (!CURRENT_VERSION.equals(props.getProperty(INDEX_VERSION_KEY))) {
            throw new MavenIndexException("Incompatible index version, needs to be updated: " + dir2);
        }
        MavenSearchIndex.Kind kind = MavenSearchIndex.Kind.valueOf(props.getProperty(KIND_KEY));
        Set<String> repositoryIds = Collections.emptySet();
        String myRepositoryIdsStr = props.getProperty(ID_KEY);
        if (myRepositoryIdsStr != null) {
            repositoryIds = Set.copyOf(StringUtil.split((String)myRepositoryIdsStr, (String)","));
        }
        String repositoryPathOrUrl = MavenIndexUtils.normalizePathOrUrl(props.getProperty(PATH_OR_URL_KEY));
        if (kind != MavenSearchIndex.Kind.LOCAL) {
            repositoryPathOrUrl = repositoryPathOrUrl.toLowerCase(Locale.ROOT);
        }
        long updateTimestamp = -1L;
        try {
            String timestamp = props.getProperty(TIMESTAMP_KEY);
            if (timestamp != null) {
                updateTimestamp = Long.parseLong(timestamp);
            }
        }
        catch (Exception timestamp) {
            // empty catch block
        }
        String dataDirName = props.getProperty(DATA_DIR_NAME_KEY);
        String failureMessage = props.getProperty(FAILURE_MESSAGE_KEY);
        return new IndexPropertyHolder(dir2, kind, repositoryIds, repositoryPathOrUrl, updateTimestamp, dataDirName, failureMessage);
    }

    public static void saveIndexProperty(MavenIndex index) {
        Properties props = new Properties();
        props.setProperty(KIND_KEY, index.getKind().toString());
        props.setProperty(ID_KEY, index.getRepositoryId());
        props.setProperty(PATH_OR_URL_KEY, index.getRepositoryPathOrUrl());
        props.setProperty(INDEX_VERSION_KEY, CURRENT_VERSION);
        props.setProperty(TIMESTAMP_KEY, String.valueOf(index.getUpdateTimestamp()));
        if (index.getDataDirName() != null) {
            props.setProperty(DATA_DIR_NAME_KEY, index.getDataDirName());
        }
        if (index.getFailureMessage() != null) {
            props.setProperty(FAILURE_MESSAGE_KEY, index.getFailureMessage());
        }
        try (FileOutputStream s = new FileOutputStream(new File(index.getDir(), INDEX_INFO_FILE));){
            props.store(s, null);
        }
        catch (IOException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
    }

    @NotNull
    public static Map<String, Set<String>> getRemoteRepositoryIdsByUrl(Project project2) {
        if (project2.isDisposed()) {
            Map<String, Set<String>> map = Collections.emptyMap();
            if (map == null) {
                MavenIndexUtils.$$$reportNull$$$0(0);
            }
            return map;
        }
        Map<String, Set<String>> map = MavenIndexUtils.getRemoteRepositoriesMap(project2);
        if (map == null) {
            MavenIndexUtils.$$$reportNull$$$0(1);
        }
        return map;
    }

    @Nullable
    public static RepositoryInfo getLocalRepository(Project project2) {
        if (project2.isDisposed()) {
            return null;
        }
        File repository = MavenProjectsManager.getInstance(project2).getLocalRepository();
        return repository == null ? null : new RepositoryInfo("local", repository.getPath());
    }

    private static Map<String, Set<String>> getRemoteRepositoriesMap(Project project2) {
        if (project2.isDisposed()) {
            return Collections.emptyMap();
        }
        HashSet<MavenRemoteRepository> remoteRepositories = new HashSet<MavenRemoteRepository>(MavenUtil.getRemoteResolvedRepositories(project2));
        for (MavenRepositoryProvider repositoryProvider : (MavenRepositoryProvider[])MavenRepositoryProvider.EP_NAME.getExtensions()) {
            remoteRepositories.addAll(repositoryProvider.getRemoteRepositories(project2));
        }
        return MavenIndexUtils.groupRemoteRepositoriesByUrl(remoteRepositories);
    }

    @VisibleForTesting
    static Map<String, Set<String>> groupRemoteRepositoriesByUrl(Collection<MavenRemoteRepository> remoteRepositories) {
        return remoteRepositories.stream().map(r -> new RepositoryInfo(r.getId(), r.getUrl().toLowerCase(Locale.ROOT))).collect(Collectors.groupingBy(r -> r.url, Collectors.mapping(r -> r.id, Collectors.toSet())));
    }

    @NotNull
    public static String normalizePathOrUrl(@NotNull String pathOrUrl) {
        if (pathOrUrl == null) {
            MavenIndexUtils.$$$reportNull$$$0(2);
        }
        pathOrUrl = pathOrUrl.trim();
        pathOrUrl = FileUtil.toSystemIndependentName((String)pathOrUrl);
        while (pathOrUrl.endsWith("/")) {
            pathOrUrl = pathOrUrl.substring(0, pathOrUrl.length() - 1);
        }
        String string = pathOrUrl;
        if (string == null) {
            MavenIndexUtils.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/indices/MavenIndexUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = PATH_OR_URL_KEY;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteRepositoryIdsByUrl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndexUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizePathOrUrl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "normalizePathOrUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    static class IndexPropertyHolder {
        final File dir;
        final MavenSearchIndex.Kind kind;
        final Set<String> repositoryIds;
        final String repositoryPathOrUrl;
        final long updateTimestamp;
        final String dataDirName;
        final String failureMessage;

        IndexPropertyHolder(File dir2, MavenSearchIndex.Kind kind, Set<String> repositoryIds, String url, long timestamp, String dataDirName, String message) {
            this.dir = dir2;
            this.kind = kind;
            this.repositoryIds = repositoryIds;
            this.repositoryPathOrUrl = url;
            this.updateTimestamp = timestamp;
            this.dataDirName = dataDirName;
            this.failureMessage = message;
        }

        IndexPropertyHolder(File dir2, MavenSearchIndex.Kind kind, Set<String> repositoryIds, String url) {
            this(dir2, kind, repositoryIds, url, -1L, null, null);
        }
    }

    static class RepositoryInfo {
        @NotNull
        final String id;
        @NotNull
        final String url;

        RepositoryInfo(@NotNull String id, @NotNull String url) {
            if (id == null) {
                RepositoryInfo.$$$reportNull$$$0(0);
            }
            if (url == null) {
                RepositoryInfo.$$$reportNull$$$0(1);
            }
            this.id = id;
            this.url = MavenIndexUtils.normalizePathOrUrl(url);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = MavenIndexUtils.ID_KEY;
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "url";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/indices/MavenIndexUtils$RepositoryInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

