/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.plugins.groovy.wizard;

import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.GitSilentFileAdder;
import com.intellij.openapi.GitSilentFileAdderProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.wizards.AbstractMavenModuleBuilder;
import org.jetbrains.idea.maven.wizards.MavenWizardBundle;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.config.wizard.GroovyProjectWizardUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/maven/plugins/groovy/wizard/MavenGroovyNewProjectBuilder;", "Lorg/jetbrains/idea/maven/wizards/AbstractMavenModuleBuilder;", "()V", "createSampleCode", "", "getCreateSampleCode", "()Z", "setCreateSampleCode", "(Z)V", "groovySdkVersion", "", "getGroovySdkVersion", "()Ljava/lang/String;", "setGroovySdkVersion", "(Ljava/lang/String;)V", "setupMavenStructure", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "setupRootModel", "rootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenGroovyNewProjectBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenGroovyNewProjectBuilder.kt\norg/jetbrains/idea/maven/plugins/groovy/wizard/MavenGroovyNewProjectBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class MavenGroovyNewProjectBuilder
extends AbstractMavenModuleBuilder {
    private boolean createSampleCode;
    @NotNull
    private String groovySdkVersion = "3.0.9";

    public final boolean getCreateSampleCode() {
        return this.createSampleCode;
    }

    public final void setCreateSampleCode(boolean bl) {
        this.createSampleCode = bl;
    }

    @NotNull
    public final String getGroovySdkVersion() {
        return this.groovySdkVersion;
    }

    public final void setGroovySdkVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.groovySdkVersion = string;
    }

    @Override
    public void setupRootModel(@NotNull ModifiableRootModel rootModel) {
        String string;
        Intrinsics.checkNotNullParameter((Object)rootModel, (String)"rootModel");
        Project project2 = rootModel.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"rootModel.project");
        Project project3 = project2;
        String string2 = this.getContentEntryPath();
        if (string2 == null) {
            return;
        }
        String contentPath = string2;
        String it = string = FileUtil.toSystemIndependentName((String)contentPath);
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        Path path = Paths.get(it, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(path)");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(this, *attributes)");
        String string3 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toSystemIndependentName(\u2026it).createDirectories() }");
        String path2 = string3;
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path2);
        if (virtualFile == null) {
            return;
        }
        VirtualFile root = virtualFile;
        rootModel.addContentEntry(root);
        if (this.myJdk != null) {
            rootModel.setSdk(this.myJdk);
        } else {
            rootModel.inheritSdk();
        }
        MavenUtil.runWhenInitialized(project3, (Runnable)((DumbAwareRunnable)() -> MavenGroovyNewProjectBuilder.setupRootModel$lambda$1(this, project3, root)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setupMavenStructure(Project project2, VirtualFile root) {
        GitSilentFileAdder gitSilentFileAdder = GitSilentFileAdderProvider.create((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)gitSilentFileAdder, (String)"create(project)");
        GitSilentFileAdder vcsFileAdder = gitSilentFileAdder;
        try {
            root.refresh(true, false, () -> MavenGroovyNewProjectBuilder.setupMavenStructure$lambda$4(project2, root, this, vcsFileAdder));
        }
        finally {
            vcsFileAdder.finish();
        }
    }

    private static final void setupRootModel$lambda$1(MavenGroovyNewProjectBuilder this$0, Project $project, VirtualFile $root) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
        this$0.setupMavenStructure($project, $root);
    }

    private static final VirtualFile setupMavenStructure$lambda$4$lambda$2(VirtualFile $root, MavenGroovyNewProjectBuilder this$0, GitSilentFileAdder $vcsFileAdder, Project $project) {
        Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$vcsFileAdder, (String)"$vcsFileAdder");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        $root.refresh(true, false);
        VirtualFile virtualFile = $root.findChild("pom.xml");
        if (virtualFile != null) {
            virtualFile.delete((Object)this$0);
        }
        VirtualFile virtualFile2 = $root.createChildData((Object)this$0, "pom.xml");
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"root.createChildData(this, MavenConstants.POM_XML)");
        VirtualFile file = virtualFile2;
        $vcsFileAdder.markFileForAdding(file);
        Properties properties = new Properties();
        Properties conditions = new Properties();
        properties.setProperty("GROOVY_VERSION", this$0.groovySdkVersion);
        properties.setProperty("GROOVY_REPOSITORY", GroovyConfigUtils.getMavenSdkRepository((String)this$0.groovySdkVersion));
        conditions.setProperty("NEED_POM", String.valueOf(GroovyConfigUtils.compareSdkVersions((String)this$0.groovySdkVersion, (String)"2.5") >= 0));
        conditions.setProperty("CREATE_SAMPLE_CODE", "true");
        MavenUtil.runOrApplyMavenProjectFileTemplate($project, file, this$0.getProjectId(), null, null, properties, conditions, "Maven Groovy.xml", false);
        return file;
    }

    private static final void setupMavenStructure$lambda$4$lambda$3(Project $project, VirtualFile $pom) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            PsiFile psiFile = PsiManager.getInstance((Project)$project).findFile($pom);
            if (psiFile == null) break block0;
            PsiElement p0 = (PsiElement)psiFile;
            boolean bl = false;
            EditorHelper.openInEditor((PsiElement)p0);
        }
    }

    private static final void setupMavenStructure$lambda$4(Project $project, VirtualFile $root, MavenGroovyNewProjectBuilder this$0, GitSilentFileAdder $vcsFileAdder) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$vcsFileAdder, (String)"$vcsFileAdder");
        VirtualFile pom = (VirtualFile)WriteCommandAction.writeCommandAction((Project)$project).withName(MavenWizardBundle.message("maven.new.project.wizard.groovy.creating.groovy.project", new Object[0])).compute(() -> MavenGroovyNewProjectBuilder.setupMavenStructure$lambda$4$lambda$2($root, this$0, $vcsFileAdder, $project));
        VirtualFile sourceDirectory = VfsUtil.createDirectories((String)($root.getPath() + "/src/main/groovy"));
        VfsUtil.createDirectories((String)($root.getPath() + "/src/main/resources"));
        VfsUtil.createDirectories((String)($root.getPath() + "/src/test/groovy"));
        if (this$0.createSampleCode) {
            $vcsFileAdder.markFileForAdding(sourceDirectory);
            ModuleBuilder moduleBuilder = this$0;
            Intrinsics.checkNotNullExpressionValue((Object)sourceDirectory, (String)"sourceDirectory");
            GroovyProjectWizardUtils.createSampleGroovyCodeFile((ModuleBuilder)moduleBuilder, (Project)$project, (VirtualFile)sourceDirectory);
        }
        MavenProjectsManager.getInstance($project).forceUpdateAllProjectsOrFindAllAvailablePomFiles();
        MavenUtil.invokeLater($project, ModalityState.nonModal(), () -> MavenGroovyNewProjectBuilder.setupMavenStructure$lambda$4$lambda$3($project, pom));
    }
}

