/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.buildtool.ArtifactSyncListener;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectWithHolder;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicator;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.PluginResolutionResponse;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J4\u0010\f\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/idea/maven/project/MavenPluginResolver;", "", "myTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "(Lorg/jetbrains/idea/maven/project/MavenProjectsTree;)V", "myProject", "Lcom/intellij/openapi/project/Project;", "reportUnresolvedPlugins", "", "unresolvedPluginIds", "", "Lorg/jetbrains/idea/maven/model/MavenId;", "resolvePlugins", "mavenProjectsToResolvePlugins", "", "Lorg/jetbrains/idea/maven/project/MavenProjectWithHolder;", "embeddersManager", "Lorg/jetbrains/idea/maven/project/MavenEmbeddersManager;", "console", "Lorg/jetbrains/idea/maven/project/MavenConsole;", "process", "Lorg/jetbrains/idea/maven/utils/MavenProgressIndicator;", "reportUnresolvedToSyncConsole", "", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenPluginResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenPluginResolver.kt\norg/jetbrains/idea/maven/project/MavenPluginResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n766#2:112\n857#2,2:113\n1360#2:115\n1446#2,5:116\n766#2:121\n857#2,2:122\n1549#2:124\n1620#2,3:125\n1549#2:128\n1620#2,3:129\n*S KotlinDebug\n*F\n+ 1 MavenPluginResolver.kt\norg/jetbrains/idea/maven/project/MavenPluginResolver\n*L\n25#1:112\n25#1:113,2\n41#1:115\n41#1:116,5\n49#1:121\n49#1:122,2\n49#1:124\n49#1:125,3\n53#1:128\n53#1:129,3\n*E\n"})
public final class MavenPluginResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MavenProjectsTree myTree;
    @NotNull
    private final Project myProject;

    public MavenPluginResolver(@NotNull MavenProjectsTree myTree) {
        Intrinsics.checkNotNullParameter((Object)myTree, (String)"myTree");
        this.myTree = myTree;
        Project project2 = this.myTree.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myTree.project");
        this.myProject = project2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void resolvePlugins(@NotNull Collection<MavenProjectWithHolder> mavenProjectsToResolvePlugins, @NotNull MavenEmbeddersManager embeddersManager, @NotNull MavenConsole console2, @NotNull MavenProgressIndicator process, boolean reportUnresolvedToSyncConsole) throws MavenProcessCanceledException {
        Object[] $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(mavenProjectsToResolvePlugins, (String)"mavenProjectsToResolvePlugins");
        Intrinsics.checkNotNullParameter((Object)embeddersManager, (String)"embeddersManager");
        Intrinsics.checkNotNullParameter((Object)console2, (String)"console");
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Iterable $this$filter$iv = mavenProjectsToResolvePlugins;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            MavenProjectWithHolder it = (MavenProjectWithHolder)t;
            boolean bl = false;
            boolean bl2 = !it.mavenProject().hasReadingProblems() && it.mavenProject().hasUnresolvedPlugins();
            if (!bl2) continue;
            destination$iv$iv.add(t);
        }
        List mavenProjects2 = (List)destination$iv$iv;
        if (mavenProjects2.isEmpty()) {
            return;
        }
        MavenProject mavenProject2 = MavenPluginResolver.Companion.sortAndGetFirst(mavenProjects2).mavenProject();
        Intrinsics.checkNotNullExpressionValue((Object)mavenProject2, (String)"sortAndGetFirst(mavenProjects).mavenProject");
        MavenProject firstProject = mavenProject2;
        String baseDir = ((Object)MavenUtil.getBaseDir(firstProject.getDirectoryFile())).toString();
        $this$filterTo$iv$iv = new Object[]{firstProject.getDisplayName()};
        process.setText(MavenProjectBundle.message("maven.downloading.pom.plugins", $this$filterTo$iv$iv));
        MavenEmbedderWrapper mavenEmbedderWrapper = embeddersManager.getEmbedder(MavenEmbeddersManager.FOR_PLUGINS_RESOLVE, baseDir);
        Intrinsics.checkNotNullExpressionValue((Object)mavenEmbedderWrapper, (String)"embeddersManager.getEmbe\u2026PLUGINS_RESOLVE, baseDir)");
        MavenEmbedderWrapper embedder = mavenEmbedderWrapper;
        Set unresolvedPluginIds = null;
        Set filesToRefresh = new HashSet();
        try {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            void $this$filterTo$iv$iv2;
            Iterable pluginJar;
            boolean bl;
            PluginResolutionResponse it;
            void $this$flatMapTo$iv$iv;
            Collection mavenPluginIdsToResolve = MavenPluginResolver.Companion.collectMavenPluginIdsToResolve(mavenProjects2);
            List<PluginResolutionResponse> list = embedder.resolvePlugins(mavenPluginIdsToResolve, process, console2);
            Intrinsics.checkNotNullExpressionValue(list, (String)"resolutionResults");
            Iterable $this$flatMap$iv = list;
            boolean $i$f$flatMap = false;
            Iterable iterable2 = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (PluginResolutionResponse)element$iv$iv;
                bl = false;
                List list2 = it.getArtifacts();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"it.artifacts");
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List artifacts = (List)destination$iv$iv2;
            for (MavenArtifact artifact : artifacts) {
                pluginJar = artifact.getFile().toPath();
                Path pluginDir = pluginJar.getParent();
                if (pluginDir == null) continue;
                filesToRefresh.add(pluginDir);
            }
            Iterable $this$filter$iv2 = list;
            boolean $i$f$filter2 = false;
            pluginJar = $this$filter$iv2;
            Iterable destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (PluginResolutionResponse)element$iv$iv;
                bl = false;
                if (!(!it.isResolved())) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv3;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (PluginResolutionResponse)item$iv$iv;
                collection = destination$iv$iv3;
                bl = false;
                collection.add(it.getMavenPluginId());
            }
            unresolvedPluginIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
            if (reportUnresolvedToSyncConsole) {
                this.reportUnresolvedPlugins(unresolvedPluginIds);
            }
            Iterable $this$map$iv2 = mavenProjects2;
            boolean $i$f$map2 = false;
            destination$iv$iv3 = $this$map$iv2;
            Collection destination$iv$iv32 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                MavenProjectWithHolder bl3 = (MavenProjectWithHolder)item$iv$iv;
                collection = destination$iv$iv32;
                boolean bl32 = false;
                collection.add(it2.mavenProject());
            }
            Set updatedMavenProjects = CollectionsKt.toSet((Iterable)((List)destination$iv$iv32));
            for (MavenProject mavenProject3 : updatedMavenProjects) {
                mavenProject3.resetCache();
                this.myTree.firePluginsResolved(mavenProject3);
            }
        }
        finally {
            if (filesToRefresh.size() > 0) {
                LocalFileSystem.getInstance().refreshNioFiles((Iterable)filesToRefresh);
            }
            embeddersManager.release(embedder);
        }
    }

    private final void reportUnresolvedPlugins(Set<? extends MavenId> unresolvedPluginIds) {
        if (!unresolvedPluginIds.isEmpty()) {
            for (MavenId mavenId : unresolvedPluginIds) {
                ArtifactSyncListener artifactSyncListener = MavenProjectsManager.getInstance(this.myProject).getSyncConsole().getListener(MavenServerConsoleIndicator.ResolveType.PLUGIN);
                String string = mavenId.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mavenPluginId.key");
                artifactSyncListener.showArtifactBuildIssue(string, null);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004H\u0002J\u0016\u0010\n\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/maven/project/MavenPluginResolver$Companion;", "", "()V", "collectMavenPluginIdsToResolve", "", "Lcom/intellij/openapi/util/Pair;", "Lorg/jetbrains/idea/maven/model/MavenId;", "Lorg/jetbrains/idea/maven/server/NativeMavenProjectHolder;", "mavenProjects", "Lorg/jetbrains/idea/maven/project/MavenProjectWithHolder;", "sortAndGetFirst", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nMavenPluginResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenPluginResolver.kt\norg/jetbrains/idea/maven/project/MavenPluginResolver$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n2310#2,14:112\n*S KotlinDebug\n*F\n+ 1 MavenPluginResolver.kt\norg/jetbrains/idea/maven/project/MavenPluginResolver$Companion\n*L\n107#1:112,14\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Collection<Pair<MavenId, NativeMavenProjectHolder>> collectMavenPluginIdsToResolve(Collection<MavenProjectWithHolder> mavenProjects2) {
            HashSet<Pair> mavenPluginIdsToResolve = new HashSet<Pair>();
            if (Registry.is((String)"maven.plugins.use.cache")) {
                HashMap pluginIdsToProjects = new HashMap();
                for (MavenProjectWithHolder mavenProjectWithHolder : mavenProjects2) {
                    MavenProject mavenProject2;
                    Intrinsics.checkNotNullExpressionValue((Object)mavenProjectWithHolder.mavenProject(), (String)"projectData.mavenProject");
                    for (MavenPlugin mavenPlugin : mavenProject2.getDeclaredPlugins()) {
                        MavenId mavenPluginId = mavenPlugin.getMavenId();
                        pluginIdsToProjects.putIfAbsent(mavenPluginId, new ArrayList());
                        Object v = pluginIdsToProjects.get(mavenPluginId);
                        Intrinsics.checkNotNull(v);
                        ((List)v).add(mavenProjectWithHolder);
                    }
                }
                for (Map.Entry entry : ((Map)pluginIdsToProjects).entrySet()) {
                    MavenId key = (MavenId)entry.getKey();
                    List value = (List)entry.getValue();
                    mavenPluginIdsToResolve.add(Pair.create((Object)key, (Object)this.sortAndGetFirst(value).mavenProjectHolder()));
                }
            } else {
                for (MavenProjectWithHolder projectData : mavenProjects2) {
                    MavenProject mavenProject2;
                    Intrinsics.checkNotNullExpressionValue((Object)projectData.mavenProject(), (String)"projectData.mavenProject");
                    Intrinsics.checkNotNullExpressionValue((Object)projectData.mavenProjectHolder(), (String)"projectData.mavenProjectHolder");
                    for (MavenPlugin mavenPlugin : mavenProject2.getDeclaredPlugins()) {
                        NativeMavenProjectHolder nativeMavenProject;
                        mavenPluginIdsToResolve.add(Pair.create((Object)mavenPlugin.getMavenId(), (Object)nativeMavenProject));
                    }
                }
            }
            return mavenPluginIdsToResolve;
        }

        private final MavenProjectWithHolder sortAndGetFirst(Collection<MavenProjectWithHolder> mavenProjects2) {
            Object t;
            Iterable $this$minBy$iv = mavenProjects2;
            boolean $i$f$minByOrThrow = false;
            Iterator iterator$iv = $this$minBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = minElem$iv;
            } else {
                MavenProjectWithHolder it = (MavenProjectWithHolder)minElem$iv;
                boolean bl = false;
                String string = it.mavenProject().getDirectoryFile().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.mavenProject.directoryFile.path");
                Comparable minValue$iv = (Comparable)((Object)string);
                do {
                    Object e$iv = iterator$iv.next();
                    MavenProjectWithHolder it2 = (MavenProjectWithHolder)e$iv;
                    $i$a$-minByOrThrow-MavenPluginResolver$Companion$sortAndGetFirst$1 = false;
                    String string2 = it2.mavenProject().getDirectoryFile().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.mavenProject.directoryFile.path");
                    Comparable v$iv = (Comparable)((Object)string2);
                    if (minValue$iv.compareTo(v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = minElem$iv;
            }
            return (MavenProjectWithHolder)t;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

