/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.build.events.MessageEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.MavenConfigBuildIssue;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectReader;
import org.jetbrains.idea.maven.project.MavenProjectReaderResult;
import org.jetbrains.idea.maven.project.MavenProjectResolver;
import org.jetbrains.idea.maven.project.MavenProjectWithHolder;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenResolveResultProblemProcessor;
import org.jetbrains.idea.maven.server.MavenConfigParseException;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.ParallelRunner;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenUtil;

class MavenProjectResolverImpl
implements MavenProjectResolver {
    @NotNull
    private final Project myProject;

    MavenProjectResolverImpl(@NotNull Project project2) {
        if (project2 == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MavenProjectResolver.MavenProjectResolutionResult resolve(@NotNull Collection<MavenProject> mavenProjects2, @NotNull MavenProjectsTree tree, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenEmbeddersManager embeddersManager, @NotNull MavenConsole console2, @NotNull ProgressIndicator process, @Nullable MavenSyncConsole syncConsole) throws MavenProcessCanceledException {
        if (mavenProjects2 == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(1);
        }
        if (tree == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(2);
        }
        if (generalSettings == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(3);
        }
        if (embeddersManager == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(4);
        }
        if (console2 == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(5);
        }
        if (process == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(6);
        }
        boolean updateSnapshots = MavenProjectsManager.getInstance(this.myProject).getForceUpdateSnapshots() || generalSettings.isAlwaysUpdateSnapshots();
        HashMap<String, Collection<MavenProjectWithHolder>> projectsWithUnresolvedPlugins = new HashMap<String, Collection<MavenProjectWithHolder>>();
        MultiMap<String, MavenProject> projectMultiMap = MavenUtil.groupByBasedir(mavenProjects2, tree);
        for (Map.Entry entry : projectMultiMap.entrySet()) {
            String baseDir = (String)entry.getKey();
            Collection mavenProjectsInBaseDir = (Collection)entry.getValue();
            MavenEmbedderWrapper embedder = embeddersManager.getEmbedder(MavenEmbeddersManager.FOR_DEPENDENCIES_RESOLVE, baseDir);
            try {
                for (MavenProject mavenProject2 : mavenProjectsInBaseDir) {
                    mavenProject2.setConfigFileError(null);
                }
                Collection<MavenProjectWithHolder> projectsWithUnresolvedPluginsChunk = this.doResolve(mavenProjectsInBaseDir, tree, generalSettings, embedder, process, syncConsole, console2, tree.getWorkspaceMap(), updateSnapshots);
                projectsWithUnresolvedPlugins.put(baseDir, projectsWithUnresolvedPluginsChunk);
            }
            catch (Throwable t) {
                MavenConfigParseException cause = MavenProjectResolverImpl.findParseException(t);
                if (cause != null) {
                    BuildIssue buildIssue = MavenConfigBuildIssue.INSTANCE.getIssue(cause);
                    if (buildIssue != null) {
                        MavenProjectsManager.getInstance(this.myProject).getSyncConsole().addBuildIssue(buildIssue, MessageEvent.Kind.ERROR);
                        continue;
                    }
                    throw t;
                }
                MavenLog.LOG.warn("Error in maven config parsing", t);
                throw t;
            }
            finally {
                embeddersManager.release(embedder);
            }
        }
        MavenUtil.restartConfigHighlighting(mavenProjects2);
        return new MavenProjectResolver.MavenProjectResolutionResult(projectsWithUnresolvedPlugins);
    }

    private static MavenConfigParseException findParseException(Throwable t) {
        Throwable target;
        MavenConfigParseException parseException = (MavenConfigParseException)ExceptionUtil.findCause((Throwable)t, MavenConfigParseException.class);
        if (parseException != null) {
            return parseException;
        }
        Throwable cause = ExceptionUtil.getRootCause((Throwable)t);
        if (cause instanceof InvocationTargetException && (target = ((InvocationTargetException)cause).getTargetException()) != null) {
            return (MavenConfigParseException)ExceptionUtil.findCause((Throwable)target, MavenConfigParseException.class);
        }
        return null;
    }

    private Collection<MavenProjectWithHolder> doResolve(@NotNull Collection<MavenProject> mavenProjects2, @NotNull MavenProjectsTree tree, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenEmbedderWrapper embedder, @NotNull ProgressIndicator process, @Nullable MavenSyncConsole syncConsole, @NotNull MavenConsole console2, @Nullable MavenWorkspaceMap workspaceMap, boolean updateSnapshots) throws MavenProcessCanceledException {
        if (mavenProjects2 == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(7);
        }
        if (tree == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(8);
        }
        if (generalSettings == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(9);
        }
        if (embedder == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(10);
        }
        if (process == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(11);
        }
        if (console2 == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(12);
        }
        if (mavenProjects2.isEmpty()) {
            return List.of();
        }
        process.checkCanceled();
        List names = ContainerUtil.mapNotNull(mavenProjects2, p -> p.getDisplayName());
        String text = StringUtil.shortenPathWithEllipsis((String)StringUtil.join((Collection)names, (String)", "), (int)200);
        process.setText(MavenProjectBundle.message("maven.resolving.pom", text));
        process.setText2("");
        MavenExplicitProfiles explicitProfiles = tree.getExplicitProfiles();
        List files2 = ContainerUtil.map(mavenProjects2, p -> p.getFile());
        Collection<MavenProjectReaderResult> results = new MavenProjectReader(this.myProject).resolveProject(generalSettings, embedder, files2, explicitProfiles, tree.getProjectLocator(), process, syncConsole, console2, workspaceMap, updateSnapshots);
        MavenResolveResultProblemProcessor.MavenResolveProblemHolder problems = MavenResolveResultProblemProcessor.getProblems(results);
        MavenResolveResultProblemProcessor.notifySyncForProblem(this.myProject, problems);
        Map<String, List<MavenProject>> artifactIdToMavenProjects = mavenProjects2.stream().filter(mavenProject2 -> null != mavenProject2.getMavenId().getArtifactId()).collect(Collectors.groupingBy(mavenProject2 -> mavenProject2.getMavenId().getArtifactId()));
        ConcurrentLinkedQueue<MavenProjectWithHolder> projectsWithUnresolvedPlugins = new ConcurrentLinkedQueue<MavenProjectWithHolder>();
        ParallelRunner.runInParallelRethrow(results, result2 -> this.doResolve((MavenProjectReaderResult)result2, artifactIdToMavenProjects, generalSettings, embedder, tree, projectsWithUnresolvedPlugins));
        return projectsWithUnresolvedPlugins;
    }

    private void doResolve(@NotNull MavenProjectReaderResult result2, @NotNull Map<String, List<MavenProject>> artifactIdToMavenProjects, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenEmbedderWrapper embedder, @NotNull MavenProjectsTree tree, @NotNull ConcurrentLinkedQueue<MavenProjectWithHolder> projectsWithUnresolvedPlugins) throws MavenProcessCanceledException {
        MavenId mavenId;
        String artifactId;
        List<MavenProject> mavenProjects2;
        if (result2 == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(13);
        }
        if (artifactIdToMavenProjects == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(14);
        }
        if (generalSettings == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(15);
        }
        if (embedder == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(16);
        }
        if (tree == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(17);
        }
        if (projectsWithUnresolvedPlugins == null) {
            MavenProjectResolverImpl.$$$reportNull$$$0(18);
        }
        if (null == (mavenProjects2 = artifactIdToMavenProjects.get(artifactId = (mavenId = result2.mavenModel.getMavenId()).getArtifactId()))) {
            return;
        }
        MavenProject mavenProjectCandidate = null;
        for (MavenProject mavenProject2 : mavenProjects2) {
            if (mavenProject2.getMavenId().equals((Object)mavenId)) {
                mavenProjectCandidate = mavenProject2;
                break;
            }
            if (!mavenProject2.getMavenId().equals(mavenId.getGroupId(), mavenId.getArtifactId())) continue;
            mavenProjectCandidate = mavenProject2;
        }
        if (mavenProjectCandidate == null) {
            return;
        }
        MavenProject.Snapshot snapshot = mavenProjectCandidate.getSnapshot();
        boolean resetArtifacts = MavenUtil.shouldResetDependenciesAndFolders(result2.readingProblems);
        mavenProjectCandidate.set(result2, generalSettings, false, resetArtifacts, false);
        NativeMavenProjectHolder nativeMavenProject = result2.nativeMavenProject;
        if (nativeMavenProject != null) {
            for (MavenImporter eachImporter : MavenImporter.getSuitableImporters(mavenProjectCandidate)) {
                eachImporter.resolve(this.myProject, mavenProjectCandidate, nativeMavenProject, embedder);
            }
        }
        MavenProjectChanges changes = mavenProjectCandidate.getChangesSinceSnapshot(snapshot);
        mavenProjectCandidate.getProblems();
        tree.fireProjectResolved((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)mavenProjectCandidate, (Object)changes), nativeMavenProject);
        if (!mavenProjectCandidate.hasReadingProblems()) {
            if (null != nativeMavenProject) {
                projectsWithUnresolvedPlugins.add(new MavenProjectWithHolder(mavenProjectCandidate, nativeMavenProject, changes));
            } else {
                MavenLog.LOG.error("Native maven project is null for " + mavenProjectCandidate);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProjects";
                break;
            }
            case 2: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generalSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embeddersManager";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embedder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactIdToMavenProjects";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsWithUnresolvedPlugins";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectResolverImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "resolve";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "doResolve";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

