/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectSettings;
import org.jetbrains.idea.maven.project.MavenTestRunningSettings;

public class MavenTestRunningConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel myMainPanel;
    private JBCheckBox myPassArgLineCB;
    private JBCheckBox myPassSystemPropertiesCB;
    private JBCheckBox myPassEnvironmentVariablesCB;
    private final Project myProject;

    public MavenTestRunningConfigurable(Project project2) {
        this.myProject = project2;
        this.$$$setupUI$$$();
    }

    @Nls
    public String getDisplayName() {
        return MavenProjectBundle.message("maven.testRunning", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.project.maven.testRunning";
    }

    private void getSettingsFromUI(MavenTestRunningSettings settings) {
        settings.setPassArgLine(this.myPassArgLineCB.isSelected());
        settings.setPassSystemProperties(this.myPassSystemPropertiesCB.isSelected());
        settings.setPassEnvironmentVariables(this.myPassEnvironmentVariablesCB.isSelected());
    }

    public void apply() throws ConfigurationException {
        this.getSettingsFromUI(MavenProjectSettings.getInstance(this.myProject).getTestRunningSettings());
    }

    public void reset() {
        MavenTestRunningSettings settings = MavenProjectSettings.getInstance(this.myProject).getTestRunningSettings();
        this.myPassArgLineCB.setSelected(settings.isPassArgLine());
        this.myPassSystemPropertiesCB.setSelected(settings.isPassSystemProperties());
        this.myPassEnvironmentVariablesCB.setSelected(settings.isPassEnvironmentVariables());
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        MavenTestRunningSettings uiSettings = new MavenTestRunningSettings();
        this.getSettingsFromUI(uiSettings);
        MavenTestRunningSettings projectSettings = MavenProjectSettings.getInstance(this.myProject).getTestRunningSettings();
        return !projectSettings.equals(uiSettings);
    }

    @NotNull
    public String getId() {
        return "reference.settings.project.maven.testRunning";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPassArgLineCB = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenTestRunningConfigurable.class).getString("maven.settings.testrun.argline"));
        jPanel.add((Component)jBCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 4, 1, 1, 0, 2, 1, 6, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenTestRunningConfigurable.class).getString("maven.settings.testrun.caption"));
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 5, 8, 0, 3, 0, null, null, null));
        this.myPassSystemPropertiesCB = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenTestRunningConfigurable.class).getString("maven.settings.testrun.system.property"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 5, 8, 0, 0, 0, null, null, null));
        this.myPassEnvironmentVariablesCB = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenTestRunningConfigurable.class).getString("maven.settings.testrun.env.variables"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 5, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

