/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.google.common.base.Charsets;
import com.intellij.diagnostic.PluginException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.PathUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenIndexerCMDState
extends CommandLineState {
    private static final String dependenciesOutput = "[INFO] +- org.apache.maven:maven-core:jar:3.8.3:compile\n[INFO] |  +- org.apache.maven:maven-settings:jar:3.8.3:compile\n[INFO] |  +- org.apache.maven:maven-settings-builder:jar:3.8.3:compile\n[INFO] |  |  \\- org.codehaus.plexus:plexus-sec-dispatcher:jar:2.0:compile\n[INFO] |  |     \\- org.codehaus.plexus:plexus-cipher:jar:2.0:compile\n[INFO] |  +- org.apache.maven:maven-builder-support:jar:3.8.3:compile\n[INFO] |  +- org.apache.maven:maven-repository-metadata:jar:3.8.3:compile\n[INFO] |  +- org.apache.maven:maven-artifact:jar:3.8.3:compile\n[INFO] |  +- org.apache.maven:maven-plugin-api:jar:3.8.3:compile\n[INFO] |  +- org.apache.maven:maven-model-builder:jar:3.8.3:compile\n[INFO] |  +- org.apache.maven:maven-resolver-provider:jar:3.8.3:compile\n[INFO] |  +- org.apache.maven.resolver:maven-resolver-impl:jar:1.6.3:compile\n[INFO] |  +- org.apache.maven.resolver:maven-resolver-spi:jar:1.6.3:compile\n[INFO] |  +- org.apache.maven.shared:maven-shared-utils:jar:3.3.4:compile\n[INFO] |  +- org.eclipse.sisu:org.eclipse.sisu.plexus:jar:0.3.5:compile\n[INFO] |  |  \\- javax.annotation:javax.annotation-api:jar:1.2:compile\n[INFO] |  +- org.eclipse.sisu:org.eclipse.sisu.inject:jar:0.3.5:compile\n[INFO] |  +- com.google.inject:guice:jar:no_aop:4.2.2:compile\n[INFO] |  |  +- aopalliance:aopalliance:jar:1.0:compile\n[INFO] |  |  \\- com.google.guava:guava:jar:25.1-android:compile\n[INFO] |  |     +- com.google.code.findbugs:jsr305:jar:3.0.2:compile\n[INFO] |  |     +- org.checkerframework:checker-compat-qual:jar:2.0.0:compile\n[INFO] |  |     +- com.google.errorprone:error_prone_annotations:jar:2.1.3:compile\n[INFO] |  |     +- com.google.j2objc:j2objc-annotations:jar:1.1:compile\n[INFO] |  |     \\- org.codehaus.mojo:animal-sniffer-annotations:jar:1.14:compile\n[INFO] |  +- org.codehaus.plexus:plexus-utils:jar:3.3.0:compile\n[INFO] |  +- org.codehaus.plexus:plexus-classworlds:jar:2.6.0:compile\n[INFO] |  +- org.codehaus.plexus:plexus-interpolation:jar:1.26:compile\n[INFO] |  +- org.codehaus.plexus:plexus-component-annotations:jar:2.1.0:compile\n[INFO] |  \\- org.apache.commons:commons-lang3:jar:3.8.1:compile\n[INFO] +- org.apache.maven.wagon:wagon-provider-api:jar:3.5.2:compile\n[INFO] \\- org.apache.maven.archetype:archetype-common:jar:3.2.1:compile\n[INFO]    +- org.apache.maven.archetype:archetype-catalog:jar:3.2.1:compile\n[INFO]    +- org.apache.maven.archetype:archetype-descriptor:jar:3.2.1:compile\n[INFO]    +- org.codehaus.groovy:groovy-all:jar:2.4.16:compile\n[INFO]    +- org.apache.ivy:ivy:jar:2.5.0:runtime\n[INFO]    +- org.jdom:jdom2:jar:2.0.6:compile\n[INFO]    +- org.apache.maven.shared:maven-invoker:jar:3.0.1:compile\n[INFO]    +- org.apache.maven:maven-aether-provider:jar:3.0:runtime\n[INFO]    |  +- org.sonatype.aether:aether-api:jar:1.7:runtime\n[INFO]    |  +- org.sonatype.aether:aether-util:jar:1.7:runtime\n[INFO]    |  \\- org.sonatype.aether:aether-impl:jar:1.7:runtime\n[INFO]    |     \\- org.sonatype.aether:aether-spi:jar:1.7:runtime\n[INFO]    +- org.apache.maven.shared:maven-artifact-transfer:jar:0.13.1:compile\n[INFO]    |  \\- org.apache.maven.shared:maven-common-artifact-filters:jar:3.1.0:compile\n[INFO]    |     \\- org.sonatype.sisu:sisu-inject-plexus:jar:1.4.2:compile\n[INFO]    |        \\- org.sonatype.sisu:sisu-inject-bean:jar:1.4.2:compile\n[INFO]    |           \\- org.sonatype.sisu:sisu-guice:jar:noaop:2.1.7:compile\n[INFO]    +- commons-io:commons-io:jar:2.6:compile\n[INFO]    +- commons-collections:commons-collections:jar:3.2.2:compile\n[INFO]    +- org.codehaus.plexus:plexus-velocity:jar:1.2:compile\n[INFO]    +- org.apache.velocity:velocity:jar:1.7:compile\n[INFO]    |  \\- commons-lang:commons-lang:jar:2.4:compile\n[INFO]    \\- com.ibm.icu:icu4j:jar:70.1:compile\n";
    private final Sdk myJdk;
    private final String myOptions;
    private final MavenDistribution myDistribution;
    private final Integer myDebugPort;

    public MavenIndexerCMDState(Sdk jdk2, String vmOptions, MavenDistribution distribution, Integer debugPort) {
        super(null);
        this.myJdk = jdk2;
        this.myOptions = vmOptions;
        this.myDistribution = distribution;
        this.myDebugPort = debugPort;
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        SimpleJavaParameters params = this.createJavaParameters();
        GeneralCommandLine commandLine = params.toCommandLine();
        OSProcessHandler.Silent processHandler = new OSProcessHandler.Silent(commandLine);
        processHandler.setShouldDestroyProcessRecursively(false);
        OSProcessHandler.Silent silent = processHandler;
        if (silent == null) {
            MavenIndexerCMDState.$$$reportNull$$$0(0);
        }
        return silent;
    }

    protected SimpleJavaParameters createJavaParameters() {
        SimpleJavaParameters params = new SimpleJavaParameters();
        params.setJdk(this.myJdk);
        params.setWorkingDirectory(PathManager.getBinPath());
        params.getVMParametersList().add(Registry.stringValue((String)"maven.dedicated.indexer.vmargs"));
        if (this.myDebugPort != null) {
            params.getVMParametersList().addParametersString("-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=*:" + this.myDebugPort);
        }
        params.getVMParametersList().add("-Didea.version=" + MavenUtil.getIdeaVersionToPassToMavenProcess());
        params.setMainClass("org.jetbrains.idea.maven.server.indexer.MavenServerIndexerMain");
        params.getClassPath().add(PathUtil.getJarPathForClass(StringUtilRt.class));
        params.getClassPath().add(PathUtil.getJarPathForClass(NotNull.class));
        params.getClassPath().add(PathUtil.getJarPathForClass(Element.class));
        params.getClassPath().addAllFiles(MavenIndexerCMDState.collectClassPathAndLibsFolder(this.myDistribution));
        return params;
    }

    private static void addDependenciesFromMavenRepo(List<File> classPath) {
        String[] dependencies = dependenciesOutput.split("\\n");
        Pattern format = Pattern.compile("^\\[INFO\\].*-\\s(?<groupId>[0-9a-z._\\-]+):(?<artifactId>[0-9a-z._\\-]+):jar:?(?<classifier>[a-z_]*):(?<version>[0-9a-z._\\-]+):(?<scope>(compile|runtime))$");
        PathMacros pathMacros = PathMacros.getInstance();
        String path = pathMacros.getValue("MAVEN_REPOSITORY");
        File mavenRepository = path == null ? new File(new File(PathManager.getHomePath(), ".m2"), "repository") : new File(path);
        for (String dep : dependencies) {
            Matcher matcher = format.matcher(dep);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(dep);
            }
            @NotNull String groupId = matcher.group("groupId");
            @NotNull String artifactId = matcher.group("artifactId");
            @Nullable String classifier = StringUtils.trimToNull((String)matcher.group("classifier"));
            @NotNull String version2 = matcher.group("version");
            MavenId mavenId = new MavenId(groupId, artifactId, version2);
            File jar = MavenUtil.makeLocalRepositoryFile(mavenId, mavenRepository, "jar", classifier);
            if (!jar.isFile()) {
                throw new IllegalStateException("File " + jar.getPath() + " not found");
            }
            classPath.add(jar);
        }
    }

    @NotNull
    private static List<File> collectClassPathAndLibsFolder(@NotNull MavenDistribution distribution) {
        if (distribution == null) {
            MavenIndexerCMDState.$$$reportNull$$$0(1);
        }
        File pluginFileOrDir = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        String root = pluginFileOrDir.getParent();
        ArrayList<File> classpath = new ArrayList<File>();
        MavenIndexerCMDState.addMavenLibs(classpath, distribution.getMavenHome().toFile());
        MavenIndexerCMDState.addIndexerRTLibs(classpath);
        if (pluginFileOrDir.isDirectory()) {
            MavenLog.LOG.debug("collecting classpath for local run");
            MavenIndexerCMDState.prepareClassPathForLocalRunAndUnitTests(distribution.getVersion(), classpath, root);
            MavenIndexerCMDState.addDependenciesFromMavenRepo(classpath);
        } else {
            MavenLog.LOG.debug("collecting classpath for production");
            MavenIndexerCMDState.prepareClassPathForProduction(distribution.getVersion(), classpath, root);
        }
        MavenLog.LOG.debug("Collected classpath = ", new Object[]{classpath});
        ArrayList<File> arrayList = classpath;
        if (arrayList == null) {
            MavenIndexerCMDState.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void addIndexerRTLibs(List<File> classpath) {
        List<String> resources = MavenIndexerCMDState.getIndexerRTList();
        File libDir = MavenUtil.getPluginSystemDir("rt-maven-indexer-lib").toFile();
        if (!libDir.isDirectory() && !libDir.mkdirs()) {
            throw new PluginException("Cannot create cache directory for maven", PluginId.getId((String)"org.jetbrains.idea.maven"));
        }
        for (String jarName : resources) {
            File file = new File(libDir, jarName);
            if (!file.isFile()) {
                try (InputStream is = MavenIndexerCMDState.class.getClassLoader().getResourceAsStream(jarName);
                     BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
                    if (is == null) {
                        throw new PluginException("Cannot find runtime library " + jarName + " in resources", PluginId.getId((String)"org.jetbrains.idea.maven"));
                    }
                    StreamUtil.copy((InputStream)is, (OutputStream)bos);
                }
                catch (IOException e) {
                    throw new PluginException("Cannot copy runtime library " + jarName + " into " + file, (Throwable)e, PluginId.getId((String)"org.jetbrains.idea.maven"));
                }
            }
            classpath.add(file);
        }
    }

    private static List<String> getIndexerRTList() {
        List<String> list;
        block9: {
            InputStream is = MavenIndexerCMDState.class.getClassLoader().getResourceAsStream("META-INF/org.jetbrains.idea.maven.maven-indexer-api-rt");
            try {
                if (is == null) {
                    throw new PluginException("Cannot find indexer rt libs", PluginId.findId((String)"org.jetbrains.idea.maven"));
                }
                list = Arrays.asList(StreamUtil.readText((Reader)new InputStreamReader(is, Charsets.UTF_8)).split("\n"));
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PluginException((Throwable)e, PluginId.getId((String)"org.jetbrains.idea.maven"));
                }
            }
            is.close();
        }
        return list;
    }

    private static void prepareClassPathForProduction(@NotNull String mavenVersion, @NotNull List<File> classpath, String root) {
        if (mavenVersion == null) {
            MavenIndexerCMDState.$$$reportNull$$$0(3);
        }
        if (classpath == null) {
            MavenIndexerCMDState.$$$reportNull$$$0(4);
        }
        classpath.add(new File(PathUtil.getJarPathForClass(MavenId.class)));
        classpath.add(new File(PathUtil.getJarPathForClass(MavenServer.class)));
        classpath.add(new File(root, "maven-server-indexer.jar"));
        MavenIndexerCMDState.addDir(classpath, new File(root, "maven-server-indexer"), f -> true);
        MavenIndexerCMDState.addDir(classpath, new File(new File(root, "intellij.maven.server.indexer"), "lib"), f -> true);
    }

    private static void prepareClassPathForLocalRunAndUnitTests(@NotNull String mavenVersion, List<File> classpath, String root) {
        if (mavenVersion == null) {
            MavenIndexerCMDState.$$$reportNull$$$0(5);
        }
        classpath.add(new File(PathUtil.getJarPathForClass(MavenId.class)));
        classpath.add(new File(root, "intellij.maven.server"));
        classpath.add(new File(root, "intellij.maven.server.indexer"));
    }

    private static void addMavenLibs(List<File> classpath, File mavenHome) {
        MavenIndexerCMDState.addDir(classpath, new File(mavenHome, "lib"), f -> true);
        File bootFolder = new File(mavenHome, "boot");
        File[] classworldsJars = bootFolder.listFiles((dir2, name) -> StringUtil.contains((CharSequence)name, (CharSequence)"classworlds"));
        if (classworldsJars != null) {
            Collections.addAll(classpath, classworldsJars);
        }
    }

    private static void addDir(List<File> classpath, File dir2, Predicate<File> filter) {
        File[] files2 = dir2.listFiles();
        if (files2 == null) {
            return;
        }
        for (File jar : files2) {
            if (!jar.isFile() || !jar.getName().endsWith(".jar") || !filter.test(jar)) continue;
            classpath.add(jar);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenIndexerCMDState";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenVersion";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classpath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenIndexerCMDState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassPathAndLibsFolder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectClassPathAndLibsFolder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForProduction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForLocalRunAndUnitTests";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

