/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.server.AbstractMavenServerConnector;
import org.jetbrains.idea.maven.server.CannotStartServerException;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenRemoteProcessSupportFactory;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenLog;

abstract class MavenServerConnectorBase
extends AbstractMavenServerConnector {
    protected final Integer myDebugPort;
    protected MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport mySupport;
    protected final AtomicBoolean myConnectStarted;
    protected final AtomicBoolean myTerminated;
    protected boolean throwExceptionIfProjectDisposed;
    protected final AsyncPromise<@NotNull MavenServer> myServerPromise;

    MavenServerConnectorBase(@Nullable Project project2, @NotNull Sdk jdk2, @NotNull String vmOptions, @NotNull MavenDistribution mavenDistribution, @NotNull String multimoduleDirectory, @Nullable Integer debugPort) {
        if (jdk2 == null) {
            MavenServerConnectorBase.$$$reportNull$$$0(0);
        }
        if (vmOptions == null) {
            MavenServerConnectorBase.$$$reportNull$$$0(1);
        }
        if (mavenDistribution == null) {
            MavenServerConnectorBase.$$$reportNull$$$0(2);
        }
        if (multimoduleDirectory == null) {
            MavenServerConnectorBase.$$$reportNull$$$0(3);
        }
        super(project2, jdk2, vmOptions, mavenDistribution, multimoduleDirectory);
        this.myConnectStarted = new AtomicBoolean(false);
        this.myTerminated = new AtomicBoolean(false);
        this.throwExceptionIfProjectDisposed = true;
        this.myServerPromise = new AsyncPromise<MavenServer>(){

            protected boolean shouldLogErrors() {
                return false;
            }
        };
        this.myDebugPort = debugPort;
    }

    @Override
    public boolean isNew() {
        return !this.myConnectStarted.get();
    }

    @NotNull
    protected abstract Runnable newStartServerTask();

    @Override
    public void connect() {
        if (!this.myConnectStarted.compareAndSet(false, true)) {
            return;
        }
        MavenLog.LOG.debug("connecting new maven server: " + this);
        ApplicationManager.getApplication().executeOnPooledThread(this.newStartServerTask());
    }

    @Nullable
    protected MavenServer waitForServer() {
        while (!this.myServerPromise.isDone()) {
            try {
                this.myServerPromise.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.throwExceptionIfProjectDisposed && this.myProject.isDisposed()) {
                throw new CannotStartServerException("Project already disposed");
            }
            ProgressManager.checkCanceled();
        }
        return (MavenServer)this.myServerPromise.get();
    }

    @Override
    @NotNull
    protected MavenServer getServer() {
        MavenServer mavenServer;
        try {
            MavenServer server = this.waitForServer();
            if (server == null) {
                throw new ProcessCanceledException();
            }
            mavenServer = server;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            try {
                MavenServerManager.getInstance().shutdownConnector(this, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e instanceof CannotStartServerException ? (CannotStartServerException)e : new CannotStartServerException(e);
        }
        if (mavenServer == null) {
            MavenServerConnectorBase.$$$reportNull$$$0(4);
        }
        return mavenServer;
    }

    @Override
    @ApiStatus.Internal
    public void stop(boolean wait) {
        MavenLog.LOG.debug("[connector] shutdown " + this + " " + (this.mySupport == null));
        this.cleanUpFutures();
        MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport support = this.mySupport;
        if (support != null) {
            support.stopAll(wait);
        }
        this.myTerminated.set(true);
    }

    @Override
    protected <R, E extends Exception> R perform(AbstractMavenServerConnector.Retriable<R, E> r) throws E {
        RemoteException last = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            try {
                return (R)r.execute();
            }
            catch (RemoteException e) {
                last = e;
                continue;
            }
        }
        this.cleanUpFutures();
        MavenServerManager.getInstance().shutdownConnector(this, false);
        MavenLog.LOG.debug("[connector] perform error " + this);
        throw new RuntimeException("Cannot reconnect.", last);
    }

    protected abstract void cleanUpFutures();

    @Override
    public MavenServerConnector.State getState() {
        return switch (this.myServerPromise.getState()) {
            case Promise.State.SUCCEEDED -> {
                if (this.myTerminated.get()) {
                    yield MavenServerConnector.State.STOPPED;
                }
                yield MavenServerConnector.State.RUNNING;
            }
            case Promise.State.REJECTED -> MavenServerConnector.State.FAILED;
            default -> MavenServerConnector.State.STARTING;
        };
    }

    @Override
    public boolean checkConnected() {
        MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport support = this.mySupport;
        return support != null && !support.getActiveConfigurations().isEmpty();
    }

    @Override
    public boolean ping() {
        try {
            boolean pinged = this.getServer().ping(MavenRemoteObjectWrapper.ourToken);
            MavenLog.LOG.debug("maven server ping: " + pinged);
            return pinged;
        }
        catch (RemoteException e) {
            MavenLog.LOG.warn("maven server ping error", (Throwable)e);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmOptions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenDistribution";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multimoduleDirectory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenServerConnectorBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerConnectorBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

