/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerConfigurable;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.indices.MavenRepositoriesConfigurable;
import org.jetbrains.idea.maven.project.MavenGeneralConfigurable;
import org.jetbrains.idea.maven.project.MavenIgnoredFilesConfigurable;
import org.jetbrains.idea.maven.project.MavenImportingConfigurable;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenTestRunningConfigurable;
import org.jetbrains.idea.maven.wizards.archetype.MavenCatalogsConfigurable;

public class MavenSettings
implements SearchableConfigurable.Parent {
    private final Configurable myConfigurable;
    private final List<Configurable> myChildren;

    public MavenSettings(@NotNull Project project2) {
        if (project2 == null) {
            MavenSettings.$$$reportNull$$$0(0);
        }
        this.myConfigurable = new MavenGeneralConfigurable(project2);
        this.myChildren = new ArrayList<Configurable>();
        this.myChildren.add((Configurable)new MavenImportingConfigurable(project2));
        this.myChildren.add((Configurable)new MavenIgnoredFilesConfigurable(project2));
        this.myChildren.add((Configurable)new MyMavenRunnerConfigurable(project2));
        this.myChildren.add((Configurable)new MavenTestRunningConfigurable(project2));
        if (!project2.isDefault()) {
            this.myChildren.add((Configurable)new MavenRepositoriesConfigurable(project2));
        }
        this.myChildren.add((Configurable)new MavenCatalogsConfigurable(project2));
    }

    public boolean hasOwnContent() {
        return true;
    }

    public JComponent createComponent() {
        return this.myConfigurable.createComponent();
    }

    public boolean isModified() {
        return this.myConfigurable.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myConfigurable.apply();
    }

    public void reset() {
        this.myConfigurable.reset();
    }

    public void disposeUIResources() {
        this.myConfigurable.disposeUIResources();
    }

    public Configurable @NotNull [] getConfigurables() {
        Configurable[] configurableArray = this.myChildren.toArray(new Configurable[0]);
        if (configurableArray == null) {
            MavenSettings.$$$reportNull$$$0(1);
        }
        return configurableArray;
    }

    @NotNull
    public String getId() {
        String string = MavenSettings.class.getSimpleName();
        if (string == null) {
            MavenSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    public String getDisplayName() {
        return MavenProjectBundle.message("configurable.MavenSettings.display.name", new Object[0]);
    }

    public String getHelpTopic() {
        return this.myConfigurable.getHelpTopic();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/utils/MavenSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/utils/MavenSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurables";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    public static class MyMavenRunnerConfigurable
    extends MavenRunnerConfigurable {
        public MyMavenRunnerConfigurable(Project project2) {
            super(project2, false);
        }

        @Override
        protected MavenRunnerSettings getState() {
            return MavenRunner.getInstance(this.myProject).getState();
        }
    }
}

