/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.DeprecatedProjectBuilderForImport;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.containers.ContainerUtil;
import icons.OpenapiIcons;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenImportSpec;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigator;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.actions.LookForNestedToggleAction;
import org.jetbrains.idea.maven.project.importing.FilesList;
import org.jetbrains.idea.maven.project.importing.MavenImportingManager;
import org.jetbrains.idea.maven.server.MavenWrapperSupport;
import org.jetbrains.idea.maven.utils.FileFinder;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenTask;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.wizards.MavenEnvironmentSettingsDialog;
import org.jetbrains.idea.maven.wizards.MavenProjectAsyncBuilder;
import org.jetbrains.idea.maven.wizards.MavenProjectOpenProcessor;

public final class MavenProjectBuilder
extends ProjectImportBuilder<MavenProject>
implements DeprecatedProjectBuilderForImport {
    private static final Logger LOG = Logger.getInstance(MavenProjectBuilder.class);
    private Parameters myParameters;

    @NotNull
    public String getName() {
        String string = MavenProjectBundle.message("maven.name", new Object[0]);
        if (string == null) {
            MavenProjectBuilder.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Icon getIcon() {
        return OpenapiIcons.RepositoryLibraryLogo;
    }

    public void cleanup() {
        this.myParameters = null;
        super.cleanup();
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk == JavaSdk.getInstance();
    }

    private Parameters getParameters() {
        if (this.myParameters == null) {
            this.myParameters = new Parameters();
        }
        return this.myParameters;
    }

    private boolean setupProjectImport(@NotNull Project project2) {
        Path rootDirectory;
        if (project2 == null) {
            MavenProjectBuilder.$$$reportNull$$$0(1);
        }
        return (rootDirectory = this.getRootPath()) != null && this.setRootDirectory(project2, rootDirectory) && this.selectProjectsToUpdate();
    }

    private boolean selectProjectsToUpdate() {
        Parameters parameters = this.getParameters();
        MavenProjectsTree projectsTree = parameters.myMavenProjectTree;
        List<MavenProject> projects = projectsTree.getRootProjects();
        if (projects.isEmpty()) {
            return false;
        }
        parameters.mySelectedProjects = projects;
        return true;
    }

    public VirtualFile getProjectFileToImport() {
        VirtualFile projectFile = this.getParameters().myImportProjectFile;
        if (null != projectFile) {
            return projectFile;
        }
        Path importRootDirectory = this.getParameters().myImportRootDirectory;
        if (null != importRootDirectory) {
            return VirtualFileManager.getInstance().findFileByNioPath(importRootDirectory);
        }
        return null;
    }

    private List<Module> commitWithAsyncBuilder(Project project2, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        VirtualFile projectFile = this.getProjectFileToImport();
        if (null == projectFile) {
            LOG.warn("Project file missing");
            return List.of();
        }
        IdeUIModifiableModelsProvider modelsProvider = null;
        if (model != null) {
            modelsProvider = new IdeUIModifiableModelsProvider(project2, model, (ModulesConfigurator)modulesProvider, artifactModel);
        }
        return new MavenProjectAsyncBuilder().commitSync(project2, projectFile, (IdeModifiableModelsProvider)modelsProvider);
    }

    public List<Module> commit(Project project2, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        String distributionUrl;
        boolean asyncBuilder = true;
        if (asyncBuilder) {
            return this.commitWithAsyncBuilder(project2, model, modulesProvider, artifactModel);
        }
        boolean isVeryNewProject = project2.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) == Boolean.TRUE;
        MavenImportingSettings importingSettings = this.getImportingSettings();
        if (isVeryNewProject) {
            ExternalProjectsManagerImpl.setupCreatedProject((Project)project2);
            MavenProjectsManager.setupCreatedMavenProject(importingSettings);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            FileDocumentManager.getInstance().saveAllDocuments();
        }
        MavenUtil.setupProjectSdk(project2);
        MavenProjectsNavigator projectsNavigator = MavenProjectsNavigator.getInstance(project2);
        if (projectsNavigator != null) {
            projectsNavigator.setGroupModules(true);
        }
        if (!this.setupProjectImport(project2)) {
            LOG.debug(String.format("Cannot import project for %s", project2.toString()));
            return Collections.emptyList();
        }
        MavenWorkspaceSettings settings = MavenWorkspaceSettingsComponent.getInstance(project2).getSettings();
        MavenGeneralSettings generalSettings = this.getGeneralSettings();
        settings.setGeneralSettings(generalSettings);
        settings.setImportingSettings(importingSettings);
        String settingsFile2 = System.getProperty("idea.maven.import.settings.file");
        if (!StringUtil.isEmptyOrSpaces((String)settingsFile2)) {
            settings.getGeneralSettings().setUserSettingsFile(settingsFile2.trim());
        }
        if ((distributionUrl = MavenWrapperSupport.getWrapperDistributionUrl(ProjectUtil.guessProjectDir((Project)project2))) != null) {
            settings.getGeneralSettings().setMavenHome("Use Maven wrapper");
        }
        MavenExplicitProfiles selectedProfiles = MavenExplicitProfiles.NONE.clone();
        String enabledProfilesList = System.getProperty("idea.maven.import.enabled.profiles");
        String disabledProfilesList = System.getProperty("idea.maven.import.disabled.profiles");
        if (enabledProfilesList != null || disabledProfilesList != null) {
            MavenProjectBuilder.appendProfilesFromString(selectedProfiles.getEnabledProfiles(), enabledProfilesList);
            MavenProjectBuilder.appendProfilesFromString(selectedProfiles.getDisabledProfiles(), disabledProfilesList);
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project2);
        ArrayList<MavenProject> selectedProjects = new ArrayList<MavenProject>(this.getParameters().mySelectedProjects);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !manager.hasProjects() && settings.getGeneralSettings().isShowDialogWithAdvancedSettings()) {
            this.showGeneralSettingsConfigurationDialog(project2, settings.getGeneralSettings(), () -> this.performImport(project2, model, null, artifactModel, selectedProfiles, selectedProjects, importingSettings, generalSettings));
            return Collections.emptyList();
        }
        return this.performImport(project2, model, modulesProvider, artifactModel, selectedProfiles, selectedProjects, importingSettings, generalSettings);
    }

    @NotNull
    private List<Module> performImport(Project project2, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel, MavenExplicitProfiles selectedProfiles, List<MavenProject> selectedProjects, MavenImportingSettings importingSettings, MavenGeneralSettings generalSettings) {
        List createdModules;
        boolean isFromUI;
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project2);
        boolean isVeryNewProject = project2.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) == Boolean.TRUE;
        manager.setIgnoredState(selectedProjects, false);
        if (MavenUtil.isLinearImportEnabled()) {
            MavenLog.LOG.warn("performImport: Linear Import is enabled");
            Module dummy = MavenImportingManager.getInstance(project2).openProjectAndImport(new FilesList(MavenUtil.collectFiles(selectedProjects)), importingSettings, generalSettings, MavenImportSpec.EXPLICIT_IMPORT).getPreviewModulesCreated();
            if (dummy != null) {
                List<Module> list = Collections.singletonList(dummy);
                if (list == null) {
                    MavenProjectBuilder.$$$reportNull$$$0(2);
                }
                return list;
            }
            List<Module> list = Collections.emptyList();
            if (list == null) {
                MavenProjectBuilder.$$$reportNull$$$0(3);
            }
            return list;
        }
        MavenLog.LOG.warn("performImport: Linear Import is disabled");
        if (isVeryNewProject && Registry.is((String)"maven.create.dummy.module.on.first.import")) {
            Module previewModule = this.createPreviewModule(project2, selectedProjects);
            manager.addManagedFilesWithProfiles(MavenUtil.collectFiles(selectedProjects), selectedProfiles, previewModule);
            List<Module> list = Collections.singletonList(previewModule);
            if (list == null) {
                MavenProjectBuilder.$$$reportNull$$$0(4);
            }
            return list;
        }
        manager.addManagedFilesWithProfiles(MavenUtil.collectFiles(selectedProjects), selectedProfiles, null);
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode() && (!MavenUtil.isMavenUnitTestModeEnabled() || Registry.is((String)"ide.force.maven.import", (boolean)false))) {
            List list = manager.importMavenProjectsSync(Map.of(), null);
            if (list == null) {
                MavenProjectBuilder.$$$reportNull$$$0(5);
            }
            return list;
        }
        HashMap<MavenProject, MavenProjectChanges> projectsToImport = new HashMap<MavenProject, MavenProjectChanges>();
        for (MavenProject selectedProject : selectedProjects) {
            MavenProject projectToImport = manager.getProjectsTree().findProject(selectedProject.getFile());
            if (null == projectToImport) continue;
            projectsToImport.put(projectToImport, MavenProjectChanges.ALL);
        }
        boolean bl = isFromUI = model != null;
        if (isFromUI) {
            IdeUIModifiableModelsProvider modelsProvider = new IdeUIModifiableModelsProvider(project2, model, (ModulesConfigurator)modulesProvider, artifactModel);
            createdModules = manager.importMavenProjectsSync(projectsToImport, (IdeModifiableModelsProvider)modelsProvider);
        } else {
            createdModules = manager.importMavenProjectsSync(projectsToImport, null);
        }
        List list = createdModules;
        if (list == null) {
            MavenProjectBuilder.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    private Module createPreviewModule(Project project2, List<MavenProject> selectedProjects) {
        if (ModuleManager.getInstance((Project)project2).getModules().length == 0) {
            MavenProject root = (MavenProject)ContainerUtil.getFirstItem(selectedProjects);
            if (root == null) {
                return null;
            }
            VirtualFile contentRoot = root.getDirectoryFile();
            return MavenImportUtil.createPreviewModule(project2, contentRoot);
        }
        return null;
    }

    private void showGeneralSettingsConfigurationDialog(@NotNull Project project2, @NotNull MavenGeneralSettings generalSettings, Runnable runImportAfter) {
        if (project2 == null) {
            MavenProjectBuilder.$$$reportNull$$$0(7);
        }
        if (generalSettings == null) {
            MavenProjectBuilder.$$$reportNull$$$0(8);
        }
        MavenEnvironmentSettingsDialog dialog = new MavenEnvironmentSettingsDialog(project2, generalSettings, runImportAfter);
        ApplicationManager.getApplication().invokeLater(() -> dialog.show());
    }

    private static void appendProfilesFromString(Collection<String> selectedProfiles, String profilesList) {
        if (profilesList == null) {
            return;
        }
        for (String profile : StringUtil.split((String)profilesList, (String)",")) {
            String trimmedProfileName = profile.trim();
            if (trimmedProfileName.isEmpty()) continue;
            selectedProfiles.add(trimmedProfileName);
        }
    }

    @Deprecated(forRemoval=true)
    public boolean setRootDirectory(@Nullable Project projectToUpdate, @NotNull String root) {
        if (root == null) {
            MavenProjectBuilder.$$$reportNull$$$0(9);
        }
        return this.setRootDirectory(projectToUpdate, Paths.get(root, new String[0]));
    }

    public boolean setRootDirectory(@Nullable Project projectToUpdate, final @NotNull Path root) {
        if (root == null) {
            MavenProjectBuilder.$$$reportNull$$$0(10);
        }
        this.getParameters().myFiles = null;
        this.getParameters().myMavenProjectTree = null;
        this.getParameters().myProjectToUpdate = projectToUpdate != null ? projectToUpdate : ProjectManager.getInstance().getDefaultProject();
        return MavenProjectBuilder.runConfigurationProcess(MavenProjectBundle.message("maven.scanning.projects", new Object[0]), new MavenTask(){

            @Override
            public void run(MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                indicator.setText(MavenProjectBundle.message("maven.locating.files", new Object[0]));
                MavenProjectBuilder.this.getParameters().myImportRootDirectory = root;
                if (MavenProjectBuilder.this.getParameters().myImportRootDirectory == null) {
                    throw new MavenProcessCanceledException();
                }
                MavenProjectBuilder.this.getParameters().myFiles = MavenProjectBuilder.this.getProjectFiles(indicator);
                MavenProjectBuilder.this.readMavenProjectTree(indicator);
                indicator.setText("");
                indicator.setText2("");
            }
        });
    }

    private static boolean runConfigurationProcess(@NlsContexts.DialogTitle String message, MavenTask p) {
        try {
            MavenUtil.run(message, p);
        }
        catch (MavenProcessCanceledException e) {
            return false;
        }
        return true;
    }

    private void readMavenProjectTree(MavenProgressIndicator process) {
        MavenProjectsTree tree = new MavenProjectsTree(this.getProjectOrDefault());
        tree.addManagedFilesWithProfiles(this.getParameters().myFiles, MavenExplicitProfiles.NONE);
        tree.updateAll(false, this.getGeneralSettings(), process.getIndicator());
        this.getParameters().myMavenProjectTree = tree;
        this.getParameters().mySelectedProjects = tree.getRootProjects();
    }

    public List<MavenProject> getList() {
        return this.getParameters().myMavenProjectTree.getRootProjects();
    }

    public void setList(List<MavenProject> projects) {
        this.getParameters().mySelectedProjects = projects;
    }

    public boolean isMarked(MavenProject element) {
        return this.getParameters().mySelectedProjects.contains(element);
    }

    public boolean isOpenProjectSettingsAfter() {
        return this.getParameters().myOpenModulesConfigurator;
    }

    public void setOpenProjectSettingsAfter(boolean on) {
        this.getParameters().myOpenModulesConfigurator = on;
    }

    private MavenGeneralSettings getGeneralSettings() {
        if (this.getParameters().myGeneralSettingsCache == null) {
            ApplicationManager.getApplication().runReadAction(() -> {
                this.getParameters().myGeneralSettingsCache = this.getDirectProjectsSettings().getGeneralSettings().clone();
                List<VirtualFile> rootFiles = this.getParameters().myFiles;
                if (rootFiles == null) {
                    rootFiles = Collections.singletonList(LocalFileSystem.getInstance().findFileByNioFile(this.getRootPath()));
                }
                this.getParameters().myGeneralSettingsCache.updateFromMavenConfig(rootFiles);
            });
        }
        return this.getParameters().myGeneralSettingsCache;
    }

    public MavenImportingSettings getImportingSettings() {
        if (this.getParameters().myImportingSettingsCache == null) {
            ApplicationManager.getApplication().runReadAction(() -> {
                this.getParameters().myImportingSettingsCache = this.getDirectProjectsSettings().getImportingSettings().clone();
            });
        }
        return this.getParameters().myImportingSettingsCache;
    }

    private MavenWorkspaceSettings getDirectProjectsSettings() {
        Project project2;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project3 = project2 = this.isUpdate() ? this.getProjectToUpdate() : null;
        if (project2 == null || project2.isDisposed()) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        return MavenWorkspaceSettingsComponent.getInstance(project2).getSettings();
    }

    public void setFiles(List<VirtualFile> files2) {
        this.getParameters().myFiles = files2;
    }

    @Nullable
    public Project getProjectToUpdate() {
        if (this.getParameters().myProjectToUpdate == null) {
            this.getParameters().myProjectToUpdate = MavenProjectBuilder.getCurrentProject();
        }
        return this.getParameters().myProjectToUpdate;
    }

    @NotNull
    public Project getProjectOrDefault() {
        Project project2 = this.getProjectToUpdate();
        if (project2 == null || project2.isDisposed()) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        Project project3 = project2;
        if (project3 == null) {
            MavenProjectBuilder.$$$reportNull$$$0(11);
        }
        return project3;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public VirtualFile getRootDirectory() {
        Path rootPath = this.getRootPath();
        return rootPath == null ? null : VfsUtil.findFile((Path)rootPath, (boolean)false);
    }

    @Nullable
    public Path getRootPath() {
        if (this.getParameters().myImportRootDirectory == null && this.isUpdate()) {
            Project project2 = this.getProjectToUpdate();
            this.getParameters().myImportRootDirectory = project2 == null ? null : Paths.get(Objects.requireNonNull(project2.getBasePath()), new String[0]);
        }
        return this.getParameters().myImportRootDirectory;
    }

    @Nullable
    public String getSuggestedProjectName() {
        List<MavenProject> list = this.getParameters().myMavenProjectTree.getRootProjects();
        return list.size() == 1 ? list.get(0).getMavenId().getArtifactId() : null;
    }

    public void setFileToImport(@NotNull String path) {
        if (path == null) {
            MavenProjectBuilder.$$$reportNull$$$0(12);
        }
        this.setFileToImport(Paths.get(path, new String[0]));
    }

    public void setFileToImport(@NotNull Path path) {
        if (path == null) {
            MavenProjectBuilder.$$$reportNull$$$0(13);
        }
        this.getParameters().myImportRootDirectory = Files.isDirectory(path, new LinkOption[0]) ? path : path.getParent();
    }

    public void setFileToImport(@NotNull VirtualFile file) {
        if (file == null) {
            MavenProjectBuilder.$$$reportNull$$$0(14);
        }
        if (!file.isDirectory()) {
            this.getParameters().myImportProjectFile = file;
        }
        this.getParameters().myImportRootDirectory = file.isDirectory() ? file.toNioPath() : file.getParent().toNioPath();
    }

    @Nullable
    public Project createProject(String name, String path) {
        Project project2 = super.createProject(name, path);
        if (project2 != null) {
            ExternalProjectsManagerImpl.setupCreatedProject((Project)project2);
            project2.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)true);
        }
        return project2;
    }

    @NotNull
    public ProjectOpenProcessor getProjectOpenProcessor() {
        ProjectOpenProcessor projectOpenProcessor = (ProjectOpenProcessor)ProjectOpenProcessor.EXTENSION_POINT_NAME.findExtensionOrFail(MavenProjectOpenProcessor.class);
        if (projectOpenProcessor == null) {
            MavenProjectBuilder.$$$reportNull$$$0(15);
        }
        return projectOpenProcessor;
    }

    private List<VirtualFile> getProjectFiles(@NotNull MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        VirtualFile virtualFile;
        if (indicator == null) {
            MavenProjectBuilder.$$$reportNull$$$0(16);
        }
        if (this.getParameters().myImportProjectFile != null) {
            return Collections.singletonList(this.getParameters().myImportProjectFile);
        }
        Path file = this.getRootPath();
        VirtualFile virtualFile2 = virtualFile = file == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)file.toString()));
        if (virtualFile == null) {
            throw new MavenProcessCanceledException();
        }
        return FileFinder.findPomFiles(virtualFile.getChildren(), LookForNestedToggleAction.isSelected(), indicator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 7, 8, 9, 10, 12, 13, 14, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/wizards/MavenProjectBuilder";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generalSettings";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/wizards/MavenProjectBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "performImport";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectOrDefault";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectOpenProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setupProjectImport";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showGeneralSettingsConfigurationDialog";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setRootDirectory";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setFileToImport";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getProjectFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 7, 8, 9, 10, 12, 13, 14, 16 -> new IllegalArgumentException(string);
        };
    }

    private static class Parameters {
        private Project myProjectToUpdate;
        private MavenGeneralSettings myGeneralSettingsCache;
        private MavenImportingSettings myImportingSettingsCache;
        private Path myImportRootDirectory;
        private VirtualFile myImportProjectFile;
        private List<VirtualFile> myFiles;
        private MavenProjectsTree myMavenProjectTree;
        private List<MavenProject> mySelectedProjects;
        private boolean myOpenModulesConfigurator;

        private Parameters() {
        }
    }
}

