/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.observable.operation.OperationExecutionContext;
import com.intellij.openapi.observable.operation.OperationExecutionId;
import com.intellij.openapi.observable.operation.OperationExecutionStatus;
import com.intellij.openapi.observable.operation.core.AtomicOperationTrace;
import com.intellij.openapi.observable.operation.core.ObservableOperationTrace;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleImportingUtil;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u001a\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u000b0\n\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a*\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u001a\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u000b0\n\u001a\u0016\u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0002H\u0002\u001a(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00140\n\u001a.\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u001e\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00140\u0018\u001a,\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u001a\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00140\nH\u0002\u001a4\u0010\u001a\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u001a\u0010\u0015\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00140\nH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"ID_KEY", "Lcom/intellij/openapi/observable/operation/OperationExecutionContext$ContextKey;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "PATH_KEY", "", "getGradleProjectReloadOperation", "Lcom/intellij/openapi/observable/operation/core/ObservableOperationTrace;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "isRelevant", "Lkotlin/Function2;", "", "project", "Lcom/intellij/openapi/project/Project;", "externalProjectPath", "getGradleTaskExecutionOperation", "isExecuteTask", "id", "isResolveTask", "whenExternalSystemTaskFinished", "", "action", "Lcom/intellij/openapi/observable/operation/OperationExecutionStatus;", "whenExternalSystemTaskOutputAdded", "Lkotlin/Function3;", "whenExternalSystemTaskStarted", "whenProjectDataLoadFinished", "intellij.gradle.common"})
@JvmName(name="GradleImportingUtil")
@ApiStatus.Internal
public final class GradleImportingUtil {
    @NotNull
    private static final OperationExecutionContext.ContextKey<ExternalSystemTaskId> ID_KEY = OperationExecutionContext.Companion.createKey("ID");
    @NotNull
    private static final OperationExecutionContext.ContextKey<String> PATH_KEY = OperationExecutionContext.Companion.createKey("PATH");

    @NotNull
    public static final ObservableOperationTrace getGradleProjectReloadOperation(@NotNull String externalProjectPath2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        return GradleImportingUtil.getGradleProjectReloadOperation(parentDisposable, (Function2<? super ExternalSystemTaskId, ? super String, Boolean>)((Function2)new Function2<ExternalSystemTaskId, String, Boolean>(externalProjectPath2){
            final /* synthetic */ String $externalProjectPath;
            {
                this.$externalProjectPath = $externalProjectPath;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull ExternalSystemTaskId externalSystemTaskId, @Nullable String path) {
                Intrinsics.checkNotNullParameter((Object)externalSystemTaskId, (String)"<anonymous parameter 0>");
                return Intrinsics.areEqual((Object)path, (Object)this.$externalProjectPath);
            }
        }));
    }

    @NotNull
    public static final ObservableOperationTrace getGradleProjectReloadOperation(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        return GradleImportingUtil.getGradleProjectReloadOperation(parentDisposable, (Function2<? super ExternalSystemTaskId, ? super String, Boolean>)((Function2)new Function2<ExternalSystemTaskId, String, Boolean>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull ExternalSystemTaskId id, @Nullable String string2) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                return Intrinsics.areEqual((Object)id.findProject(), (Object)this.$project);
            }
        }));
    }

    @NotNull
    public static final ObservableOperationTrace getGradleProjectReloadOperation(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        return GradleImportingUtil.getGradleProjectReloadOperation(parentDisposable, (Function2<? super ExternalSystemTaskId, ? super String, Boolean>)((Function2)getGradleProjectReloadOperation.3.INSTANCE));
    }

    @NotNull
    public static final ObservableOperationTrace getGradleTaskExecutionOperation(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        return GradleImportingUtil.getGradleTaskExecutionOperation(parentDisposable, (Function2<? super ExternalSystemTaskId, ? super String, Boolean>)((Function2)new Function2<ExternalSystemTaskId, String, Boolean>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull ExternalSystemTaskId id, @Nullable String string2) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                return Intrinsics.areEqual((Object)id.findProject(), (Object)this.$project);
            }
        }));
    }

    @NotNull
    public static final ObservableOperationTrace getGradleTaskExecutionOperation(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        return GradleImportingUtil.getGradleTaskExecutionOperation(parentDisposable, (Function2<? super ExternalSystemTaskId, ? super String, Boolean>)((Function2)getGradleTaskExecutionOperation.2.INSTANCE));
    }

    @NotNull
    public static final ObservableOperationTrace getGradleProjectReloadOperation(@NotNull Disposable parentDisposable, @NotNull Function2<? super ExternalSystemTaskId, ? super String, Boolean> isRelevant) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(isRelevant, (String)"isRelevant");
        AtomicOperationTrace operation = new AtomicOperationTrace("Gradle Reload");
        HashMap<ExternalSystemTaskId, OperationExecutionId> executionIds = new HashMap<ExternalSystemTaskId, OperationExecutionId>();
        GradleImportingUtil.whenExternalSystemTaskStarted(parentDisposable, (Function2<? super ExternalSystemTaskId, ? super String, Unit>)((Function2)new Function2<ExternalSystemTaskId, String, Unit>(isRelevant, executionIds, operation){
            final /* synthetic */ Function2<ExternalSystemTaskId, String, Boolean> $isRelevant;
            final /* synthetic */ HashMap<ExternalSystemTaskId, OperationExecutionId> $executionIds;
            final /* synthetic */ AtomicOperationTrace $operation;
            {
                this.$isRelevant = $isRelevant;
                this.$executionIds = $executionIds;
                this.$operation = $operation;
                super(2);
            }

            public final void invoke(@NotNull ExternalSystemTaskId id, @Nullable String path) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                if (GradleImportingUtil.access$isResolveTask(id) && ((Boolean)this.$isRelevant.invoke((Object)id, (Object)path)).booleanValue()) {
                    OperationExecutionId executionId2 = OperationExecutionId.Companion.createId$default((OperationExecutionId.Companion)OperationExecutionId.Companion, null, (Function1)((Function1)new Function1<OperationExecutionContext.Builder, Unit>(id, path){
                        final /* synthetic */ ExternalSystemTaskId $id;
                        final /* synthetic */ String $path;
                        {
                            this.$id = $id;
                            this.$path = $path;
                            super(1);
                        }

                        public final void invoke(@NotNull OperationExecutionContext.Builder $this$createId) {
                            Intrinsics.checkNotNullParameter((Object)$this$createId, (String)"$this$createId");
                            $this$createId.putData(GradleImportingUtil.access$getID_KEY$p(), (Object)this.$id);
                            $this$createId.putData(GradleImportingUtil.access$getPATH_KEY$p(), (Object)this.$path);
                        }
                    }), (int)1, null);
                    ((Map)this.$executionIds).put(id, executionId2);
                    this.$operation.traceStart(executionId2);
                }
            }
        }));
        GradleImportingUtil.whenExternalSystemTaskFinished(parentDisposable, (Function2<? super ExternalSystemTaskId, ? super OperationExecutionStatus, Unit>)((Function2)new Function2<ExternalSystemTaskId, OperationExecutionStatus, Unit>(executionIds, operation, parentDisposable, isRelevant){
            final /* synthetic */ HashMap<ExternalSystemTaskId, OperationExecutionId> $executionIds;
            final /* synthetic */ AtomicOperationTrace $operation;
            final /* synthetic */ Disposable $parentDisposable;
            final /* synthetic */ Function2<ExternalSystemTaskId, String, Boolean> $isRelevant;
            {
                this.$executionIds = $executionIds;
                this.$operation = $operation;
                this.$parentDisposable = $parentDisposable;
                this.$isRelevant = $isRelevant;
                super(2);
            }

            public final void invoke(@NotNull ExternalSystemTaskId id, @NotNull OperationExecutionStatus status) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                OperationExecutionId executionId2 = this.$executionIds.remove(id);
                if (executionId2 != null) {
                    if (!(status instanceof OperationExecutionStatus.Success)) {
                        this.$operation.traceFinish(executionId2, status);
                        return;
                    }
                    Project project = id.findProject();
                    if (project == null) {
                        this.$operation.traceFinish(executionId2, (OperationExecutionStatus)OperationExecutionStatus.Cancel.INSTANCE);
                        return;
                    }
                    Disposable disposable = Disposer.newDisposable((Disposable)this.$parentDisposable);
                    Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(parentDisposable)");
                    Disposable loadDisposable = disposable;
                    GradleImportingUtil.access$whenProjectDataLoadFinished(project, loadDisposable, (Function2)new Function2<String, OperationExecutionStatus, Unit>(this.$isRelevant, id, loadDisposable, this.$operation, executionId2){
                        final /* synthetic */ Function2<ExternalSystemTaskId, String, Boolean> $isRelevant;
                        final /* synthetic */ ExternalSystemTaskId $id;
                        final /* synthetic */ Disposable $loadDisposable;
                        final /* synthetic */ AtomicOperationTrace $operation;
                        final /* synthetic */ OperationExecutionId $executionId;
                        {
                            this.$isRelevant = $isRelevant;
                            this.$id = $id;
                            this.$loadDisposable = $loadDisposable;
                            this.$operation = $operation;
                            this.$executionId = $executionId;
                            super(2);
                        }

                        public final void invoke(@Nullable String path, @NotNull OperationExecutionStatus loadStatus) {
                            Intrinsics.checkNotNullParameter((Object)loadStatus, (String)"loadStatus");
                            if (((Boolean)this.$isRelevant.invoke((Object)this.$id, (Object)path)).booleanValue()) {
                                Disposer.dispose((Disposable)this.$loadDisposable);
                                this.$operation.traceFinish(this.$executionId, loadStatus);
                            }
                        }
                    });
                }
            }
        }));
        return (ObservableOperationTrace)operation;
    }

    @NotNull
    public static final ObservableOperationTrace getGradleTaskExecutionOperation(@NotNull Disposable parentDisposable, @NotNull Function2<? super ExternalSystemTaskId, ? super String, Boolean> isRelevant) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(isRelevant, (String)"isRelevant");
        AtomicOperationTrace operation = new AtomicOperationTrace("Gradle Task Execution");
        HashMap<ExternalSystemTaskId, OperationExecutionId> executionIds = new HashMap<ExternalSystemTaskId, OperationExecutionId>();
        GradleImportingUtil.whenExternalSystemTaskStarted(parentDisposable, (Function2<? super ExternalSystemTaskId, ? super String, Unit>)((Function2)new Function2<ExternalSystemTaskId, String, Unit>(isRelevant, executionIds, operation){
            final /* synthetic */ Function2<ExternalSystemTaskId, String, Boolean> $isRelevant;
            final /* synthetic */ HashMap<ExternalSystemTaskId, OperationExecutionId> $executionIds;
            final /* synthetic */ AtomicOperationTrace $operation;
            {
                this.$isRelevant = $isRelevant;
                this.$executionIds = $executionIds;
                this.$operation = $operation;
                super(2);
            }

            public final void invoke(@NotNull ExternalSystemTaskId id, @Nullable String path) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                if (GradleImportingUtil.access$isExecuteTask(id) && ((Boolean)this.$isRelevant.invoke((Object)id, (Object)path)).booleanValue()) {
                    OperationExecutionId executionId2 = OperationExecutionId.Companion.createId$default((OperationExecutionId.Companion)OperationExecutionId.Companion, null, (Function1)((Function1)new Function1<OperationExecutionContext.Builder, Unit>(id, path){
                        final /* synthetic */ ExternalSystemTaskId $id;
                        final /* synthetic */ String $path;
                        {
                            this.$id = $id;
                            this.$path = $path;
                            super(1);
                        }

                        public final void invoke(@NotNull OperationExecutionContext.Builder $this$createId) {
                            Intrinsics.checkNotNullParameter((Object)$this$createId, (String)"$this$createId");
                            $this$createId.putData(GradleImportingUtil.access$getID_KEY$p(), (Object)this.$id);
                            $this$createId.putData(GradleImportingUtil.access$getPATH_KEY$p(), (Object)this.$path);
                        }
                    }), (int)1, null);
                    ((Map)this.$executionIds).put(id, executionId2);
                    this.$operation.traceStart(executionId2);
                }
            }
        }));
        GradleImportingUtil.whenExternalSystemTaskFinished(parentDisposable, (Function2<? super ExternalSystemTaskId, ? super OperationExecutionStatus, Unit>)((Function2)new Function2<ExternalSystemTaskId, OperationExecutionStatus, Unit>(executionIds, operation){
            final /* synthetic */ HashMap<ExternalSystemTaskId, OperationExecutionId> $executionIds;
            final /* synthetic */ AtomicOperationTrace $operation;
            {
                this.$executionIds = $executionIds;
                this.$operation = $operation;
                super(2);
            }

            public final void invoke(@NotNull ExternalSystemTaskId id, @NotNull OperationExecutionStatus status) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                OperationExecutionId executionId2 = this.$executionIds.remove(id);
                if (executionId2 != null) {
                    this.$operation.traceFinish(executionId2, status);
                }
            }
        }));
        return (ObservableOperationTrace)operation;
    }

    private static final boolean isResolveTask(ExternalSystemTaskId id) {
        ExternalSystemTask task2;
        if (id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT && (task2 = ((ExternalSystemProcessingManager)ApplicationManager.getApplication().getService(ExternalSystemProcessingManager.class)).findTask(id)) instanceof ExternalSystemResolveProjectTask) {
            return !((ExternalSystemResolveProjectTask)task2).isPreviewMode();
        }
        return false;
    }

    private static final boolean isExecuteTask(ExternalSystemTaskId id) {
        return id.getType() == ExternalSystemTaskType.EXECUTE_TASK;
    }

    private static final void whenExternalSystemTaskStarted(Disposable parentDisposable, Function2<? super ExternalSystemTaskId, ? super String, Unit> action2) {
        ExternalSystemProgressNotificationManager.getInstance().addNotificationListener((ExternalSystemTaskNotificationListener)new ExternalSystemTaskNotificationListenerAdapter(action2){
            final /* synthetic */ Function2<ExternalSystemTaskId, String, Unit> $action;
            {
                this.$action = $action;
            }

            public void onStart(@NotNull ExternalSystemTaskId id, @Nullable String workingDir) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                this.$action.invoke((Object)id, (Object)workingDir);
            }
        }, parentDisposable);
    }

    public static final void whenExternalSystemTaskFinished(@NotNull Disposable parentDisposable, @NotNull Function2<? super ExternalSystemTaskId, ? super OperationExecutionStatus, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        ExternalSystemProgressNotificationManager.getInstance().addNotificationListener((ExternalSystemTaskNotificationListener)new ExternalSystemTaskNotificationListenerAdapter(action2){
            final /* synthetic */ Function2<ExternalSystemTaskId, OperationExecutionStatus, Unit> $action;
            {
                this.$action = $action;
            }

            public void onSuccess(@NotNull ExternalSystemTaskId id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                this.$action.invoke((Object)id, (Object)OperationExecutionStatus.Success.INSTANCE);
            }

            public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$action.invoke((Object)id, (Object)new OperationExecutionStatus.Failure((Throwable)e));
            }

            public void onCancel(@NotNull ExternalSystemTaskId id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                this.$action.invoke((Object)id, (Object)OperationExecutionStatus.Cancel.INSTANCE);
            }
        }, parentDisposable);
    }

    public static final void whenExternalSystemTaskOutputAdded(@NotNull Disposable parentDisposable, @NotNull Function3<? super ExternalSystemTaskId, ? super String, ? super Boolean, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        ExternalSystemTaskNotificationListenerAdapter listener2 = new ExternalSystemTaskNotificationListenerAdapter(action2){
            final /* synthetic */ Function3<ExternalSystemTaskId, String, Boolean, Unit> $action;
            {
                this.$action = $action;
            }

            public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.$action.invoke((Object)id, (Object)text, (Object)stdOut);
            }
        };
        ExternalSystemProgressNotificationManager.getInstance().addNotificationListener((ExternalSystemTaskNotificationListener)listener2, parentDisposable);
    }

    private static final void whenProjectDataLoadFinished(Project project, Disposable parentDisposable, Function2<? super String, ? super OperationExecutionStatus, Unit> action2) {
        MessageBusConnection messageBusConnection = project.getMessageBus().connect(parentDisposable);
        Topic topic = ProjectDataImportListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ProjectDataImportListener(action2){
            final /* synthetic */ Function2<String, OperationExecutionStatus, Unit> $action;
            {
                this.$action = $action;
            }

            public void onImportFailed(@Nullable String projectPath, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$action.invoke((Object)projectPath, (Object)new OperationExecutionStatus.Failure(t));
            }

            public void onFinalTasksFinished(@Nullable String projectPath) {
                this.$action.invoke((Object)projectPath, (Object)OperationExecutionStatus.Success.INSTANCE);
            }
        });
    }

    public static final /* synthetic */ boolean access$isResolveTask(ExternalSystemTaskId id) {
        return GradleImportingUtil.isResolveTask(id);
    }

    public static final /* synthetic */ OperationExecutionContext.ContextKey access$getID_KEY$p() {
        return ID_KEY;
    }

    public static final /* synthetic */ OperationExecutionContext.ContextKey access$getPATH_KEY$p() {
        return PATH_KEY;
    }

    public static final /* synthetic */ void access$whenProjectDataLoadFinished(Project project, Disposable parentDisposable, Function2 action2) {
        GradleImportingUtil.whenProjectDataLoadFinished(project, parentDisposable, (Function2<? super String, ? super OperationExecutionStatus, Unit>)action2);
    }

    public static final /* synthetic */ boolean access$isExecuteTask(ExternalSystemTaskId id) {
        return GradleImportingUtil.isExecuteTask(id);
    }
}

