/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.cli.Option;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.execution.cmd.GradleCommandLineOptionsProvider;
import org.jetbrains.plugins.gradle.util.cmd.GradleCommandLineParser;
import org.jetbrains.plugins.gradle.util.cmd.GradleCommandLineTokenizer;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLine;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineOption;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineTask;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\t\u001a\u0004\u0018\u00010\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002J\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002J\u001e\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/util/cmd/GradleCommandLineParser;", "", "tokenizer", "Lorg/jetbrains/plugins/gradle/util/cmd/GradleCommandLineTokenizer;", "(Lorg/jetbrains/plugins/gradle/util/cmd/GradleCommandLineTokenizer;)V", "parse", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLine;", "parseTask", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineTask;", "tryParseLongPrefixOption", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineOption;", "options", "", "", "Lorg/apache/commons/cli/Option;", "tryParseOption", "", "tryParseOptionWithArguments", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineOption$VarargNotation;", "tryParseShortPrefixOption", "Companion", "intellij.gradle.common"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nGradleCommandLineParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleCommandLineParser.kt\norg/jetbrains/plugins/gradle/util/cmd/GradleCommandLineParser\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,120:1\n674#2:121\n704#2,4:122\n674#2:126\n704#2,4:127\n*S KotlinDebug\n*F\n+ 1 GradleCommandLineParser.kt\norg/jetbrains/plugins/gradle/util/cmd/GradleCommandLineParser\n*L\n42#1:121\n42#1:122,4\n45#1:126\n45#1:127,4\n*E\n"})
public final class GradleCommandLineParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GradleCommandLineTokenizer tokenizer;
    @NotNull
    private static final List<Option> ALL_OPTIONS;
    private static final Collection<Option> ALL_TASK_OPTIONS;

    public GradleCommandLineParser(@NotNull GradleCommandLineTokenizer tokenizer) {
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        this.tokenizer = tokenizer;
    }

    @NotNull
    public final GradleCommandLine parse() {
        ArrayList<GradleCommandLineTask> tasks2 = new ArrayList<GradleCommandLineTask>();
        ArrayList<GradleCommandLineOption> options = new ArrayList<GradleCommandLineOption>();
        while (!this.tokenizer.isEof()) {
            GradleCommandLineOption option = this.tryParseOption((Collection<? extends Option>)ALL_OPTIONS);
            if (option != null) {
                options.add(option);
                continue;
            }
            tasks2.add(this.parseTask());
        }
        return new GradleCommandLine((List<GradleCommandLineTask>)tasks2, (List<? extends GradleCommandLineOption>)options);
    }

    private final GradleCommandLineTask parseTask() {
        String name2 = this.tokenizer.expected();
        ArrayList<GradleCommandLineOption> options = new ArrayList<GradleCommandLineOption>();
        while (!this.tokenizer.isEof()) {
            GradleCommandLineOption option;
            Collection<Option> collection = ALL_TASK_OPTIONS;
            Intrinsics.checkNotNullExpressionValue(collection, (String)"ALL_TASK_OPTIONS");
            if (this.tryParseOption(collection) == null) break;
            options.add(option);
        }
        return new GradleCommandLineTask(name2, (List<? extends GradleCommandLineOption>)options);
    }

    /*
     * WARNING - void declaration
     */
    private final GradleCommandLineOption tryParseOption(Collection<? extends Option> options) {
        GradleCommandLineOption longOption;
        GradleCommandLineOption shortOption;
        GradleCommandLineOption.VarargNotation option;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Map map;
        void $this$associateByTo$iv$iv2;
        Sequence $this$associateBy$iv2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)options), (Function1)tryParseOption.shortOptionsIndex.1.INSTANCE);
        boolean $i$f$associateBy22 = false;
        Sequence sequence = $this$associateBy$iv2;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
            void it;
            Option option2 = (Option)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            map.put("-" + it.getOpt(), element$iv$iv);
        }
        Map shortOptionsIndex2 = destination$iv$iv;
        Sequence $i$f$associateBy22 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)options), (Function1)tryParseOption.longOptionsIndex.1.INSTANCE);
        boolean $i$f$associateBy = false;
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Option bl = (Option)element$iv$iv;
            map = destination$iv$iv2;
            boolean bl2 = false;
            map.put("--" + it.getLongOpt(), element$iv$iv);
        }
        Map longOptionsIndex2 = destination$iv$iv2;
        int marker = this.tokenizer.mark();
        GradleCommandLineOption.VarargNotation varargNotation = option = this.tryParseOptionWithArguments(MapsKt.plus((Map)shortOptionsIndex2, (Map)longOptionsIndex2));
        if (varargNotation != null) {
            return varargNotation;
        }
        this.tokenizer.rollback(marker);
        GradleCommandLineOption gradleCommandLineOption = shortOption = this.tryParseShortPrefixOption(shortOptionsIndex2);
        if (gradleCommandLineOption != null) {
            return gradleCommandLineOption;
        }
        this.tokenizer.rollback(marker);
        GradleCommandLineOption gradleCommandLineOption2 = longOption = this.tryParseLongPrefixOption(longOptionsIndex2);
        if (gradleCommandLineOption2 != null) {
            return gradleCommandLineOption2;
        }
        this.tokenizer.rollback(marker);
        return null;
    }

    private final GradleCommandLineOption.VarargNotation tryParseOptionWithArguments(Map<String, ? extends Option> options) {
        String name2 = this.tokenizer.expected();
        Option option = options.get(name2);
        if (option == null) {
            return null;
        }
        Option option2 = option;
        ArrayList<String> values = new ArrayList<String>();
        switch (option2.getArgs()) {
            case -1: {
                break;
            }
            case -2: {
                while (!this.tokenizer.isEof()) {
                    String optionValue = this.tokenizer.expected();
                    values.add(optionValue);
                }
                break;
            }
            default: {
                int n = option2.getArgs();
                for (int i = 0; i < n; ++i) {
                    int it = i;
                    boolean bl = false;
                    if (this.tokenizer.isEof()) continue;
                    String optionValue = this.tokenizer.expected();
                    values.add(optionValue);
                }
            }
        }
        return new GradleCommandLineOption.VarargNotation(name2, (List<String>)values);
    }

    private final GradleCommandLineOption tryParseShortPrefixOption(Map<String, ? extends Option> options) {
        String token = this.tokenizer.expected();
        for (Map.Entry<String, ? extends Option> entry : options.entrySet()) {
            String name2 = entry.getKey();
            Option option = entry.getValue();
            if (option.getArgs() != 1 || !StringsKt.startsWith$default((String)token, (String)name2, (boolean)false, (int)2, null)) continue;
            String value = StringsKt.removePrefix((String)token, (CharSequence)name2);
            if (StringsKt.contains$default((CharSequence)value, (char)'=', (boolean)false, (int)2, null)) {
                String propertyName = StringsKt.substringBefore$default((String)value, (char)'=', null, (int)2, null);
                String propertyValue = StringsKt.substringAfter$default((String)value, (char)'=', null, (int)2, null);
                return new GradleCommandLineOption.PropertyNotation(name2, propertyName, propertyValue);
            }
            return new GradleCommandLineOption.ShortNotation(name2, value);
        }
        return null;
    }

    private final GradleCommandLineOption tryParseLongPrefixOption(Map<String, ? extends Option> options) {
        String token = this.tokenizer.expected();
        for (Map.Entry<String, ? extends Option> entry : options.entrySet()) {
            String name2 = entry.getKey();
            Option option = entry.getValue();
            if (option.getArgs() != 1 || !StringsKt.startsWith$default((String)token, (String)(name2 + "="), (boolean)false, (int)2, null)) continue;
            return new GradleCommandLineOption.LongNotation(name2, StringsKt.removePrefix((String)token, (CharSequence)(name2 + "=")));
        }
        return null;
    }

    static {
        Collection collection = GradleCommandLineOptionsProvider.OPTIONS.getOptions();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"OPTIONS.options");
        Collection collection2 = GradleCommandLineOptionsProvider.UNSUPPORTED_OPTIONS.getOptions();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"UNSUPPORTED_OPTIONS.options");
        ALL_OPTIONS = CollectionsKt.plus((Collection)collection, (Iterable)collection2);
        ALL_TASK_OPTIONS = GradleCommandLineOptionsProvider.TASK_OPTIONS.getOptions();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gradle/util/cmd/GradleCommandLineParser$Companion;", "", "()V", "ALL_OPTIONS", "", "Lorg/apache/commons/cli/Option;", "kotlin.jvm.PlatformType", "ALL_TASK_OPTIONS", "", "", "intellij.gradle.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

