/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.CreateFileAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.module.PluginModuleType;

public final class DevkitActionsUtil {
    private static final Logger LOG = Logger.getInstance(DevkitActionsUtil.class);

    private DevkitActionsUtil() {
    }

    @Nullable
    public static XmlFile choosePluginModuleDescriptor(@NotNull PsiDirectory directory) {
        if (directory == null) {
            DevkitActionsUtil.$$$reportNull$$$0(0);
        }
        Project project = directory.getProject();
        Module module = DevkitActionsUtil.getModule(directory);
        if (module != null) {
            List<XmlFile> xmlFiles = DevkitActionsUtil.choosePluginModuleDescriptors(module);
            if (xmlFiles == null) {
                return null;
            }
            if (!xmlFiles.isEmpty()) {
                assert (xmlFiles.size() == 1);
                return xmlFiles.get(0);
            }
        }
        Messages.showMessageDialog((Project)project, (String)DevKitBundle.message("error.no.plugin.xml", new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        return null;
    }

    @Nullable
    private static List<XmlFile> choosePluginModuleDescriptors(@NotNull Module module) {
        List<Module> pluginModules;
        if (module == null) {
            DevkitActionsUtil.$$$reportNull$$$0(1);
        }
        if ((pluginModules = DevkitActionsUtil.getCandidatePluginModules(module)).isEmpty()) {
            return Collections.emptyList();
        }
        if (pluginModules.size() == 1) {
            XmlFile pluginXml = PluginModuleType.getPluginXml(pluginModules.get(0));
            if (pluginXml != null) {
                return Collections.singletonList(pluginXml);
            }
            return Collections.emptyList();
        }
        List<Module> selectedModules = DevkitActionsUtil.showPluginModuleSelectionDialog(module.getProject(), pluginModules);
        if (selectedModules != null) {
            return ContainerUtil.mapNotNull(selectedModules, m -> PluginModuleType.getPluginXml(m));
        }
        return null;
    }

    @Nullable
    private static List<Module> showPluginModuleSelectionDialog(@NotNull Project project, @NotNull List<Module> pluginModules) {
        if (project == null) {
            DevkitActionsUtil.$$$reportNull$$$0(2);
        }
        if (pluginModules == null) {
            DevkitActionsUtil.$$$reportNull$$$0(3);
        }
        String message = DevKitBundle.message("select.plugin.module.to.patch", new Object[0]);
        ChoosePluginModuleDialog chooseModulesDialog = new ChoosePluginModuleDialog(project, pluginModules, message, null);
        chooseModulesDialog.setSingleSelectionMode();
        chooseModulesDialog.show();
        List selectedModules = chooseModulesDialog.getChosenElements();
        if (selectedModules.isEmpty()) {
            return null;
        }
        return selectedModules;
    }

    @NotNull
    public static List<Module> getCandidatePluginModules(@NotNull Module module) {
        XmlFile currentModulePluginXml;
        if (module == null) {
            DevkitActionsUtil.$$$reportNull$$$0(4);
        }
        if ((currentModulePluginXml = PluginModuleType.getPluginXml(module)) != null) {
            List<Module> list = Collections.singletonList(module);
            if (list == null) {
                DevkitActionsUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<Module> candidateModules = PluginModuleType.getCandidateModules(module);
        Iterator<Module> it = candidateModules.iterator();
        while (it.hasNext()) {
            Module m = it.next();
            if (PluginModuleType.getPluginXml(m) != null) continue;
            it.remove();
        }
        List<Module> list = candidateModules;
        if (list == null) {
            DevkitActionsUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    public static void checkCanCreateClass(@NotNull PsiDirectory directory, String name) {
        if (directory == null) {
            DevkitActionsUtil.$$$reportNull$$$0(7);
        }
        PsiDirectory currentDir = directory;
        String packageName = StringUtil.getPackageName((String)name);
        if (!packageName.isEmpty()) {
            for (String dir : packageName.split("\\.")) {
                PsiDirectory childDir = currentDir.findSubdirectory(dir);
                if (childDir == null) {
                    return;
                }
                currentDir = childDir;
            }
        }
        JavaDirectoryService.getInstance().checkCreateClass(currentDir, StringUtil.getShortName((String)name));
    }

    public static PsiClass createSingleClass(String name, String classTemplateName, PsiDirectory directory) {
        return DevkitActionsUtil.createSingleClass(name, classTemplateName, directory, Collections.emptyMap());
    }

    public static PsiClass createSingleClass(String name, String classTemplateName, PsiDirectory directory, @NotNull Map<String, String> properties) {
        if (properties == null) {
            DevkitActionsUtil.$$$reportNull$$$0(8);
        }
        if (name.contains(".")) {
            String[] names = name.split("\\.");
            for (int i = 0; i < names.length - 1; ++i) {
                directory = CreateFileAction.findOrCreateSubdirectory((PsiDirectory)directory, (String)names[i]);
            }
            name = names[names.length - 1];
        }
        return JavaDirectoryService.getInstance().createClass(directory, name, classTemplateName, false, properties);
    }

    @Nullable
    private static Module getModule(PsiDirectory dir) {
        VirtualFile vFile;
        Project project = dir.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (fileIndex.isInLibrary(vFile = dir.getVirtualFile())) {
            List orderEntries = fileIndex.getOrderEntriesForFile(vFile);
            if (orderEntries.isEmpty()) {
                return null;
            }
            HashSet<Module> modules = new HashSet<Module>();
            for (OrderEntry orderEntry : orderEntries) {
                modules.add(orderEntry.getOwnerModule());
            }
            Module[] candidates = modules.toArray(Module.EMPTY_ARRAY);
            Arrays.sort(candidates, ModuleManager.getInstance((Project)project).moduleDependencyComparator());
            return candidates[0];
        }
        return fileIndex.getModuleForFile(vFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginModules";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/actions/DevkitActionsUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/actions/DevkitActionsUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidatePluginModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "choosePluginModuleDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "choosePluginModuleDescriptors";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showPluginModuleSelectionDialog";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCandidatePluginModules";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkCanCreateClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSingleClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }

    private static class ChoosePluginModuleDialog
    extends ChooseModulesDialog {
        ChoosePluginModuleDialog(Project project, List<? extends Module> items, @NlsContexts.DialogTitle String title, @Nullable @NlsContexts.Label String description2) {
            super(project, items, title, description2);
        }

        @Nls
        protected String getItemLocation(Module item) {
            XmlFile pluginXml = PluginModuleType.getPluginXml(item);
            if (pluginXml == null) {
                return null;
            }
            VirtualFile virtualFile = pluginXml.getVirtualFile();
            VirtualFile projectPath = item.getProject().getBaseDir();
            if (virtualFile == null) {
                LOG.warn("Unexpected null plugin.xml VirtualFile for module: " + item);
            }
            if (projectPath == null) {
                LOG.warn("Unexpected null project basedir VirtualFile for module: " + item);
            }
            if (virtualFile == null || projectPath == null) {
                return null;
            }
            if (VfsUtilCore.isAncestor((VirtualFile)projectPath, (VirtualFile)virtualFile, (boolean)false)) {
                return VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)projectPath, (char)File.separatorChar);
            }
            return virtualFile.getPresentableUrl();
        }
    }
}

