/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.actions.CreateTemplateInPackageAction;
import com.intellij.ide.actions.JavaCreateTemplateInPackageAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.DevkitActionsUtil;
import org.jetbrains.idea.devkit.actions.NewMessageBundleAction;
import org.jetbrains.idea.devkit.actions.NewMessageBundleActionKt;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0014\u0010\u0016\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u0019H\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/idea/devkit/actions/NewMessageBundleAction;", "Lcom/intellij/ide/actions/CreateElementActionBase;", "()V", "create", "", "Lcom/intellij/psi/PsiElement;", "newName", "", "directory", "Lcom/intellij/psi/PsiDirectory;", "(Ljava/lang/String;Lcom/intellij/psi/PsiDirectory;)[Lcom/intellij/psi/PsiElement;", "getActionName", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getErrorTitle", "getOrCreateResourcesRoot", "module", "Lcom/intellij/openapi/module/Module;", "invokeDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "elementsConsumer", "Ljava/util/function/Consumer;", "isAvailable", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "startInWriteAction", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nNewMessageBundleAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewMessageBundleAction.kt\norg/jetbrains/idea/devkit/actions/NewMessageBundleAction\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,155:1\n26#2:156\n*S KotlinDebug\n*F\n+ 1 NewMessageBundleAction.kt\norg/jetbrains/idea/devkit/actions/NewMessageBundleAction\n*L\n64#1:156\n*E\n"})
public final class NewMessageBundleAction
extends CreateElementActionBase {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    protected void invokeDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull Consumer<? super PsiElement[]> elementsConsumer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter(elementsConsumer, (String)"elementsConsumer");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)directory));
        if (module == null) {
            return;
        }
        Module module2 = module;
        String string = module2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
        if (StringsKt.endsWith$default((String)string, (String)".impl", (boolean)false, (int)2, null)) {
            ModuleManager moduleManager = ModuleManager.Companion.getInstance(project);
            String string2 = module2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"module.name");
            if (moduleManager.findModuleByName(StringsKt.removeSuffix((String)string2, (CharSequence)".impl")) != null) {
                Messages.showErrorDialog((Project)project, (String)DevKitBundle.message("action.DevKit.NewMessageBundle.error.message.do.not.put.bundle.to.impl.module", new Object[0]), (String)this.getErrorTitle());
                return;
            }
        }
        CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
        String defaultName = NewMessageBundleActionKt.generateDefaultBundleName(module2);
        String result = Messages.showInputDialog((Project)project, (String)DevKitBundle.message("action.DevKit.NewMessageBundle.label.bundle.name", new Object[0]), (String)DevKitBundle.message("action.DevKit.NewMessageBundle.title.create.new.message.bundle", new Object[0]), null, (String)defaultName, (InputValidator)((InputValidator)validator));
        if (result != null) {
            PsiElement[] psiElementArray = validator.getCreatedElements();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"validator.createdElements");
            elementsConsumer.accept((PsiElement[])psiElementArray);
        }
    }

    @NotNull
    protected PsiElement[] create(@NotNull String newName, @NotNull PsiDirectory directory) {
        PsiDirectory resourcesRoot;
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        PsiClass bundleClass = DevkitActionsUtil.createSingleClass(newName, "MessageBundle.java", directory);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)directory));
        if (module == null) {
            boolean $i$f$emptyArray = false;
            return new PsiElement[0];
        }
        Module module2 = module;
        XmlFile pluginXml = PluginModuleType.getPluginXml(module2);
        if (pluginXml != null) {
            DescriptorUtil.patchPluginXml((arg_0, arg_1) -> NewMessageBundleAction.create$lambda$0(module2, newName, arg_0, arg_1), bundleClass, pluginXml);
        }
        if ((resourcesRoot = this.getOrCreateResourcesRoot(module2)) == null) {
            PsiElement[] $i$f$emptyArray = new PsiElement[1];
            Intrinsics.checkNotNullExpressionValue((Object)bundleClass, (String)"bundleClass");
            $i$f$emptyArray[0] = bundleClass;
            return $i$f$emptyArray;
        }
        Object object = ActionsKt.runWriteAction((Function0)((Function0)new Function0<PsiFile>(resourcesRoot, newName){
            final /* synthetic */ PsiDirectory $resourcesRoot;
            final /* synthetic */ String $newName;
            {
                this.$resourcesRoot = $resourcesRoot;
                this.$newName = $newName;
                super(0);
            }

            @NotNull
            public final PsiFile invoke() {
                String messagesDirName = "messages";
                PsiDirectory psiDirectory = this.$resourcesRoot.findSubdirectory(messagesDirName);
                if (psiDirectory == null) {
                    psiDirectory = this.$resourcesRoot.createSubdirectory(messagesDirName);
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"resourcesRoot.findSubdir\u2026irectory(messagesDirName)");
                PsiDirectory messagesDir = psiDirectory;
                return messagesDir.createFile(this.$newName + ".properties");
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newName: String, directo\u2026ewName.properties\")\n    }");
        PsiFile propertiesFile2 = (PsiFile)object;
        PsiElement[] psiElementArray = new PsiElement[2];
        Intrinsics.checkNotNullExpressionValue((Object)bundleClass, (String)"bundleClass");
        psiElementArray[0] = bundleClass;
        psiElementArray[1] = propertiesFile2;
        return psiElementArray;
    }

    private final PsiDirectory getOrCreateResourcesRoot(Module module) {
        List list = ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInstance(module).getS\u2026esourceRootType.RESOURCE)");
        VirtualFile virtualFile = (VirtualFile)CollectionsKt.firstOrNull((List)list);
        if (virtualFile == null && (virtualFile = NewMessageBundleAction.getOrCreateResourcesRoot$createResourcesRoot(module, this)) == null) {
            return null;
        }
        VirtualFile resourcesRoot = virtualFile;
        return PsiManager.getInstance((Project)module.getProject()).findDirectory(resourcesRoot);
    }

    protected boolean isAvailable(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        if (!PsiUtil.isIdeaProject((Project)dataContext.getData(CommonDataKeys.PROJECT))) {
            return false;
        }
        return CreateTemplateInPackageAction.isAvailable((DataContext)dataContext, (Set)JavaModuleSourceRootTypes.SOURCES, NewMessageBundleAction::isAvailable$lambda$1);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    protected String getErrorTitle() {
        String string = DevKitBundle.message("action.DevKit.NewMessageBundle.error.title.cannot.create.new.message.bundle", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"action.DevKit.N\u2026eate.new.message.bundle\")");
        return string;
    }

    @NotNull
    protected String getActionName(@NotNull PsiDirectory directory, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Object[] objectArray = new Object[]{newName};
        String string = DevKitBundle.message("action.DevKit.NewMessageBundle.action.name.create.new.message.bundle", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"action.DevKit.N\u2026message.bundle\", newName)");
        return string;
    }

    private static final void create$lambda$0(Module $module, String $newName, XmlFile xmlFile, PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        Intrinsics.checkNotNullParameter((Object)$newName, (String)"$newName");
        DomFileElement fileElement = DomManager.getDomManager((Project)$module.getProject()).getFileElement(xmlFile, IdeaPlugin.class);
        if (fileElement != null) {
            GenericDomValue<String> genericDomValue = ((IdeaPlugin)fileElement.getRootElement()).getResourceBundle();
            Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"fileElement.rootElement.resourceBundle");
            GenericDomValue<String> resourceBundle = genericDomValue;
            if (!resourceBundle.exists()) {
                resourceBundle.setValue((Object)("messages." + $newName));
            }
        }
    }

    private static final Void getOrCreateResourcesRoot$reportError(Module $module, @Nls String message) {
        Object[] objectArray = new Object[]{message};
        Notification notification = new Notification("DevKit Errors", DevKitBundle.message("action.DevKit.NewMessageBundle.notification.title.cannot.create.resources.root.for.properties.file", new Object[0]), DevKitBundle.message("action.DevKit.NewMessageBundle.notification.content.cannot.create.resources.root.for.properties.file", objectArray), NotificationType.ERROR);
        Notifications.Bus.notify((Notification)notification, (Project)$module.getProject());
        return null;
    }

    private static final VirtualFile getOrCreateResourcesRoot$createResourcesRoot(Module $module, NewMessageBundleAction this$0) {
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)$module).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getInstance(module).contentRoots");
        VirtualFile virtualFile = (VirtualFile)ArraysKt.singleOrNull((Object[])virtualFileArray);
        if (virtualFile == null) {
            Object[] objectArray = new Object[]{$module.getName()};
            String string = DevKitBundle.message("action.DevKit.NewMessageBundle.error.message.multiple.content.roots.for.module", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"action.DevKit.N\u2026for.module\", module.name)");
            return (VirtualFile)NewMessageBundleAction.getOrCreateResourcesRoot$reportError($module, string);
        }
        VirtualFile contentRoot = virtualFile;
        String resourcesDirName = "resources";
        if (contentRoot.findChild(resourcesDirName) != null) {
            Object[] objectArray = new Object[]{resourcesDirName, contentRoot.getPath()};
            String string = DevKitBundle.message("action.DevKit.NewMessageBundle.error.message.folder.already.exists", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"action.DevKit.N\u2026irName, contentRoot.path)");
            return (VirtualFile)NewMessageBundleAction.getOrCreateResourcesRoot$reportError($module, string);
        }
        if (ProjectFileIndex.getInstance((Project)$module.getProject()).isInSource(contentRoot)) {
            Object[] objectArray = new Object[]{contentRoot.getPath()};
            String string = DevKitBundle.message("action.DevKit.NewMessageBundle.error.message.under.sources.root", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"action.DevKit.N\u2026.root\", contentRoot.path)");
            return (VirtualFile)NewMessageBundleAction.getOrCreateResourcesRoot$reportError($module, string);
        }
        return (VirtualFile)ActionsKt.runWriteAction((Function0)((Function0)new Function0<VirtualFile>(contentRoot, this$0, resourcesDirName, $module){
            final /* synthetic */ VirtualFile $contentRoot;
            final /* synthetic */ NewMessageBundleAction this$0;
            final /* synthetic */ String $resourcesDirName;
            final /* synthetic */ Module $module;
            {
                this.$contentRoot = $contentRoot;
                this.this$0 = $receiver;
                this.$resourcesDirName = $resourcesDirName;
                this.$module = $module;
                super(0);
            }

            @NotNull
            public final VirtualFile invoke() {
                VirtualFile virtualFile = this.$contentRoot.createChildDirectory((Object)((Object)this.this$0), this.$resourcesDirName);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"contentRoot.createChildD\u2026y(this, resourcesDirName)");
                VirtualFile resourcesDir = virtualFile;
                ModuleRootModificationUtil.updateModel((Module)this.$module, arg_0 -> getOrCreateResourcesRoot.createResourcesRoot.1.invoke$lambda$0((Function1)new Function1<ModifiableRootModel, Unit>(resourcesDir){
                    final /* synthetic */ VirtualFile $resourcesDir;
                    {
                        this.$resourcesDir = $resourcesDir;
                        super(1);
                    }

                    public final void invoke(ModifiableRootModel it) {
                        ContentEntry[] contentEntryArray = it.getContentEntries();
                        Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"it.contentEntries");
                        ((ContentEntry)ArraysKt.single((Object[])contentEntryArray)).addSourceFolder(this.$resourcesDir, (JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
                    }
                }, arg_0));
                return resourcesDir;
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }));
    }

    private static final boolean isAvailable$lambda$1(PsiDirectory it) {
        return JavaCreateTemplateInPackageAction.doCheckPackageExists((PsiDirectory)it);
    }
}

