/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ContentDescriptor;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ModuleDescriptorNameConverter
extends ResolvingConverter<IdeaPlugin> {
    @NonNls
    private static final String SUB_DESCRIPTOR_DELIMITER = "/";
    @NonNls
    private static final String SUB_DESCRIPTOR_FILENAME_DELIMITER = ".";
    private static final Key<Double> LOOKUP_PRIORITY = Key.create((String)"LOOKUP_PRIORITY");

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        String moduleName;
        String filePath;
        String value = StringUtil.notNullize((String)s);
        if (ModuleDescriptorNameConverter.isSubDescriptor(value)) {
            filePath = ModuleDescriptorNameConverter.getSubDescriptorFilePath(value);
            moduleName = ModuleDescriptorNameConverter.getSubDescriptorModuleName(value);
        } else {
            filePath = ModuleDescriptorNameConverter.getDescriptorFilePath(value);
            moduleName = value;
        }
        return DevKitBundle.message("plugin.xml.convert.module.descriptor.name", filePath, moduleName);
    }

    @Nullable
    public IdeaPlugin fromString(@Nullable String s, ConvertContext context) {
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        Module currentModule = context.getModule();
        if (currentModule == null) {
            return null;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)context.getProject());
        if (ModuleDescriptorNameConverter.isSubDescriptor(s)) {
            Module module = moduleManager.findModuleByName(ModuleDescriptorNameConverter.getSubDescriptorModuleName(s));
            if (module == null) {
                return null;
            }
            return ModuleDescriptorNameConverter.findDescriptorFile(module, ModuleDescriptorNameConverter.getSubDescriptorFilePath(s));
        }
        Module module = moduleManager.findModuleByName(s);
        if (module == null) {
            return null;
        }
        return ModuleDescriptorNameConverter.findDescriptorFile(module, ModuleDescriptorNameConverter.getDescriptorFilePath(module.getName()));
    }

    @Nullable
    public String toString(@Nullable IdeaPlugin plugin, ConvertContext context) {
        if (plugin == null) {
            return null;
        }
        return ModuleDescriptorNameConverter.getDisplayName(plugin);
    }

    @NotNull
    private static String getDisplayName(@NotNull IdeaPlugin plugin) {
        VirtualFile virtualFile;
        String fileName;
        Module module;
        String moduleName;
        if (plugin == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(0);
        }
        if ((moduleName = (module = Objects.requireNonNull(plugin.getModule())).getName()).equals(fileName = (virtualFile = DomUtil.getFile((DomElement)plugin).getVirtualFile()).getNameWithoutExtension())) {
            String string = fileName;
            if (string == null) {
                ModuleDescriptorNameConverter.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = moduleName + SUB_DESCRIPTOR_DELIMITER + StringUtil.substringAfterLast((String)fileName, (String)SUB_DESCRIPTOR_FILENAME_DELIMITER);
        if (string == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public LookupElement createLookupElement(IdeaPlugin plugin) {
        String displayName = ModuleDescriptorNameConverter.getDisplayName(plugin);
        LookupElementBuilder builder = LookupElementBuilder.create((Object)Objects.requireNonNull(this.getPsiElement(plugin)), (String)displayName).withIcon(ElementPresentationManager.getIconForClass(ContentDescriptor.ModuleDescriptor.class)).withBoldness(ModuleDescriptorNameConverter.isSubDescriptor(displayName)).withTypeText(plugin.getPackage().getStringValue());
        Double priority = (Double)plugin.getUserData(LOOKUP_PRIORITY);
        Object object = priority != null ? PrioritizedLookupElement.withPriority((LookupElement)builder, (double)priority) : builder;
        if (object == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(3);
        }
        return object;
    }

    @NotNull
    public Collection<? extends IdeaPlugin> getVariants(ConvertContext context) {
        Module currentModule = context.getModule();
        if (currentModule == null) {
            List list = Collections.emptyList();
            if (list == null) {
                ModuleDescriptorNameConverter.$$$reportNull$$$0(4);
            }
            return list;
        }
        Project project = context.getProject();
        SmartList variants = new SmartList();
        LinkedHashSet dependencies = new LinkedHashSet();
        ModuleUtilCore.getDependencies((Module)currentModule, dependencies);
        dependencies.remove(currentModule);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            boolean prioritize = module == currentModule || dependencies.contains(module);
            String moduleName = module.getName();
            ModuleDescriptorNameConverter.processModuleSourceRoots(module, (Processor<VirtualFile>)((Processor)arg_0 -> ModuleDescriptorNameConverter.lambda$getVariants$2(project, prioritize, module, currentModule, (List)variants, moduleName, arg_0)));
        }
        SmartList smartList = variants;
        if (smartList == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    @Nullable
    private static IdeaPlugin findDescriptorFile(@NotNull Module module, @NotNull String filePath) {
        if (module == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(6);
        }
        if (filePath == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(7);
        }
        Ref ideaPlugin = Ref.create();
        ModuleDescriptorNameConverter.processModuleSourceRoots(module, (Processor<VirtualFile>)((Processor)root -> {
            VirtualFile candidate = root.findChild(filePath);
            if (candidate == null) {
                return true;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(candidate);
            if (DescriptorUtil.isPluginXml(psiFile)) {
                ideaPlugin.set((Object)DescriptorUtil.getIdeaPlugin((XmlFile)psiFile));
                return false;
            }
            return true;
        }));
        return (IdeaPlugin)ideaPlugin.get();
    }

    private static void processModuleSourceRoots(@NotNull Module module, Processor<VirtualFile> processor) {
        if (module == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(8);
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE)) {
            if (processor.process((Object)root)) continue;
            return;
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE)) {
            if (processor.process((Object)root)) continue;
            return;
        }
    }

    @NotNull
    private static String getDescriptorFilePath(@NotNull String fileName) {
        if (fileName == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(9);
        }
        String string = fileName + ".xml";
        if (string == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static boolean isSubDescriptor(@NotNull String value) {
        if (value == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(11);
        }
        return StringUtil.contains((CharSequence)value, (CharSequence)SUB_DESCRIPTOR_DELIMITER);
    }

    @NotNull
    private static String getSubDescriptorModuleName(@NotNull String value) {
        if (value == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(12);
        }
        String moduleName = StringUtil.substringBefore((String)value, (String)SUB_DESCRIPTOR_DELIMITER);
        assert (moduleName != null) : value;
        String string = moduleName;
        if (string == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String getSubDescriptorFilePath(@NotNull String value) {
        if (value == null) {
            ModuleDescriptorNameConverter.$$$reportNull$$$0(14);
        }
        String moduleName = ModuleDescriptorNameConverter.getSubDescriptorModuleName(value);
        String fileName = StringUtil.substringAfter((String)value, (String)SUB_DESCRIPTOR_DELIMITER);
        assert (fileName != null) : value;
        return ModuleDescriptorNameConverter.getDescriptorFilePath(moduleName + SUB_DESCRIPTOR_FILENAME_DELIMITER + fileName);
    }

    private static /* synthetic */ boolean lambda$getVariants$2(Project project, boolean prioritize, Module module, Module currentModule, List variants, String moduleName, VirtualFile root) {
        Collection<IdeaPlugin> plugins = DescriptorUtil.getPlugins(project, GlobalSearchScopes.directoryScope((Project)project, (VirtualFile)root, (boolean)false));
        if (prioritize) {
            plugins.forEach(plugin -> plugin.putUserData(LOOKUP_PRIORITY, module == currentModule ? 200.0 : 100.0));
        }
        variants.addAll(ContainerUtil.filter(plugins, plugin -> DomUtil.getFile((DomElement)plugin).getName().startsWith(moduleName)));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/dom/impl/ModuleDescriptorNameConverter";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/dom/impl/ModuleDescriptorNameConverter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorFilePath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubDescriptorModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 13: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findDescriptorFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processModuleSourceRoots";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorFilePath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSubDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSubDescriptorModuleName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSubDescriptorFilePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 10, 13 -> new IllegalStateException(string);
        };
    }
}

