/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.CancellationCheckProvider;
import org.jetbrains.idea.devkit.inspections.CancellationCheckProviders;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.CancellationCheckInLoopsFixProvider;
import org.jetbrains.idea.devkit.inspections.quickfix.CancellationCheckInLoopsFixProviders;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UDoWhileExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UForEachExpression;
import org.jetbrains.uast.UForExpression;
import org.jetbrains.uast.ULoopExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UWhileExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/devkit/inspections/CancellationCheckInLoopsInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "()V", "bodyExpressions", "", "Lorg/jetbrains/uast/UExpression;", "Lorg/jetbrains/uast/ULoopExpression;", "getBodyExpressions", "(Lorg/jetbrains/uast/ULoopExpression;)Ljava/util/List;", "buildInternalVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "inspectLoopExpression", "", "loopExpression", "checkProvider", "Lorg/jetbrains/idea/devkit/inspections/CancellationCheckProvider;", "shouldBeRunOn", "uElement", "Lorg/jetbrains/uast/UElement;", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nCancellationCheckInLoopsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CancellationCheckInLoopsInspection.kt\norg/jetbrains/idea/devkit/inspections/CancellationCheckInLoopsInspection\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,96:1\n37#2,2:97\n18#3:99\n*S KotlinDebug\n*F\n+ 1 CancellationCheckInLoopsInspection.kt\norg/jetbrains/idea/devkit/inspections/CancellationCheckInLoopsInspection\n*L\n74#1:97,2\n82#1:99\n*E\n"})
public final class CancellationCheckInLoopsInspection
extends DevKitUastInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        CancellationCheckProvider cancellationCheckProvider = (CancellationCheckProvider)CancellationCheckProviders.INSTANCE.forLanguage(holder.getFile().getLanguage());
        if (cancellationCheckProvider == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        CancellationCheckProvider checkProvider = cancellationCheckProvider;
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"holder.file.language");
        Class[] classArray = new Class[]{ULoopExpression.class};
        return UastHintedVisitorAdapter.Companion.create$default((UastHintedVisitorAdapter.Companion)UastHintedVisitorAdapter.Companion, (Language)language, (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(this, checkProvider, holder){
            final /* synthetic */ CancellationCheckInLoopsInspection this$0;
            final /* synthetic */ CancellationCheckProvider $checkProvider;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$checkProvider = $checkProvider;
                this.$holder = $holder;
            }

            public boolean visitForExpression(@NotNull UForExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                CancellationCheckInLoopsInspection.access$inspectLoopExpression(this.this$0, (ULoopExpression)node, this.$checkProvider, this.$holder);
                return true;
            }

            public boolean visitForEachExpression(@NotNull UForEachExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                CancellationCheckInLoopsInspection.access$inspectLoopExpression(this.this$0, (ULoopExpression)node, this.$checkProvider, this.$holder);
                return true;
            }

            public boolean visitWhileExpression(@NotNull UWhileExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                CancellationCheckInLoopsInspection.access$inspectLoopExpression(this.this$0, (ULoopExpression)node, this.$checkProvider, this.$holder);
                return true;
            }

            public boolean visitDoWhileExpression(@NotNull UDoWhileExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                CancellationCheckInLoopsInspection.access$inspectLoopExpression(this.this$0, (ULoopExpression)node, this.$checkProvider, this.$holder);
                return true;
            }
        }, (Class[])classArray, (boolean)false, (int)8, null);
    }

    private final void inspectLoopExpression(ULoopExpression loopExpression, CancellationCheckProvider checkProvider, ProblemsHolder holder) {
        PsiElement firstExpressionInLoopSourcePsi;
        PsiElement psiElement = loopExpression.getSourcePsi();
        if (psiElement == null) {
            return;
        }
        PsiElement sourcePsi = psiElement;
        if (!this.shouldBeRunOn((UElement)loopExpression)) {
            return;
        }
        UExpression firstExpressionInLoop = (UExpression)CollectionsKt.firstOrNull(this.getBodyExpressions(loopExpression));
        if (firstExpressionInLoop instanceof ULoopExpression) {
            return;
        }
        String cancellationCheckFqn = checkProvider.findCancellationCheckCall(sourcePsi);
        UExpression uExpression = firstExpressionInLoop;
        Object object = firstExpressionInLoopSourcePsi = uExpression != null ? uExpression.getSourcePsi() : null;
        if (firstExpressionInLoopSourcePsi != null && checkProvider.isCancellationCheckCall(firstExpressionInLoopSourcePsi, cancellationCheckFqn)) {
            return;
        }
        PsiElement anchor = sourcePsi.getFirstChild();
        CancellationCheckInLoopsFixProvider cancellationCheckInLoopsFixProvider = (CancellationCheckInLoopsFixProvider)CancellationCheckInLoopsFixProviders.INSTANCE.forLanguage(holder.getFile().getLanguage());
        if (cancellationCheckInLoopsFixProvider == null) {
            return;
        }
        CancellationCheckInLoopsFixProvider fixProvider = cancellationCheckInLoopsFixProvider;
        Intrinsics.checkNotNullExpressionValue((Object)anchor, (String)"anchor");
        List<LocalQuickFix> fixes = fixProvider.getFixes(anchor, cancellationCheckFqn);
        Object[] objectArray = new Object[]{cancellationCheckFqn};
        String string = DevKitBundle.message("inspection.cancellation.check.in.loops.message", objectArray);
        Collection $this$toTypedArray$iv = fixes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
        holder.registerProblem(anchor, string, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
    }

    private final boolean shouldBeRunOn(UElement uElement) {
        UElement $this$getParentOfType_u24default$iv = uElement;
        boolean strict$iv = true;
        UElement $this$getParentOfType$iv$iv = $this$getParentOfType_u24default$iv;
        boolean $i$f$getParentOfType = false;
        UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv, UMethod.class, (boolean)strict$iv);
        if (uMethod == null) {
            return false;
        }
        UMethod containingMethod = uMethod;
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)containingMethod.getJavaPsi()), (String)RequiresReadLock.class.getCanonicalName(), (int)1);
    }

    private final List<UExpression> getBodyExpressions(ULoopExpression $this$bodyExpressions) {
        UExpression loopBody = $this$bodyExpressions.getBody();
        return loopBody instanceof UBlockExpression ? ((UBlockExpression)loopBody).getExpressions() : CollectionsKt.listOf((Object)$this$bodyExpressions.getBody());
    }

    public static final /* synthetic */ void access$inspectLoopExpression(CancellationCheckInLoopsInspection $this, ULoopExpression loopExpression, CancellationCheckProvider checkProvider, ProblemsHolder holder) {
        $this.inspectLoopExpression(loopExpression, checkProvider, holder);
    }
}

