/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.util.JvmInheritanceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.inspections.DevKitPluginXmlInspectionBase;
import org.jetbrains.idea.devkit.inspections.LightServiceMigrationUtil;
import org.jetbrains.idea.devkit.inspections.ServiceInfo;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/LightServiceMigrationXMLInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitPluginXmlInspectionBase;", "()V", "checkDomElement", "", "element", "Lcom/intellij/util/xml/DomElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "helper", "Lcom/intellij/util/xml/highlighting/DomHighlightingHelper;", "isLibraryClass", "", "aClass", "Lcom/intellij/psi/PsiClass;", "intellij.devkit.core"})
public final class LightServiceMigrationXMLInspection
extends DevKitPluginXmlInspectionBase {
    protected void checkDomElement(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        if (!(element instanceof Extension)) {
            return;
        }
        if (!this.isAllowed(holder)) {
            return;
        }
        if (LightServiceMigrationUtil.isVersion193OrHigher(element) || ApplicationManager.getApplication().isUnitTestMode()) {
            ServiceInfo serviceInfo = LightServiceMigrationUtil.getServiceImplementation((Extension)element);
            if (serviceInfo == null) {
                return;
            }
            ServiceInfo serviceInfo2 = serviceInfo;
            PsiClass aClass = serviceInfo2.component1();
            Service.Level level = serviceInfo2.component2();
            if (!aClass.hasModifier(JvmModifier.FINAL) || this.isLibraryClass(aClass)) {
                return;
            }
            if (level == Service.Level.APP && JvmInheritanceUtil.isInheritor((JvmClass)((JvmClass)aClass), (String)PersistentStateComponent.class.getCanonicalName())) {
                return;
            }
            UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)((PsiElement)aClass), UClass.class);
            if (uClass == null || LightServiceMigrationUtil.containsUnitTestOrHeadlessModeCheck(uClass)) {
                return;
            }
            if (aClass.hasAnnotation(Service.class.getCanonicalName())) {
                String message = DevKitBundle.message("inspection.light.service.migration.already.annotated.message", new Object[0]);
                holder.createProblem(element, ProblemHighlightType.ERROR, message, null, new LocalQuickFix[0]);
            } else {
                String message = LightServiceMigrationUtil.getMessage(level);
                holder.createProblem(element, message, new LocalQuickFix[0]);
            }
        }
    }

    private final boolean isLibraryClass(PsiClass aClass) {
        VirtualFile containingVirtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)aClass));
        return containingVirtualFile != null && ProjectFileIndex.getInstance((Project)aClass.getProject()).isInLibraryClasses(containingVirtualFile);
    }
}

